/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.output;

import adams.core.TextSupporter;
import adams.core.io.FileUtils;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.BaseTextPaneWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.tools.wekainvestigator.output.AbstractOutputPanelWithPopupMenu;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class TextualContentPanel
extends AbstractOutputPanelWithPopupMenu<TextFileChooser>
implements TextSupporter {
    private static final long serialVersionUID = 8183731075946484533L;
    protected JComponent m_Component;

    public TextualContentPanel(JTextComponent comp, boolean useScrollPane) {
        this.initGUI(comp, useScrollPane);
    }

    public TextualContentPanel(BaseTextAreaWithButtons comp, boolean useScrollPane) {
        this.initGUI((JComponent)comp, useScrollPane);
    }

    public TextualContentPanel(BaseTextPaneWithButtons comp, boolean useScrollPane) {
        this.initGUI((JComponent)comp, useScrollPane);
    }

    protected void initGUI(JComponent comp, boolean useScrollPane) {
        this.m_Component = comp;
        this.setPreferredSize(new Dimension(GUIHelper.getDefaultTinyDialogDimension()));
        if (useScrollPane) {
            this.getContentPanel().add((Component)new BaseScrollPane((Component)this.m_Component), (Object)"Center");
        } else {
            this.getContentPanel().add((Component)this.m_Component, (Object)"Center");
        }
    }

    public JComponent getComponent() {
        return this.m_Component;
    }

    @Override
    protected TextFileChooser createFileChooser() {
        TextFileChooser result = new TextFileChooser();
        result.setAcceptAllFileFilterUsed(true);
        result.setAutoAppendExtension(false);
        return result;
    }

    @Override
    protected String save(File file) {
        String msg;
        Object result = null;
        String content = this.supplyText();
        if (content == null) {
            result = "Unhandled component: " + this.m_Component.getClass().getName();
        }
        if (result == null && (msg = FileUtils.writeToFileMsg((String)file.getAbsolutePath(), (Object)content, (boolean)false, (String)((TextFileChooser)this.getFileChooser()).getEncoding())) != null) {
            result = msg;
        }
        return result;
    }

    public String supplyText() {
        String result = this.m_Component instanceof JTextComponent ? ((JTextComponent)this.m_Component).getText() : (this.m_Component instanceof BaseTextAreaWithButtons ? ((BaseTextAreaWithButtons)this.m_Component).getText() : (this.m_Component instanceof BaseTextPaneWithButtons ? ((BaseTextPaneWithButtons)this.m_Component).getText() : null));
        return result;
    }

    @Override
    public boolean canCopyToClipboard() {
        return true;
    }

    @Override
    public void copyToClipboard() {
        ClipboardHelper.copyToClipboard((String)this.supplyText());
    }
}

