/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.core.CleanUpHandler;
import adams.core.MessageCollection;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractParameterMapReader;
import adams.data.io.output.AbstractParameterMapWriter;
import adams.gui.chooser.ParameterMapFileChooser;
import adams.gui.core.DetachablePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.event.WekaInvestigatorDataListener;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainerList;
import adams.gui.tools.wekainvestigator.job.InvestigatorTabJob;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractInvestigatorTab
extends DetachablePanel
implements WekaInvestigatorDataListener,
StatusMessageHandler,
CleanUpHandler {
    private static final long serialVersionUID = 1860821657853747908L;
    protected InvestigatorPanel m_Owner;
    protected Thread m_Worker;
    protected ParameterMapFileChooser m_FileChooserParameters;

    protected void initialize() {
        super.initialize();
        this.m_Worker = null;
    }

    public void setOwner(InvestigatorPanel value) {
        this.m_Owner = value;
        this.dataChanged(new WekaInvestigatorDataEvent(this.m_Owner));
    }

    public InvestigatorPanel getOwner() {
        return this.m_Owner;
    }

    public abstract String getTitle();

    public String getTabIcon() {
        return null;
    }

    protected ParameterMapFileChooser getFileChooserParameters() {
        if (this.m_FileChooserParameters == null) {
            this.m_FileChooserParameters = new ParameterMapFileChooser();
        }
        return this.m_FileChooserParameters;
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu result = super.createPopupMenu();
        int index = this.getOwner().getTabbedPane().indexOfComponent((Component)((Object)this));
        JMenuItem item = new JMenuItem("Copy", ImageManager.getIcon((String)"copy.gif"));
        item.addActionListener(e -> this.getOwner().getTabbedPane().copyTabAt(index));
        result.add(item);
        if (this.serialize(new HashSet<SerializationOption>(Arrays.asList(SerializationOption.PARAMETERS))) instanceof Map) {
            item = new JMenuItem("Save parameters...", ImageManager.getIcon((String)"save.gif"));
            item.addActionListener(e -> this.saveParameters());
            result.add(item);
            item = new JMenuItem("Load parameters...", ImageManager.getIcon((String)"open.gif"));
            item.addActionListener(e -> this.loadParameters());
            result.add(item);
        }
        result.add((JMenuItem)this.getOwner().getTabbedPane().getTabMoveSubMenu(index));
        item = new JMenuItem("Close", ImageManager.getIcon((String)"close_tab_focused.gif"));
        item.addActionListener(e -> {
            if (this.getOwner().getTabbedPane().canCloseTab(index)) {
                this.getOwner().getTabbedPane().removeTabAt(index);
            }
        });
        result.addSeparator();
        result.add(item);
        return result;
    }

    public DataContainerList getData() {
        return this.getOwner().getData();
    }

    public boolean isBusy() {
        return this.m_Worker != null;
    }

    public boolean canStartExecution() {
        return this.m_Worker == null;
    }

    protected void postStartExecution(InvestigatorTabJob job) {
    }

    public boolean startExecution(InvestigatorTabJob job) {
        if (!this.canStartExecution()) {
            this.logMessage("Busy, cannot start '" + job.getTitle() + "'!");
            return false;
        }
        this.m_Worker = new Thread(job);
        this.m_Worker.start();
        this.postStartExecution(job);
        return true;
    }

    protected void postStopExecution() {
    }

    public void stopExecution() {
        if (this.m_Worker == null) {
            return;
        }
        this.m_Worker.stop();
        this.m_Worker = null;
        this.postStopExecution();
    }

    protected void postExecutionFinished() {
    }

    public void executionFinished() {
        this.m_Worker = null;
        this.postExecutionFinished();
    }

    @Override
    public abstract void dataChanged(WekaInvestigatorDataEvent var1);

    public void fireDataChange(WekaInvestigatorDataEvent e) {
        this.getOwner().fireDataChange(e);
    }

    protected String[] toParamsArray(Object params) {
        if (params == null) {
            return new String[0];
        }
        if (params instanceof String[]) {
            return (String[])params;
        }
        if (params instanceof List) {
            String[] array = new String[((List)params).size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = "" + ((List)params).get(i);
            }
            return array;
        }
        this.logMessage("Failed to turn into string array: " + Utils.classToString((Object)params));
        return new String[0];
    }

    public void saveParameters() {
        int retVal = this.getFileChooserParameters().showSaveDialog((Component)((Object)this.getOwner()));
        if (retVal != 0) {
            return;
        }
        File paramFile = this.getFileChooserParameters().getSelectedFile();
        AbstractParameterMapWriter writer = (AbstractParameterMapWriter)this.getFileChooserParameters().getWriter();
        Map params = (Map)this.serialize(new HashSet<SerializationOption>(Arrays.asList(SerializationOption.PARAMETERS)));
        try {
            writer.write(params, new PlaceholderFile(paramFile));
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)("Failed to write parameters to: " + paramFile), (Throwable)e);
        }
    }

    public void loadParameters() {
        Map params;
        int retVal = this.getFileChooserParameters().showOpenDialog((Component)((Object)this.getOwner()));
        if (retVal != 0) {
            return;
        }
        File paramFile = this.getFileChooserParameters().getSelectedFile();
        AbstractParameterMapReader reader = (AbstractParameterMapReader)this.getFileChooserParameters().getReader();
        try {
            params = reader.read(new PlaceholderFile(paramFile));
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)("Failed to read parameters from: " + paramFile), (Throwable)e);
            return;
        }
        MessageCollection errors = new MessageCollection();
        this.deserialize(params, errors);
        if (!errors.isEmpty()) {
            GUIHelper.showErrorMessage((Component)((Object)this.getOwner()), (String)("Error(s) encountered when loading parameters from: " + paramFile + "\n" + errors));
        }
    }

    protected Map<String, Object> doSerialize(Set<SerializationOption> options) {
        return new HashMap<String, Object>();
    }

    public Object serialize(Set<SerializationOption> options) {
        Map<String, Object> data = this.doSerialize(options);
        return data.size() == 0 ? null : data;
    }

    protected void doDeserialize(Map<String, Object> data, MessageCollection errors) {
    }

    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            this.doDeserialize((Map)data, errors);
        }
    }

    public void logMessage(String msg) {
        if (!msg.isEmpty()) {
            this.getOwner().logMessage("[" + this.getTitle() + "] " + msg);
        }
    }

    public void logError(String msg, Throwable t, String title) {
        this.getOwner().logError("[" + this.getTitle() + "] " + msg, t, title);
    }

    public void logError(String msg, String title) {
        this.getOwner().logError("[" + this.getTitle() + "] " + msg, title);
    }

    public void showStatus(String msg) {
        this.logMessage(msg);
        this.getOwner().showStatus("[" + this.getTitle() + "] " + msg);
    }

    public static enum SerializationOption {
        PARAMETERS,
        DATASETS,
        HISTORY,
        GUI;

    }
}

