/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab;

import adams.gui.core.UndoHandlerWithQuickAccess;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.InvestigatorPanel;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.AbstractInvestigatorTabWithEditableDataTable;
import adams.gui.visualization.instances.InstancesPanel;
import adams.gui.visualization.instances.InstancesTableModel;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataTab
extends AbstractInvestigatorTabWithEditableDataTable
implements ChangeListener {
    private static final long serialVersionUID = -94945456385486233L;
    protected Map<DataContainer, InstancesPanel> m_TableCache;
    protected Map<DataContainer, Date> m_TimestampCache;
    protected Integer m_MaxColWidth;
    protected InstancesPanel m_CurrentPanel;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_TableCache = new HashMap<DataContainer, InstancesPanel>();
        this.m_TimestampCache = new HashMap<DataContainer, Date>();
        this.m_MaxColWidth = null;
        this.m_CurrentPanel = null;
    }

    @Override
    public String getTitle() {
        return "Data";
    }

    @Override
    public String getTabIcon() {
        return "spreadsheet.png";
    }

    @Override
    protected int getDataTableListSelectionMode() {
        return 2;
    }

    @Override
    public void dataChanged(WekaInvestigatorDataEvent e) {
        InstancesPanel panel;
        super.dataChanged(e);
        HashSet<DataContainer> cached = new HashSet<DataContainer>(this.m_TableCache.keySet());
        HashSet<DataContainer> current = new HashSet<DataContainer>();
        for (DataContainer cont : this.getOwner().getData()) {
            current.add(cont);
        }
        cached.removeAll(current);
        for (DataContainer cont : cached) {
            panel = this.m_TableCache.remove(cont);
            panel.getTable().removeChangeListener(this);
            panel.getTable().setCellPopupMenuCustomizer(null);
            this.m_TimestampCache.remove(cont);
        }
        for (DataContainer cont : current) {
            if (!this.m_TimestampCache.containsKey(cont) || cont.lastUpdated().equals(this.m_TimestampCache.get(cont))) continue;
            panel = this.m_TableCache.remove(cont);
            panel.getTable().removeChangeListener(this);
            panel.getTable().setCellPopupMenuCustomizer(null);
            this.m_TimestampCache.remove(cont);
        }
        if (e.getType() == 4) {
            for (Object row : (Object)e.getRows()) {
                DataContainer con = (DataContainer)this.getData().get((int)row);
                panel = this.m_TableCache.remove(con);
                if (panel != null) {
                    panel.getTable().removeChangeListener(this);
                    panel.getTable().setCellPopupMenuCustomizer(null);
                }
                this.m_TimestampCache.remove(con);
            }
        }
        this.displayData();
    }

    @Override
    protected void dataTableSelectionChanged() {
        super.dataTableSelectionChanged();
        this.displayData();
    }

    protected void displayData() {
        if (this.m_MaxColWidth == null) {
            this.m_MaxColWidth = InvestigatorPanel.getProperties().getInteger("Data.MaxColWidth", Integer.valueOf(100));
        }
        if (this.m_Table.getRowCount() > 0 && this.m_Table.getSelectedRow() > -1) {
            boolean setOptimal;
            int index = this.m_Table.getSelectedRow();
            DataContainer cont = (DataContainer)this.getData().get(index);
            if (this.m_TableCache.containsKey(cont)) {
                this.m_CurrentPanel = this.m_TableCache.get(cont);
                setOptimal = false;
            } else {
                InstancesTableModel model = new InstancesTableModel(cont.getData());
                model.setUndoHandler((UndoHandlerWithQuickAccess)this.getData().get(index));
                model.setShowAttributeIndex(true);
                this.m_CurrentPanel = new InstancesPanel();
                this.m_CurrentPanel.setModel(model);
                this.m_CurrentPanel.getTable().setUndoEnabled(true);
                this.m_CurrentPanel.getTable().addChangeListener(this);
                this.m_CurrentPanel.getTable().setTooManyColumnsDefaultWidth(this.m_MaxColWidth);
                this.m_TableCache.put(cont, this.m_CurrentPanel);
                this.m_TimestampCache.put(cont, new Date(cont.lastUpdated().getTime()));
                setOptimal = true;
            }
            this.m_PanelData.removeAll();
            this.m_PanelData.add((Component)((Object)this.m_CurrentPanel), "Center");
            if (this.m_SplitPane.isBottomComponentHidden()) {
                this.m_SplitPane.setDividerLocation(this.m_DefaultDataTableHeight);
                this.m_SplitPane.setBottomComponentHidden(false);
            }
            if (setOptimal) {
                this.m_CurrentPanel.getTable().adaptiveOptimalColumnWidth();
            }
        } else {
            this.m_PanelData.removeAll();
            this.m_SplitPane.setBottomComponentHidden(true);
        }
        this.invalidate();
        this.revalidate();
        this.doLayout();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.getSelectedRows().length > 0) {
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 4, this.getSelectedRows()[0]));
        } else {
            this.fireDataChange(new WekaInvestigatorDataEvent(this.getOwner(), 1));
        }
    }
}

