/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.associatetab;

import adams.core.DateUtils;
import adams.core.Shortening;
import adams.data.spreadsheet.MetaData;
import adams.gui.tools.wekainvestigator.output.AbstractResultItem;
import weka.associations.Associator;
import weka.associations.AssociatorEvaluation;
import weka.core.Instances;

public class ResultItem
extends AbstractResultItem {
    private static final long serialVersionUID = -3409493446200539772L;
    protected AssociatorEvaluation m_Evaluation;
    protected Associator m_Template;
    protected Associator m_Model;
    protected MetaData m_RunInformation;

    public ResultItem(Associator template, Instances header) {
        super(header);
        if (template == null) {
            throw new IllegalArgumentException("Template associator cannot be null!");
        }
        this.m_Template = template;
    }

    @Override
    protected String createName() {
        String result = DateUtils.getTimeFormatterMsecs().format(this.m_Timestamp) + " - " + this.m_Template.getClass().getSimpleName();
        if (this.hasHeader()) {
            result = result + " - " + Shortening.shortenEnd((String)this.m_Header.relationName(), (int)30);
        }
        return result;
    }

    public void update(AssociatorEvaluation evaluation, Associator model, MetaData runInfo) {
        this.m_Model = model;
        this.m_Evaluation = evaluation;
        this.m_RunInformation = runInfo;
    }

    public boolean hasEvaluation() {
        return this.m_Evaluation != null;
    }

    public AssociatorEvaluation getEvaluation() {
        return this.m_Evaluation;
    }

    public Associator getTemplate() {
        return this.m_Template;
    }

    public boolean hasModel() {
        return this.m_Model != null;
    }

    public Associator getModel() {
        return this.m_Model;
    }

    public boolean hasRunInformation() {
        return this.m_RunInformation != null;
    }

    public MetaData getRunInformation() {
        return this.m_RunInformation;
    }

    @Override
    public String toString() {
        Object result = this.getName();
        result = (String)result + ", evaluation=" + this.hasEvaluation() + ", template=" + this.getTemplate().getClass().getName() + ", model=" + this.hasModel() + ", runInfo=" + this.hasRunInformation() + ", header=" + this.hasHeader();
        return result;
    }
}

