/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.history;

import adams.core.MessageCollection;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.ArrayHistogram;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.tools.wekainvestigator.tab.ClassifyTab;
import adams.gui.tools.wekainvestigator.tab.classifytab.PredictionHelper;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.history.AbstractHistoryPopupMenuItem;
import adams.gui.visualization.spreadsheet.HistogramFactory;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JMenuItem;

public class CompareModels
extends AbstractHistoryPopupMenuItem {
    @Override
    public String getCategory() {
        return "Evaluation";
    }

    @Override
    public String getTitle() {
        return "Compare models...";
    }

    protected ArrayHistogram promptHistogramSetup() {
        HistogramFactory.SetupDialog setup = ((ClassifyTab)this.getOwner()).getParentDialog() != null ? HistogramFactory.getSetupDialog((Dialog)((ClassifyTab)this.getOwner()).getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.DOCUMENT_MODAL) : HistogramFactory.getSetupDialog((Frame)((ClassifyTab)this.getOwner()).getParentFrame(), (boolean)true);
        setup.setDefaultCloseOperation(2);
        setup.setTitle("Histogram setup");
        ArrayHistogram result = new ArrayHistogram();
        result.setDisplayRanges(true);
        setup.setCurrent((Object)result);
        setup.setLocationRelativeTo((Component)setup.getParent());
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return null;
        }
        result = (ArrayHistogram)setup.getCurrent();
        return result;
    }

    protected String compareNumeric(String name1, ResultItem item1, String name2, ResultItem item2) {
        double[] predicted2;
        MessageCollection errors = new MessageCollection();
        SpreadSheet sheet1 = PredictionHelper.toSpreadSheet(null, errors, item1, false, false);
        if (sheet1 == null) {
            if (errors.isEmpty()) {
                return "Failed to obtain predictions from first item: " + name1;
            }
            return "Failed to obtain predictions from first item: " + name1 + "\n" + errors;
        }
        errors.clear();
        SpreadSheet sheet2 = PredictionHelper.toSpreadSheet(null, errors, item2, false, false);
        if (sheet2 == null) {
            if (errors.isEmpty()) {
                return "Failed to obtain predictions from second item: " + name2;
            }
            return "Failed to obtain predictions from second item: " + name2 + "\n" + errors;
        }
        double[] predicted1 = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet1, (int)sheet1.getHeaderRow().indexOfContent("Predicted"));
        if (predicted1.length != (predicted2 = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet2, (int)sheet2.getHeaderRow().indexOfContent("Predicted"))).length) {
            return "Differing number of predictions: " + predicted1.length + " != " + predicted2.length;
        }
        double[] diff = new double[predicted1.length];
        DefaultSpreadSheet sheetDiff = new DefaultSpreadSheet();
        sheetDiff.getHeaderRow().addCell("I").setContentAsString("Index");
        sheetDiff.getHeaderRow().addCell("1").setContentAsString(name1);
        sheetDiff.getHeaderRow().addCell("2").setContentAsString(name2);
        sheetDiff.getHeaderRow().addCell("D").setContentAsString("Difference");
        for (int i = 0; i < predicted1.length; ++i) {
            diff[i] = predicted1[i] - predicted2[i];
            DataRow row = sheetDiff.addRow();
            row.addCell("I").setContent(Integer.valueOf(i + 1));
            row.addCell("1").setContent(Double.valueOf(predicted1[i]));
            row.addCell("2").setContent(Double.valueOf(predicted2[i]));
            row.addCell("D").setContent(Double.valueOf(diff[i]));
        }
        ApprovalDialog dialog = ((ClassifyTab)this.getOwner()).getParentDialog() != null ? new ApprovalDialog(((ClassifyTab)this.getOwner()).getParentDialog(), Dialog.ModalityType.MODELESS) : new ApprovalDialog(((ClassifyTab)this.getOwner()).getParentFrame(), false);
        dialog.setTitle("'" + name1 + "' vs '" + name2 + "'");
        BaseTabbedPane tabbedPane = new BaseTabbedPane();
        dialog.getContentPane().add((Component)tabbedPane, "Center");
        SpreadSheetTableModel model = new SpreadSheetTableModel((SpreadSheet)sheetDiff);
        model.setUseSimpleHeader(true);
        model.setReadOnly(true);
        model.setShowRowColumn(false);
        SpreadSheetTable table = new SpreadSheetTable(model);
        table.setNumDecimals(3);
        tabbedPane.addTab("Table", (Component)new BaseScrollPane((Component)table));
        ArrayHistogram arrayHistogram = this.promptHistogramSetup();
        if (arrayHistogram == null) {
            return null;
        }
        HistogramFactory.Panel histogram = new HistogramFactory.Panel();
        histogram.add(arrayHistogram, diff, "Difference");
        tabbedPane.addTab("Histogram", (Component)histogram);
        dialog.setSize(GUIHelper.makeWider((Dimension)GUIHelper.getDefaultDialogDimension()));
        dialog.setLocationRelativeTo(this.getOwner());
        dialog.setVisible(true);
        return null;
    }

    @Override
    public JMenuItem createMenuItem(ClassifyTab.HistoryPanel history, int[] indices) {
        boolean enabled = false;
        if (indices.length == 2) {
            ResultItem item0 = (ResultItem)((Object)history.getEntry(indices[0]));
            ResultItem item1 = (ResultItem)((Object)history.getEntry(indices[1]));
            enabled = item0.hasEvaluation() && item0.getEvaluation().predictions() != null && item1.hasEvaluation() && item1.getEvaluation().predictions() != null && item0.getEvaluation().getHeader().equalHeaders(item0.getEvaluation().getHeader()) && item0.getEvaluation().numInstances() == item0.getEvaluation().numInstances() && item0.getEvaluation().getHeader().classAttribute().isNumeric();
        }
        JMenuItem result = new JMenuItem(this.getTitle());
        result.setEnabled(enabled);
        if (!enabled) {
            return result;
        }
        result.addActionListener(e -> {
            String msg = this.compareNumeric(history.getEntryName(indices[0]), (ResultItem)((Object)((Object)history.getEntry(indices[0]))), history.getEntryName(indices[1]), (ResultItem)((Object)((Object)history.getEntry(indices[1]))));
            if (msg != null) {
                GUIHelper.showErrorMessage(this.getOwner(), (String)msg);
            }
        });
        return result;
    }
}

