/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.WekaPredictionsToSpreadSheet;
import adams.gui.core.BaseTabbedPane;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGeneratorWithSeparateFoldsSupport;
import adams.gui.visualization.stats.fourinone.VersusFit;
import adams.gui.visualization.stats.fourinone.VersusFitOptions;
import adams.gui.visualization.stats.fourinone.VersusOrder;
import adams.gui.visualization.stats.fourinone.VersusOrderOptions;
import adams.gui.visualization.stats.histogram.Histogram;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import adams.gui.visualization.stats.probabilityplot.NormalPlot;
import adams.gui.visualization.stats.probabilityplot.NormalPlotOptions;
import java.awt.Component;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;

public class FourInOnePlot
extends AbstractOutputGeneratorWithSeparateFoldsSupport<ComponentContentPanel> {
    private static final long serialVersionUID = -6829245659118360739L;
    protected boolean m_UseAbsoluteError;
    protected NormalPlotOptions m_NormalPlotOptions;
    protected HistogramOptions m_HistogramOptions;
    protected VersusFitOptions m_VersusFitOptions;
    protected VersusOrderOptions m_VersusOrderOptions;

    public String globalInfo() {
        return "Generates the 4-in-1 plot: normal plot, histogram, residuals vs fit and vs order.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("absolute-error", "useAbsoluteError", (Object)false);
        this.m_OptionManager.add("normal-plot-options", "normalPlotOptions", (Object)new NormalPlotOptions());
        this.m_OptionManager.add("versus-fit-options", "versusFitOptions", (Object)new VersusFitOptions());
        this.m_OptionManager.add("histogram-options", "histogramOptions", (Object)new HistogramOptions());
        this.m_OptionManager.add("versus-order-options", "versusOrderOptions", (Object)new VersusOrderOptions());
    }

    public void setUseAbsoluteError(boolean value) {
        this.m_UseAbsoluteError = value;
        this.reset();
    }

    public boolean getUseAbsoluteError() {
        return this.m_UseAbsoluteError;
    }

    public String useAbsoluteErrorTipText() {
        return "If set to true, then the error will be absolute (no direction).";
    }

    public void setHistogramOptions(HistogramOptions value) {
        this.m_HistogramOptions = value;
        this.reset();
    }

    public HistogramOptions getHistogramOptions() {
        return this.m_HistogramOptions;
    }

    public String histogramOptionsTipText() {
        return "options for the histogram graph";
    }

    public void setVersusOrderOptions(VersusOrderOptions value) {
        this.m_VersusOrderOptions = value;
        this.reset();
    }

    public VersusOrderOptions getVersusOrderOptions() {
        return this.m_VersusOrderOptions;
    }

    public String versusOrderOptionsTipText() {
        return "options for the versus order graph";
    }

    public void setVersusFitOptions(VersusFitOptions value) {
        this.m_VersusFitOptions = value;
        this.reset();
    }

    public VersusFitOptions getVersusFitOptions() {
        return this.m_VersusFitOptions;
    }

    public String versusFitOptionsTipText() {
        return "options for the versus fit graph";
    }

    public void setNormalPlotOptions(NormalPlotOptions value) {
        this.m_NormalPlotOptions = value;
        this.reset();
    }

    public NormalPlotOptions getNormalPlotOptions() {
        return this.m_NormalPlotOptions;
    }

    public String normalPlotOptionsTipText() {
        return "options for normal plot";
    }

    @Override
    public String getTitle() {
        return "4-in-1 plot";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasEvaluation() && item.getEvaluation().predictions() != null && item.getEvaluation().getHeader() != null && item.getEvaluation().getHeader().classAttribute().isNumeric();
    }

    @Override
    protected ComponentContentPanel createOutput(Evaluation eval, MessageCollection errors) {
        BaseTabbedPane tabbedPane = new BaseTabbedPane();
        WekaPredictionsToSpreadSheet p2s = new WekaPredictionsToSpreadSheet();
        p2s.setShowError(true);
        p2s.setUseAbsoluteError(this.m_UseAbsoluteError);
        p2s.input(new Token((Object)eval));
        try {
            p2s.execute();
        }
        catch (Exception e) {
            errors.add("Failed to assemble predictions!", (Throwable)e);
            return null;
        }
        Token token = p2s.output();
        SpreadSheet sheet = (SpreadSheet)token.getPayload();
        NormalPlot normalPlot = new NormalPlot();
        normalPlot.setData(sheet);
        normalPlot.setIndex(2);
        normalPlot.setOptions(this.m_NormalPlotOptions);
        tabbedPane.addTab("Normal plot", (Component)normalPlot);
        Histogram histogram = new Histogram();
        histogram.setData(sheet);
        histogram.setIndex(2);
        histogram.setOptions(this.m_HistogramOptions);
        tabbedPane.addTab("Histogram", (Component)histogram);
        VersusFit vsFit = new VersusFit();
        vsFit.setData(sheet);
        vsFit.setIndices(2, 1);
        vsFit.setOptions(this.m_VersusFitOptions);
        tabbedPane.addTab("Versus Fit", (Component)vsFit);
        VersusOrder vsOrder = new VersusOrder();
        vsOrder.setData(sheet);
        vsOrder.setIndex(2);
        vsOrder.setOptions(this.m_VersusOrderOptions);
        tabbedPane.addTab("Versus Order", (Component)vsOrder);
        return new ComponentContentPanel((JComponent)tabbedPane, true);
    }
}

