/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.classifytab.output;

import adams.core.MessageCollection;
import adams.gui.tools.wekainvestigator.output.ComponentContentPanel;
import adams.gui.tools.wekainvestigator.output.GraphHelper;
import adams.gui.tools.wekainvestigator.tab.classifytab.ResultItem;
import adams.gui.tools.wekainvestigator.tab.classifytab.output.AbstractOutputGenerator;
import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import javax.swing.JComponent;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DirectedPseudograph;
import weka.core.Drawable;
import weka.gui.visualize.plugins.JGraphTTreeVisualization;

public class TreeVisualizer
extends AbstractOutputGenerator {
    private static final long serialVersionUID = -6829245659118360739L;

    public String globalInfo() {
        return "Generates a tree visualization of the model.";
    }

    @Override
    public String getTitle() {
        return "Tree visualizer";
    }

    @Override
    public boolean canGenerateOutput(ResultItem item) {
        return item.hasModel() && item.getModel() instanceof Drawable && GraphHelper.hasGraph((Drawable)item.getModel());
    }

    @Override
    public JComponent createOutput(ResultItem item, MessageCollection errors) {
        try {
            String dotty = ((Drawable)item.getModel()).graph();
            DirectedPseudograph graph = JGraphTTreeVisualization.getSingleton().importDotty(dotty);
            JGraphXAdapter jgxAdapter = new JGraphXAdapter((Graph)graph);
            jgxAdapter.setCellsEditable(false);
            jgxAdapter.setLabelsVisible(true);
            mxGraphComponent component = new mxGraphComponent((mxGraph)jgxAdapter);
            component.getConnectionHandler().setEnabled(false);
            component.setPanning(true);
            component.setConnectable(false);
            component.setDragEnabled(true);
            component.setZoomFactor(5.0);
            component.setZoomPolicy(1);
            mxCompactTreeLayout layout = new mxCompactTreeLayout((mxGraph)jgxAdapter);
            layout.setHorizontal(false);
            layout.execute(jgxAdapter.getDefaultParent());
            return new ComponentContentPanel((JComponent)component, false);
        }
        catch (Exception e) {
            errors.add("Failed to parse/display tree graph!", (Throwable)e);
            return null;
        }
    }
}

