/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab;

import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.core.Utils;

public class AttributeSummaryPanel
extends JPanel {
    static final long serialVersionUID = -5434987925737735880L;
    protected Instances m_Instances = null;
    protected int m_Index = -1;
    protected AttributeStats[] m_AttributeStats;
    protected boolean m_allEqualWeights = true;
    protected AttributeInfoPanel m_InfoPanel;
    protected StatisticsTable m_StatsTable;

    public AttributeSummaryPanel() {
        this.setLayout(new BorderLayout());
        this.m_InfoPanel = new AttributeInfoPanel();
        this.add((Component)this.m_InfoPanel, "North");
        this.m_StatsTable = new StatisticsTable();
        this.add((Component)new BaseScrollPane((Component)((Object)this.m_StatsTable)), "Center");
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_Index = -1;
        this.m_AttributeStats = new AttributeStats[inst != null ? inst.numAttributes() : 0];
        this.m_InfoPanel.clear();
        this.m_StatsTable.clear();
        if (this.m_Instances == null) {
            return;
        }
        this.m_allEqualWeights = true;
        if (this.m_Instances.numInstances() == 0) {
            return;
        }
        double w = this.m_Instances.instance(0).weight();
        for (int i = 1; i < this.m_Instances.numInstances(); ++i) {
            if (this.m_Instances.instance(i).weight() == w) continue;
            this.m_allEqualWeights = false;
            break;
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setAttribute(int index) {
        if (this.m_Instances == null) {
            this.m_Index = -1;
            return;
        }
        this.m_Index = index;
        this.m_InfoPanel.updateLabels(this.m_Instances.attribute(index));
        if (this.m_AttributeStats[index] == null) {
            Thread t = new Thread(() -> {
                this.m_AttributeStats[index] = this.m_Instances.attributeStats(index);
                SwingUtilities.invokeLater(() -> {
                    this.m_InfoPanel.updateStatistics(this.m_AttributeStats[index]);
                    this.m_StatsTable.updateStatistics(this.m_AttributeStats[index], this.m_Instances.attribute(index), this.m_allEqualWeights);
                    this.m_StatsTable.sizeColumnsToFit(-1);
                    this.m_StatsTable.revalidate();
                    this.m_StatsTable.repaint();
                });
            });
            t.setPriority(1);
            t.start();
        } else {
            this.m_InfoPanel.updateStatistics(this.m_AttributeStats[index]);
            this.m_StatsTable.updateStatistics(this.m_AttributeStats[index], this.m_Instances.attribute(index), this.m_allEqualWeights);
        }
    }

    public int getAttribute() {
        return this.m_Index;
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Attribute Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            final weka.gui.AttributeSummaryPanel p = new weka.gui.AttributeSummaryPanel();
            p.setBorder((Border)BorderFactory.createTitledBorder("Attribute"));
            jf.getContentPane().add((Component)p, "Center");
            final BaseComboBox j = new BaseComboBox();
            j.setEnabled(false);
            j.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    p.setAttribute(j.getSelectedIndex());
                }
            });
            jf.getContentPane().add((Component)j, "North");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances inst = new Instances((Reader)r);
                p.setInstances(inst);
                p.setAttribute(0);
                String[] names = new String[inst.numAttributes()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = inst.attribute(i).name();
                }
                j.setModel(new DefaultComboBoxModel<String>(names));
                j.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static class StatisticsTable
    extends BaseTable {
        private static final long serialVersionUID = 7165142874670048578L;

        protected void initGUI() {
            super.initGUI();
            this.setAutoResizeMode(0);
            this.setShowSimpleHeaderPopupMenu(false);
            this.setShowSimpleCellPopupMenu(true);
            this.getSelectionModel().setSelectionMode(2);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void clear() {
            this.setModel(new DefaultTableModel());
        }

        public void updateStatistics(AttributeStats as, Attribute att, boolean allEqualWeights) {
            if (as.nominalCounts != null) {
                Object[] colNames = new Object[]{"No.", "Label", "Count", "Weight"};
                Object[][] data = new Object[as.nominalCounts.length][4];
                for (int i = 0; i < as.nominalCounts.length; ++i) {
                    data[i][0] = i + 1;
                    data[i][1] = att.value(i);
                    data[i][2] = as.nominalCounts[i];
                    data[i][3] = Utils.doubleToString((double)as.nominalWeights[i], (int)3);
                }
                this.setModel(new DefaultTableModel(data, colNames));
                this.getColumnModel().getColumn(0).setMaxWidth(60);
                DefaultTableCellRenderer tempR = new DefaultTableCellRenderer();
                tempR.setHorizontalAlignment(4);
                this.getColumnModel().getColumn(0).setCellRenderer(tempR);
            } else if (as.numericStats != null) {
                Object[] colNames = new Object[]{"Statistic", "Value"};
                Object[][] data = new Object[4][2];
                data[0][0] = "Minimum";
                data[1][0] = "Maximum";
                data[2][0] = "Mean" + (!allEqualWeights ? " (weighted)" : "");
                data[3][0] = "StdDev" + (!allEqualWeights ? " (weighted)" : "");
                if (att.isDate()) {
                    data[0][1] = att.formatDate(as.numericStats.min);
                    data[1][1] = att.formatDate(as.numericStats.max);
                    data[2][1] = att.formatDate(as.numericStats.mean);
                    data[3][1] = att.formatDate(as.numericStats.stdDev);
                } else {
                    data[0][1] = Utils.doubleToString((double)as.numericStats.min, (int)3);
                    data[1][1] = Utils.doubleToString((double)as.numericStats.max, (int)3);
                    data[2][1] = Utils.doubleToString((double)as.numericStats.mean, (int)3);
                    data[3][1] = Utils.doubleToString((double)as.numericStats.stdDev, (int)3);
                }
                this.setModel(new DefaultTableModel(data, colNames));
            } else if (att.isString()) {
                Object[] colNames = new Object[]{"No.", "String value"};
                Object[][] data = new Object[att.numValues()][2];
                for (int i = 0; i < att.numValues(); ++i) {
                    data[i][0] = i + 1;
                    data[i][1] = att.value(i);
                }
                this.setModel(new DefaultTableModel(data, colNames));
            } else {
                this.setModel(new DefaultTableModel());
            }
            this.getColumnModel().setColumnMargin(4);
            this.setOptimalColumnWidth();
        }
    }

    public static class AttributeInfoPanel
    extends JPanel {
        private static final long serialVersionUID = -1404314409077539072L;
        public static final String NO_SOURCE = "None";
        protected JLabel m_AttributeNameLab = new JLabel("None");
        protected JLabel m_AttributeTypeLab = new JLabel("None");
        protected JLabel m_MissingLab = new JLabel("None");
        protected JLabel m_UniqueLab = new JLabel("None");
        protected JLabel m_DistinctLab = new JLabel("None");

        public AttributeInfoPanel() {
            GridBagLayout gbL = new GridBagLayout();
            this.setLayout(gbL);
            JLabel lab = new JLabel("Name:", 4);
            lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            GridBagConstraints gbC = new GridBagConstraints();
            gbC.anchor = 13;
            gbC.fill = 2;
            gbC.gridy = 0;
            gbC.gridx = 0;
            gbL.setConstraints(lab, gbC);
            this.add(lab);
            gbC = new GridBagConstraints();
            gbC.anchor = 17;
            gbC.fill = 2;
            gbC.gridy = 0;
            gbC.gridx = 1;
            gbC.weightx = 100.0;
            gbC.gridwidth = 3;
            gbL.setConstraints(this.m_AttributeNameLab, gbC);
            this.add(this.m_AttributeNameLab);
            this.m_AttributeNameLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
            lab = new JLabel("Type:", 4);
            lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            gbC = new GridBagConstraints();
            gbC.anchor = 13;
            gbC.fill = 2;
            gbC.gridy = 0;
            gbC.gridx = 4;
            gbL.setConstraints(lab, gbC);
            this.add(lab);
            gbC = new GridBagConstraints();
            gbC.anchor = 17;
            gbC.fill = 2;
            gbC.gridy = 0;
            gbC.gridx = 5;
            gbC.weightx = 100.0;
            gbL.setConstraints(this.m_AttributeTypeLab, gbC);
            this.add(this.m_AttributeTypeLab);
            this.m_AttributeTypeLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
            lab = new JLabel("Missing:", 4);
            lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
            gbC = new GridBagConstraints();
            gbC.anchor = 13;
            gbC.fill = 2;
            gbC.gridy = 1;
            gbC.gridx = 0;
            gbL.setConstraints(lab, gbC);
            this.add(lab);
            gbC = new GridBagConstraints();
            gbC.anchor = 17;
            gbC.fill = 2;
            gbC.gridy = 1;
            gbC.gridx = 1;
            gbC.weightx = 100.0;
            gbL.setConstraints(this.m_MissingLab, gbC);
            this.add(this.m_MissingLab);
            this.m_MissingLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
            lab = new JLabel("Distinct:", 4);
            lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
            gbC = new GridBagConstraints();
            gbC.anchor = 13;
            gbC.fill = 2;
            gbC.gridy = 1;
            gbC.gridx = 2;
            gbL.setConstraints(lab, gbC);
            this.add(lab);
            gbC = new GridBagConstraints();
            gbC.anchor = 17;
            gbC.fill = 2;
            gbC.gridy = 1;
            gbC.gridx = 3;
            gbC.weightx = 100.0;
            gbL.setConstraints(this.m_DistinctLab, gbC);
            this.add(this.m_DistinctLab);
            this.m_DistinctLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
            lab = new JLabel("Unique:", 4);
            lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
            gbC = new GridBagConstraints();
            gbC.anchor = 13;
            gbC.fill = 2;
            gbC.gridy = 1;
            gbC.gridx = 4;
            gbL.setConstraints(lab, gbC);
            this.add(lab);
            gbC = new GridBagConstraints();
            gbC.anchor = 17;
            gbC.fill = 2;
            gbC.gridy = 1;
            gbC.gridx = 5;
            gbC.weightx = 100.0;
            gbL.setConstraints(this.m_UniqueLab, gbC);
            this.add(this.m_UniqueLab);
            this.m_UniqueLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        }

        public void clear() {
            this.m_AttributeNameLab.setText(NO_SOURCE);
            this.m_AttributeTypeLab.setText(NO_SOURCE);
            this.m_MissingLab.setText(NO_SOURCE);
            this.m_UniqueLab.setText(NO_SOURCE);
            this.m_DistinctLab.setText(NO_SOURCE);
        }

        public void updateStatistics(AttributeStats as) {
            long percent = Math.round(100.0 * (double)as.missingCount / (double)as.totalCount);
            this.m_MissingLab.setText(as.missingCount + " (" + percent + "%)");
            percent = Math.round(100.0 * (double)as.uniqueCount / (double)as.totalCount);
            this.m_UniqueLab.setText(as.uniqueCount + " (" + percent + "%)");
            this.m_DistinctLab.setText("" + as.distinctCount);
        }

        public void updateLabels(Attribute att) {
            this.m_AttributeNameLab.setText(att.name());
            switch (att.type()) {
                case 1: {
                    this.m_AttributeTypeLab.setText("Nominal");
                    break;
                }
                case 0: {
                    this.m_AttributeTypeLab.setText("Numeric");
                    break;
                }
                case 2: {
                    this.m_AttributeTypeLab.setText("String");
                    break;
                }
                case 3: {
                    this.m_AttributeTypeLab.setText("Date");
                    break;
                }
                case 4: {
                    this.m_AttributeTypeLab.setText("Relational");
                    break;
                }
                default: {
                    this.m_AttributeTypeLab.setText("Unknown");
                }
            }
            this.m_MissingLab.setText("...");
            this.m_UniqueLab.setText("...");
            this.m_DistinctLab.setText("...");
        }
    }
}

