/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction;

import adams.gui.core.BaseButton;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.WekaInvestigatorDataEvent;
import adams.gui.tools.wekainvestigator.data.DataContainer;
import adams.gui.tools.wekainvestigator.tab.preprocesstab.attributeselaction.AbstractSelectedAttributesAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;

public class ReorderAttributes
extends AbstractSelectedAttributesAction {
    private static final long serialVersionUID = -6999154336311879167L;

    public ReorderAttributes() {
        this.setName("Reorder attributes");
        this.setIcon("sort-ascending.png");
        this.setAsynchronous(true);
    }

    @Override
    public void update() {
        this.setEnabled(this.getOwner() != null && !this.isBusy() && this.getSelectedRows().length == 1 && this.m_Owner.canStartExecution());
    }

    protected void doActionPerformed(ActionEvent e) {
        int i;
        DataContainer cont = this.getSelectedData()[0];
        Instances data = cont.getData();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (i = 0; i < data.numAttributes(); ++i) {
            model.addElement(data.attribute(i).name());
        }
        BaseListWithButtons list = new BaseListWithButtons(model);
        BaseButton buttonUp = new BaseButton((Icon)ImageManager.getIcon((String)"arrow_up.gif"));
        buttonUp.addActionListener(ae -> list.moveUp());
        list.addToButtonsPanel((Component)buttonUp);
        BaseButton buttonDown = new BaseButton((Icon)ImageManager.getIcon((String)"arrow_down.gif"));
        buttonDown.addActionListener(ae -> list.moveDown());
        list.addToButtonsPanel((Component)buttonDown);
        list.addListSelectionListener(ae -> {
            buttonUp.setEnabled(list.canMoveUp());
            buttonDown.setEnabled(list.canMoveDown());
        });
        ApprovalDialog dialog = this.getOwner().getParentDialog() != null ? new ApprovalDialog(this.getOwner().getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getOwner().getParentFrame(), true);
        dialog.setTitle(this.getName());
        dialog.getContentPane().add((Component)list, "Center");
        dialog.setSize(GUIHelper.getDefaultSmallDialogDimension());
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (i = 0; i < data.numAttributes(); ++i) {
            indices.put(data.attribute(i).name(), i + 1);
        }
        StringBuilder indicesStr = new StringBuilder();
        for (i = 0; i < model.getSize(); ++i) {
            if (i > 0) {
                indicesStr.append(",");
            }
            indicesStr.append(indices.get(model.get(i)));
        }
        try {
            Reorder reorder = new Reorder();
            reorder.setAttributeIndices(indicesStr.toString());
            reorder.setInputFormat(data);
            Instances filtered = Filter.useFilter((Instances)data, (Filter)reorder);
            cont.addUndoPoint("Reordering attributes");
            cont.setData(filtered);
            WekaInvestigatorDataEvent event = new WekaInvestigatorDataEvent(this.getOwner().getOwner(), 4, new int[]{this.getSelectedRows()[0]});
            this.getOwner().fireDataChange(event);
        }
        catch (Exception ex) {
            this.logError("Failed to reorder attributes!", ex, "Reorder failed");
        }
    }
}

