/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.experiment;

import adams.core.ObjectCopyHelper;
import adams.core.ThreadLimiter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import adams.multiprocess.WekaCrossValidationExecution;
import weka.classifiers.Classifier;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.DefaultCrossValidationFoldGenerator;
import weka.core.Instances;

public class CrossValidationExperiment
extends AbstractExperiment {
    private static final long serialVersionUID = -4147644361063132314L;
    protected int m_Folds;
    protected CrossValidationFoldGenerator m_Generator;

    public String globalInfo() {
        return "Performs cross-validation on each classifier/dataset combination.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)-1, null);
        this.m_OptionManager.add("generator", "generator", (Object)new DefaultCrossValidationFoldGenerator());
    }

    public void setFolds(int value) {
        this.m_Folds = value;
        this.reset();
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to perform.";
    }

    public void setGenerator(CrossValidationFoldGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public CrossValidationFoldGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The scheme to use for generating the folds; the actor options take precedence over the scheme's ones.";
    }

    @Override
    protected boolean isComplete(int[] rows) {
        return rows.length == this.m_Folds;
    }

    protected CrossValidationExperimentJob evaluate(int currentRun, Classifier cls, Instances data) {
        return new CrossValidationExperimentJob(this, currentRun, cls, data);
    }

    public static class CrossValidationExperimentJob
    extends AbstractExperiment.AbstractExperimentJob<CrossValidationExperiment> {
        private static final long serialVersionUID = -4979824848864995696L;
        protected WekaCrossValidationExecution m_CrossValidation;

        public CrossValidationExperimentJob(CrossValidationExperiment owner, int run, Classifier classifier, Instances data) {
            super(owner, run, classifier, data);
        }

        @Override
        protected void evaluate() {
            ((CrossValidationExperiment)this.m_Owner).log("Run " + this.m_Run + " [start]: " + this.m_Data.relationName() + " on " + AbstractExperiment.shortenCommandLine(this.m_Classifier));
            boolean simple = ((CrossValidationExperiment)this.m_Owner).getDatasets().length == 1 && ((CrossValidationExperiment)this.m_Owner).getClassifiers().length == 1;
            this.m_CrossValidation = new WekaCrossValidationExecution();
            this.m_CrossValidation.setClassifier(this.m_Classifier);
            this.m_CrossValidation.setData(this.m_Data);
            this.m_CrossValidation.setFolds(((CrossValidationExperiment)this.m_Owner).getFolds());
            this.m_CrossValidation.setGenerator((CrossValidationFoldGenerator)ObjectCopyHelper.copyObject((Object)((CrossValidationExperiment)this.m_Owner).getGenerator()));
            this.m_CrossValidation.setSeed(this.m_Run);
            this.m_CrossValidation.setDiscardPredictions(false);
            this.m_CrossValidation.setNumThreads(1);
            if (simple && ((CrossValidationExperiment)this.m_Owner).getJobRunner() instanceof ThreadLimiter) {
                this.m_CrossValidation.setNumThreads(((ThreadLimiter)((CrossValidationExperiment)this.m_Owner).getJobRunner()).getNumThreads());
            }
            this.m_CrossValidation.setSeparateFolds(true);
            this.m_CrossValidation.setStatusMessageHandler(((CrossValidationExperiment)this.m_Owner).getStatusMessageHandler());
            this.m_CrossValidation.setWaitForJobs(false);
            String result = this.m_CrossValidation.execute();
            if (result == null) {
                DefaultSpreadSheet results = new DefaultSpreadSheet();
                for (int fold = 0; fold < ((CrossValidationExperiment)this.m_Owner).getFolds(); ++fold) {
                    this.addMetrics((SpreadSheet)results, this.m_Run, this.m_Classifier, this.m_Data, this.m_CrossValidation.getEvaluations()[fold]);
                    this.addMetric((SpreadSheet)results, "Key_Fold", fold);
                }
                ((CrossValidationExperiment)this.m_Owner).appendResults((SpreadSheet)results);
            }
            ((CrossValidationExperiment)this.m_Owner).log("Run " + this.m_Run + " [end]: " + this.m_Data.relationName() + " on " + AbstractExperiment.shortenCommandLine(this.m_Classifier));
        }

        public void stopExecution() {
            super.stopExecution();
            if (this.m_CrossValidation != null) {
                this.m_CrossValidation.stopExecution();
            }
        }

        public void cleanUp() {
            if (this.m_CrossValidation != null) {
                this.m_CrossValidation.cleanUp();
                this.m_CrossValidation = null;
            }
            super.cleanUp();
        }
    }
}

