/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.experiment;

import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.ArffSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.ArffSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractResultsHandler;
import java.io.File;

public class FileResultsHandler
extends AbstractResultsHandler
implements FileWriter {
    private static final long serialVersionUID = 2071016272406676626L;
    protected PlaceholderFile m_OutputFile;
    protected SpreadSheetReader m_Reader;
    protected SpreadSheetWriter m_Writer;

    public String globalInfo() {
        return "Uses the specified file to store the results in and loads them as well if present.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-file", "outputFile", (Object)new PlaceholderFile());
        this.m_OptionManager.add("reader", "reader", (Object)new ArffSpreadSheetReader());
        this.m_OptionManager.add("writer", "writer", (Object)new ArffSpreadSheetWriter());
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The file to for the results.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The spreadsheet reader to use.";
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The spreadsheet writer to use.";
    }

    @Override
    public SpreadSheet read() {
        if (!this.m_OutputFile.exists()) {
            return null;
        }
        if (this.m_OutputFile.isDirectory()) {
            return null;
        }
        return this.m_Reader.read((File)this.m_OutputFile);
    }

    @Override
    public String write(SpreadSheet results) {
        if (this.m_OutputFile.isDirectory()) {
            return "Output file is pointing to a directory!";
        }
        if (!this.m_Writer.write(results, (File)this.m_OutputFile)) {
            return "Failed to write results to: " + this.m_OutputFile;
        }
        return null;
    }
}

