/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.experiment;

import adams.core.ObjectCopyHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.gui.tools.wekamultiexperimenter.experiment.AbstractExperiment;
import weka.classifiers.Classifier;
import weka.classifiers.DefaultRandomSplitGenerator;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomSplitGenerator;
import weka.core.Instances;

public class TrainTestSplitExperiment
extends AbstractExperiment {
    private static final long serialVersionUID = -4147644361063132314L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;
    protected RandomSplitGenerator m_Generator;

    public String globalInfo() {
        return "Performs train-test splits for each classifier/dataset combination.\nOrder can be preserved in the datasets.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)66.0, (Number)0.0, (Number)100.0);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
        this.m_OptionManager.add("generator", "generator", (Object)new DefaultRandomSplitGenerator());
    }

    public void setPercentage(double value) {
        this.m_Percentage = value;
        this.reset();
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The split percentage to use.";
    }

    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, no data randomization is occurring before splitting the data into train and test set.";
    }

    public void setGenerator(RandomSplitGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public RandomSplitGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The scheme to use for generating the split; the actor options take precedence over the scheme's ones.";
    }

    protected synchronized TrainTestSplitExperimentJob evaluate(int currentRun, Classifier cls, Instances data) {
        return new TrainTestSplitExperimentJob(this, currentRun, cls, data);
    }

    public static class TrainTestSplitExperimentJob
    extends AbstractExperiment.AbstractExperimentJob<TrainTestSplitExperiment> {
        private static final long serialVersionUID = 4735723305880372881L;

        public TrainTestSplitExperimentJob(TrainTestSplitExperiment owner, int run, Classifier classifier, Instances data) {
            super(owner, run, classifier, data);
        }

        @Override
        protected void evaluate() {
            ((TrainTestSplitExperiment)this.m_Owner).log("Run " + this.m_Run + " [start]: " + this.m_Data.relationName() + " on " + AbstractExperiment.shortenCommandLine(this.m_Classifier));
            RandomSplitGenerator generator = (RandomSplitGenerator)ObjectCopyHelper.copyObject((Object)((TrainTestSplitExperiment)this.m_Owner).getGenerator());
            generator.setData(this.m_Data);
            generator.setSeed(this.m_Run);
            generator.setPercentage(((TrainTestSplitExperiment)this.m_Owner).getPercentage() / 100.0);
            generator.setPreserveOrder(((TrainTestSplitExperiment)this.m_Owner).getPreserveOrder());
            WekaTrainTestSetContainer cont = generator.next();
            Instances train = (Instances)cont.getValue("Train");
            Instances test = (Instances)cont.getValue("Test");
            try {
                Classifier classifier = (Classifier)ObjectCopyHelper.copyObject((Object)this.m_Classifier);
                classifier.buildClassifier(train);
                Evaluation eval = new Evaluation(train);
                eval.evaluateModel(classifier, test, new Object[0]);
                DefaultSpreadSheet results = new DefaultSpreadSheet();
                this.addMetrics((SpreadSheet)results, this.m_Run, this.m_Classifier, this.m_Data, eval);
                ((TrainTestSplitExperiment)this.m_Owner).appendResults((SpreadSheet)results);
            }
            catch (Exception e) {
                LoggingHelper.handleException((LoggingSupporter)this.m_Owner, (String)"Failed to evaluate classifier on train/test split!", (Throwable)e);
            }
            ((TrainTestSplitExperiment)this.m_Owner).log("Run " + this.m_Run + " [end]: " + this.m_Data.relationName() + " on " + AbstractExperiment.shortenCommandLine(this.m_Classifier));
        }
    }
}

