/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.wekamultiexperimenter.runner;

import adams.gui.tools.wekamultiexperimenter.ExperimenterPanel;
import adams.gui.tools.wekamultiexperimenter.runner.AbstractExperimentRunner;
import java.io.File;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.experiment.CSVResultListener;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.InstanceQuery;

public abstract class AbstractWekaExperimentRunner<T extends Experiment>
extends AbstractExperimentRunner<T> {
    private static final long serialVersionUID = -5591889874714150118L;

    public AbstractWekaExperimentRunner(ExperimenterPanel owner) throws Exception {
        super(owner);
    }

    @Override
    protected void doInitialize() throws Exception {
        ((Experiment)this.m_Exp).initialize();
    }

    protected void loadResults() {
        this.logMessage("Attempting to load results...");
        Instances data = null;
        if (((Experiment)this.m_Exp).getResultListener() instanceof CSVResultListener) {
            File resultFile = ((CSVResultListener)((Experiment)this.m_Exp).getResultListener()).getOutputFile();
            if (resultFile == null) {
                this.logMessage("No result file");
            } else {
                AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)resultFile);
                if (loader == null) {
                    this.logMessage("Failed to determine loader for results file: " + resultFile);
                } else {
                    try {
                        loader.setFile(resultFile);
                        data = loader.getDataSet();
                    }
                    catch (Exception e) {
                        this.logError(e, "Problem reading result file");
                    }
                }
            }
        } else if (((Experiment)this.m_Exp).getResultListener() instanceof DatabaseResultListener) {
            DatabaseResultListener dblistener = (DatabaseResultListener)((Experiment)this.m_Exp).getResultListener();
            try {
                InstanceQuery query = new InstanceQuery();
                query.setDatabaseURL(dblistener.getDatabaseURL());
                query.setUsername(dblistener.getUsername());
                query.setPassword(dblistener.getPassword());
                query.connectToDatabase();
                String tableName = query.getResultsTableName(((Experiment)this.m_Exp).getResultProducer());
                query.setQuery("SELECT * FROM " + tableName);
                data = query.retrieveInstances();
            }
            catch (Exception ex) {
                this.logError(ex, "Problem reading database");
            }
        } else {
            this.logMessage("Can't get results from experiment");
        }
        if (data != null) {
            this.m_Owner.getAnalysisPanel().setResults(data);
            this.logMessage("Successfully loaded results!");
        }
    }

    @Override
    protected void postRun(boolean success) {
        if (success) {
            this.loadResults();
        }
    }
}

