/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.Range;
import adams.core.StatusMessageHandler;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.data.instance.Instance;
import adams.data.weka.ArffUtils;
import adams.env.Environment;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.SearchPanel;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.instance.AbstractInstancePaintlet;
import adams.gui.visualization.instance.HistogramFactory;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerList;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import adams.gui.visualization.instance.InstanceReportFactory;
import adams.gui.visualization.instance.LoadDatasetDialog;
import adams.gui.visualization.report.ReportContainerList;
import adams.gui.visualization.report.ReportFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.experiment.InstanceQuery;
import weka.gui.sql.SqlViewerDialog;

public class InstanceExplorer
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler,
ContainerListManager<InstanceContainerManager>,
DataChangeListener,
CleanUpHandler,
SendToActionSupporter {
    private static final long serialVersionUID = 4478483903068117980L;
    public static final String FILENAME = "InstanceExplorer.props";
    public static final String SESSION_FILE = "InstanceExplorerSession.props";
    protected static Properties m_Properties;
    protected InstancePanel m_PanelInstance;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemLoadRecent;
    protected JMenu m_MenuView;
    protected JMenuItem m_MenuItemViewZoomOverview;
    protected JMenuItem m_MenuItemViewAntiAliasing;
    protected JMenuItem m_MenuItemViewColorProvider;
    protected JMenuItem m_MenuItemViewPaintlet;
    protected JMenuItem m_MenuItemClearData;
    protected BaseTabbedPane m_TabbedPane;
    protected ReportFactory.Panel m_Reports;
    protected SearchPanel m_SearchPanel;
    protected LoadDatasetDialog m_LoadFromDiskDialog;
    protected SqlViewerDialog m_LoadFromDatabaseDialog;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected HistogramFactory.SetupDialog m_HistogramSetup;
    protected GenericObjectEditorDialog m_DialogColorProvider;
    protected GenericObjectEditorDialog m_DialogPaintlet;

    protected void initialize() {
        super.initialize();
        this.m_LoadFromDiskDialog = null;
        this.m_LoadFromDatabaseDialog = null;
        this.m_RecentFilesHandler = null;
        this.m_HistogramSetup = null;
        this.m_DialogColorProvider = null;
        this.m_DialogPaintlet = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        JPanel panelData = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Data", (Component)panelData);
        this.m_TabbedPane.addChangeListener(e -> {
            ContainerTable dtable = this.getInstanceContainerList().getTable();
            if (this.m_TabbedPane.getSelectedIndex() == 0) {
                ContainerTable rtable = this.m_Reports.getReportContainerList().getTable();
                if (rtable == null || rtable.getSelectedRowCount() != 1) {
                    return;
                }
                int row = rtable.getSelectedRow();
                dtable.getSelectionModel().clearSelection();
                dtable.getSelectionModel().setSelectionInterval(row, row);
            } else if (this.m_TabbedPane.getSelectedIndex() == 1) {
                if (dtable.getSelectedRowCount() != 1) {
                    return;
                }
                this.m_Reports.setCurrentTable(dtable.getSelectedRow());
            }
        });
        this.m_PanelInstance = new InstancePanel();
        ((InstanceContainerManager)this.m_PanelInstance.getContainerManager()).addDataChangeListener(this);
        this.m_PanelInstance.setStatusMessageHandler(this);
        panelData.add((Component)((Object)this.m_PanelInstance), "Center");
        JPanel panelReports = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Information", (Component)panelReports);
        this.m_Reports = this.newReportPanel();
        this.m_Reports.setDataContainerPanel((DataContainerPanel)this.m_PanelInstance);
        panelReports.add((Component)this.m_Reports, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_SearchPanel.addSearchListener(e -> {
            this.m_Reports.search(this.m_SearchPanel.getSearchText(), this.m_SearchPanel.isRegularExpression());
            this.m_SearchPanel.grabFocus();
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_SearchPanel, "West");
        panelReports.add((Component)panel, "South");
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    public InstancePanel getInstancePanel() {
        return this.m_PanelInstance;
    }

    public InstanceContainerList getInstanceContainerList() {
        return (InstanceContainerList)this.m_PanelInstance.getContainerList();
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    protected InstanceReportFactory.Panel newReportPanel() {
        return new InstanceReportFactory.Panel();
    }

    public void dataChanged(DataChangeEvent e) {
        this.updateMenu();
    }

    public InstanceContainerManager getContainerManager() {
        return (InstanceContainerManager)this.m_PanelInstance.getContainerManager();
    }

    public void setContainerManager(InstanceContainerManager value) {
        this.m_PanelInstance.setContainerManager(value);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.getContainerManager().count() > 0;
        this.m_MenuItemClearData.setEnabled(dataLoaded);
        this.m_MenuItemLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemViewAntiAliasing.setEnabled(this.getInstancePanel().getDataPaintlet() instanceof AntiAliasingSupporter);
        this.m_MenuItemViewAntiAliasing.setSelected(this.getInstancePanel().isAntiAliasingEnabled());
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("Clear");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.setIcon(ImageManager.getIcon((String)"new.gif"));
            menuitem.addActionListener(e -> this.clearData());
            this.m_MenuItemClearData = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Database...");
            menu.add(menuitem);
            menuitem.setMnemonic('D');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed D"));
            menuitem.setIcon(ImageManager.getIcon((String)"database.gif"));
            menuitem.addActionListener(e -> this.loadDataFromDatabase());
            menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(ImageManager.getIcon((String)"open.gif"));
            menuitem.addActionListener(e -> this.loadDataFromDisk());
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, InstanceExplorer.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    InstanceExplorer.this.loadDataFromDisk((File)e.getItem());
                }
            });
            this.m_MenuItemLoadRecent = submenu;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(ImageManager.getIcon((String)"exit.png"));
            menuitem.addActionListener(e -> this.close());
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(e -> this.updateMenu());
            this.m_MenuView = menu;
            menuitem = new JCheckBoxMenuItem("Display zoom overview");
            menu.add(menuitem);
            menuitem.setMnemonic('Z');
            menuitem.setSelected(this.isZoomOverviewPanelVisible());
            menuitem.addActionListener(e -> this.setZoomOverviewPanelVisible(this.m_MenuItemViewZoomOverview.isSelected()));
            this.m_MenuItemViewZoomOverview = menuitem;
            menuitem = new JCheckBoxMenuItem("Anti-aliasing");
            menu.add(menuitem);
            menuitem.setMnemonic('A');
            menuitem.setSelected(this.getInstancePanel().isAntiAliasingEnabled());
            menuitem.addActionListener(e -> this.getInstancePanel().setAntiAliasingEnabled(this.m_MenuItemViewAntiAliasing.isSelected()));
            this.m_MenuItemViewAntiAliasing = menuitem;
            menuitem = new JMenuItem("Color provider...");
            menu.add(menuitem);
            menuitem.setMnemonic('d');
            menuitem.addActionListener(e -> this.selectColorProvider());
            this.m_MenuItemViewColorProvider = menuitem;
            menuitem = new JMenuItem("Paintlet...");
            menu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(e -> this.selectPaintlet());
            this.m_MenuItemViewPaintlet = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void clearData() {
        this.getContainerManager().clear();
    }

    public void loadDataFromDatabase() {
        if (this.m_LoadFromDatabaseDialog == null) {
            this.m_LoadFromDatabaseDialog = this.getParentFrame() != null && this.getParentFrame() instanceof JFrame ? new SqlViewerDialog((JFrame)this.getParentFrame()) : new SqlViewerDialog(null);
        }
        this.m_LoadFromDatabaseDialog.setVisible(true);
        if (this.m_LoadFromDatabaseDialog.getReturnValue() != 0) {
            return;
        }
        try {
            this.showStatus("Executing query: " + this.m_LoadFromDatabaseDialog.getQuery());
            InstanceQuery query = new InstanceQuery();
            query.setDatabaseURL(this.m_LoadFromDatabaseDialog.getURL());
            query.setUsername(this.m_LoadFromDatabaseDialog.getUser());
            query.setPassword(this.m_LoadFromDatabaseDialog.getPassword());
            query.setQuery(this.m_LoadFromDatabaseDialog.getQuery());
            query.setSparseData(this.m_LoadFromDatabaseDialog.getGenerateSparseData());
            if (query.isConnected()) {
                query.disconnectFromDatabase();
            }
            query.connectToDatabase();
            this.showStatus("Loading data...");
            ArrayList<InstanceContainer> data = new ArrayList<InstanceContainer>();
            Instances dataset = query.retrieveInstances();
            for (int i = 0; i < dataset.numInstances(); ++i) {
                Instance inst = new Instance();
                inst.set(dataset.instance(i));
                inst.setID(dataset.relationName() + "." + i);
                data.add(this.getContainerManager().newContainer((Comparable)((Object)inst)));
                this.showStatus("Loading data " + (i + 1) + "/" + dataset.numInstances());
            }
            this.loadData(dataset, data);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to load data from database:\n" + LoggingHelper.throwableToString((Throwable)e)), (String)"Database error");
        }
        this.showStatus("");
    }

    public void loadDataFromDisk() {
        this.loadDataFromDisk(null);
    }

    public void loadDataFromDisk(File file) {
        if (this.m_LoadFromDiskDialog == null) {
            this.m_LoadFromDiskDialog = this.getParentDialog() != null ? new LoadDatasetDialog(this.getParentDialog()) : new LoadDatasetDialog(this.getParentFrame());
            this.m_LoadFromDiskDialog.setCurrent(new File(InstanceExplorer.getProperties().getPath("InitialDir", "%h")));
            this.m_LoadFromDiskDialog.setDefaultAttributeRange(InstanceExplorer.getProperties().getPath("AttributeRange", "first-last"));
            this.m_LoadFromDiskDialog.setDefaultClassIndex(InstanceExplorer.getProperties().getPath("ClassIndex", ""));
            this.m_LoadFromDiskDialog.setDefaultSortIndex(InstanceExplorer.getProperties().getPath("SortIndex", ""));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(0, InstanceExplorer.getProperties().getBoolean("IncludeNumericAttributes", Boolean.valueOf(true)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(3, InstanceExplorer.getProperties().getBoolean("IncludeDateAttributes", Boolean.valueOf(false)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(1, InstanceExplorer.getProperties().getBoolean("IncludeNominalAttributes", Boolean.valueOf(false)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(2, InstanceExplorer.getProperties().getBoolean("IncludeStringAttributes", Boolean.valueOf(false)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(4, InstanceExplorer.getProperties().getBoolean("IncludeRelationalAttributes", Boolean.valueOf(false)));
            this.m_LoadFromDiskDialog.setAcceptListener(e -> {
                int[] indices = this.m_LoadFromDiskDialog.getIndices();
                if (indices == null) {
                    return;
                }
                if (this.m_RecentFilesHandler != null) {
                    this.m_RecentFilesHandler.addRecentItem((Object)this.m_LoadFromDiskDialog.getCurrent());
                }
                HashSet<Integer> attTypes = new HashSet<Integer>();
                if (this.m_LoadFromDiskDialog.getIncludeAttributes(0)) {
                    attTypes.add(0);
                }
                if (this.m_LoadFromDiskDialog.getIncludeAttributes(3)) {
                    attTypes.add(3);
                }
                if (this.m_LoadFromDiskDialog.getIncludeAttributes(1)) {
                    attTypes.add(1);
                }
                if (this.m_LoadFromDiskDialog.getIncludeAttributes(2)) {
                    attTypes.add(2);
                }
                if (this.m_LoadFromDiskDialog.getIncludeAttributes(4)) {
                    attTypes.add(4);
                }
                this.showStatus("Loading data...");
                ArrayList<InstanceContainer> data = new ArrayList<InstanceContainer>();
                Instances dataset = this.m_LoadFromDiskDialog.getDataset();
                int[] additional = this.m_LoadFromDiskDialog.getAdditionalAttributes();
                Range range = this.m_LoadFromDiskDialog.getCurrentAttributeRange();
                int id = this.m_LoadFromDiskDialog.getCurrentIDIndex();
                for (int i = 0; i < indices.length; ++i) {
                    weka.core.Instance winst = dataset.instance(indices[i]);
                    Instance inst = new Instance();
                    inst.set(winst, i, additional, range, attTypes);
                    if (id == -1) {
                        inst.setID(indices[i] + 1 + "." + dataset.relationName());
                    } else if (winst.attribute(id).isNumeric()) {
                        inst.setID("" + winst.value(id));
                    } else {
                        inst.setID(winst.stringValue(id));
                    }
                    data.add(this.getContainerManager().newContainer((Comparable)((Object)inst)));
                    this.showStatus("Loading data " + (i + 1) + "/" + dataset.numInstances());
                }
                this.loadData(dataset, data);
                this.showStatus("");
            });
        }
        if (file != null) {
            this.m_LoadFromDiskDialog.setCurrent(file);
        }
        this.m_LoadFromDiskDialog.setVisible(true);
    }

    protected void loadData(Instances dataset, List<InstanceContainer> data) {
        if (this.getContainerManager().count() + data.size() > InstanceExplorer.getProperties().getInteger("MaxNumContainersWithAntiAliasing", Integer.valueOf(50)) && this.getInstancePanel().isAntiAliasingEnabled()) {
            this.getInstancePanel().setAntiAliasingEnabled(false);
        }
        InstanceContainerList listInst = (InstanceContainerList)this.m_PanelInstance.getContainerList();
        ReportContainerList listReport = this.m_Reports.getReportContainerList();
        boolean hasDBID = dataset.attribute(ArffUtils.getDBIDName()) != null;
        listInst.setDisplayDatabaseID(hasDBID);
        listReport.setDisplayDatabaseID(hasDBID);
        this.getContainerManager().addAll(data);
    }

    public void close() {
        this.cleanUp();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    public void setSidePanelVisible(boolean visible) {
        this.m_PanelInstance.setSidePanelVisible(visible);
    }

    public boolean isSidePanelVisible() {
        return this.m_PanelInstance.isSidePanelVisible();
    }

    public JPanel getSidePanel() {
        return this.m_PanelInstance.getSidePanel();
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelInstance.setZoomOverviewPanelVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelInstance.isZoomOverviewPanelVisible();
    }

    protected void selectColorProvider() {
        if (this.m_DialogColorProvider == null) {
            this.m_DialogColorProvider = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_DialogColorProvider.setTitle("Select color provider");
            this.m_DialogColorProvider.setUISettingsPrefix(ColorProvider.class);
            this.m_DialogColorProvider.getGOEEditor().setClassType(ColorProvider.class);
            this.m_DialogColorProvider.getGOEEditor().setCanChangeClassInDialog(true);
        }
        this.m_DialogColorProvider.setCurrent(this.getContainerManager().getColorProvider().shallowCopy());
        this.m_DialogColorProvider.setLocationRelativeTo((Component)this.m_DialogColorProvider.getParent());
        this.m_DialogColorProvider.setVisible(true);
        if (this.m_DialogColorProvider.getResult() != 0) {
            return;
        }
        this.getContainerManager().setColorProvider((ColorProvider)((ColorProvider)this.m_DialogColorProvider.getCurrent()).shallowCopy());
    }

    protected void selectPaintlet() {
        if (this.m_DialogPaintlet == null) {
            this.m_DialogPaintlet = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_DialogPaintlet.setTitle("Select paintlet");
            this.m_DialogPaintlet.setUISettingsPrefix(AbstractInstancePaintlet.class);
            this.m_DialogPaintlet.getGOEEditor().setClassType(AbstractInstancePaintlet.class);
            this.m_DialogPaintlet.getGOEEditor().setCanChangeClassInDialog(true);
        }
        this.m_DialogPaintlet.setCurrent((Object)this.getInstancePanel().getDataPaintlet().shallowCopy());
        this.m_DialogPaintlet.setLocationRelativeTo((Component)this.m_DialogPaintlet.getParent());
        this.m_DialogPaintlet.setVisible(true);
        if (this.m_DialogPaintlet.getResult() != 0) {
            return;
        }
        Paintlet paintlet = (Paintlet)this.m_DialogPaintlet.getCurrent();
        if (paintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)paintlet).setAntiAliasingEnabled(this.getInstancePanel().isAntiAliasingEnabled());
        }
        this.getInstancePanel().setDataPaintlet(paintlet);
        boolean zoomVisible = this.getInstancePanel().isZoomOverviewPanelVisible();
        this.getInstancePanel().getZoomOverviewPanel().setDataContainerPanel((DataContainerPanel)this.getInstancePanel());
        this.getInstancePanel().setZoomOverviewPanelVisible(zoomVisible);
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return this.getContainerManager().countVisible() > 0;
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            if (this.getContainerManager().countVisible() > 0) {
                result = SendToActionUtils.nextTmpFile((String)"instanceexplorer", (String)"arff");
                Instances inst = this.m_PanelInstance.getInstances();
                try {
                    ConverterUtils.DataSink.write((String)result.getAbsolutePath(), (Instances)inst);
                }
                catch (Exception e) {
                    GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write instances to '" + result + "'!"));
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls) && this.getContainerManager().countVisible() > 0) {
            result = this;
        }
        return result;
    }

    public void cleanUp() {
        this.m_PanelInstance.cleanUp();
        if (this.m_DialogColorProvider != null) {
            this.m_DialogColorProvider.dispose();
            this.m_DialogColorProvider = null;
        }
        if (this.m_DialogPaintlet != null) {
            this.m_DialogPaintlet.dispose();
            this.m_DialogPaintlet = null;
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("instance explorer");
        }
        return m_Properties;
    }
}

