/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances;

import adams.core.SerializationHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.core.ConsolePanel;
import adams.gui.core.UndoHandlerWithQuickAccess;
import adams.ml.data.InstancesView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;

public class InstancesTableModel
extends DefaultTableModel
implements Undoable,
SpreadSheetSupporter {
    private static final long serialVersionUID = 3411795562305994946L;
    protected HashSet<TableModelListener> m_Listeners = new HashSet();
    protected Instances m_Data = null;
    protected boolean m_NotificationEnabled = true;
    protected UndoHandlerWithQuickAccess m_UndoHandler = null;
    protected boolean m_UndoEnabled = true;
    protected boolean m_IgnoreChanges = false;
    protected List<File> m_UndoList = new ArrayList<File>();
    protected boolean m_ReadOnly = false;
    protected boolean m_ShowAttributeIndex = false;
    protected boolean m_ShowWeightsColumn = false;
    protected boolean m_ShowAttributeWeights = false;

    public InstancesTableModel() {
    }

    public InstancesTableModel(Instances data) {
        this();
        this.setInstances(data);
    }

    public boolean isNotificationEnabled() {
        return this.m_NotificationEnabled;
    }

    public void setNotificationEnabled(boolean enabled) {
        this.m_NotificationEnabled = enabled;
    }

    public void setUndoHandler(UndoHandlerWithQuickAccess value) {
        this.m_UndoHandler = value;
    }

    public UndoHandlerWithQuickAccess getUndoHandler() {
        return this.m_UndoHandler;
    }

    protected boolean useUndoHandler() {
        return this.m_UndoHandler != null && this.m_UndoHandler.isUndoSupported() && this.m_UndoHandler.getUndo().isEnabled();
    }

    public boolean isUndoEnabled() {
        if (this.m_UndoHandler != null) {
            return this.m_UndoHandler.isUndoSupported() && this.m_UndoHandler.getUndo().isEnabled();
        }
        return this.m_UndoEnabled;
    }

    public void setUndoEnabled(boolean enabled) {
        if (this.m_UndoHandler != null && this.m_UndoHandler.isUndoSupported()) {
            this.m_UndoHandler.getUndo().setEnabled(enabled);
        }
        this.m_UndoEnabled = enabled;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    public void setReadOnly(boolean value) {
        this.m_ReadOnly = value;
    }

    public void setInstances(Instances data) {
        this.m_Data = data;
        this.fireTableDataChanged();
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public Attribute getAttributeAt(int columnIndex) {
        if (columnIndex > 0 && columnIndex < this.getColumnCount()) {
            return this.m_Data.attribute(columnIndex - 1);
        }
        return null;
    }

    public int getType(int columnIndex) {
        return this.getType(-1, columnIndex);
    }

    public int getType(int rowIndex, int columnIndex) {
        int result = 2;
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (rowIndex < 0 && columnIndex >= offset && columnIndex < this.getColumnCount()) {
            result = this.m_Data.attribute(columnIndex - offset).type();
        } else if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= offset && columnIndex < this.getColumnCount()) {
            result = this.m_Data.instance(rowIndex).attribute(columnIndex - offset).type();
        }
        return result;
    }

    public void deleteAttributeAt(int columnIndex) {
        this.deleteAttributeAt(columnIndex, true);
    }

    public void deleteAttributeAt(int columnIndex, boolean notify) {
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (columnIndex >= offset && columnIndex < this.getColumnCount()) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.deleteAttributeAt(columnIndex - offset);
            if (notify) {
                this.notifyListener(new TableModelEvent(this, -1));
            }
        }
    }

    public void deleteAttributes(int[] columnIndices) {
        Arrays.sort(columnIndices);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = columnIndices.length - 1; i >= 0; --i) {
            this.deleteAttributeAt(columnIndices[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, -1));
    }

    public void renameAttributeAt(int columnIndex, String newName) {
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (columnIndex >= offset && columnIndex < this.getColumnCount()) {
            this.addUndoPoint();
            this.m_Data.renameAttribute(columnIndex - offset, newName);
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void attributeAsClassAt(int columnIndex) {
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (columnIndex >= offset && columnIndex < this.getColumnCount()) {
            this.addUndoPoint();
            try {
                StringBuilder order = new StringBuilder();
                for (int i = 1; i < this.m_Data.numAttributes() + 1; ++i) {
                    if (i + offset - 1 == columnIndex) continue;
                    if (order.length() != 0) {
                        order.append(",");
                    }
                    order.append(Integer.toString(i));
                }
                if (order.length() != 0) {
                    order.append(",");
                }
                order.append(Integer.toString(columnIndex - offset + 1));
                Reorder reorder = new Reorder();
                reorder.setAttributeIndices(order.toString());
                reorder.setInputFormat(this.m_Data);
                this.m_Data = Filter.useFilter((Instances)this.m_Data, (Filter)reorder);
                this.m_Data.setClassIndex(this.m_Data.numAttributes() - 1);
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to apply reorder filter!", (Throwable)e);
                this.undo();
            }
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void deleteInstanceAt(int rowIndex) {
        this.deleteInstanceAt(rowIndex, true);
    }

    public void deleteInstanceAt(int rowIndex, boolean notify) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            if (!this.m_IgnoreChanges) {
                this.addUndoPoint();
            }
            this.m_Data.delete(rowIndex);
            if (notify) {
                this.notifyListener(new TableModelEvent(this, rowIndex, rowIndex, -1, -1));
            }
        }
    }

    public void insertInstance(int index) {
        this.insertInstance(index, true);
    }

    public void insertInstance(int index, boolean notify) {
        if (!this.m_IgnoreChanges) {
            this.addUndoPoint();
        }
        double[] vals = new double[this.m_Data.numAttributes()];
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            if (!this.m_Data.attribute(i).isString() && !this.m_Data.attribute(i).isRelationValued()) continue;
            vals[i] = Utils.missingValue();
        }
        DenseInstance toAdd = new DenseInstance(1.0, vals);
        if (index < 0) {
            this.m_Data.add((Instance)toAdd);
        } else {
            this.m_Data.add(index, (Instance)toAdd);
        }
        if (notify) {
            this.notifyListener(new TableModelEvent(this, this.m_Data.numInstances() - 1, this.m_Data.numInstances() - 1, -1, 1));
        }
    }

    public void deleteInstances(int[] rowIndices) {
        Arrays.sort(rowIndices);
        this.addUndoPoint();
        this.m_IgnoreChanges = true;
        for (int i = rowIndices.length - 1; i >= 0; --i) {
            this.deleteInstanceAt(rowIndices[i], false);
        }
        this.m_IgnoreChanges = false;
        this.notifyListener(new TableModelEvent(this, rowIndices[0], rowIndices[rowIndices.length - 1], -1, -1));
    }

    public void sortInstances(int columnIndex) {
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (columnIndex >= offset && columnIndex < this.getColumnCount()) {
            this.addUndoPoint();
            this.m_Data.stableSort(columnIndex - offset);
            this.notifyListener(new TableModelEvent(this));
        }
    }

    public void sortInstances(int columnIndex, boolean ascending) {
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (columnIndex >= offset && columnIndex < this.getColumnCount()) {
            this.addUndoPoint();
            this.m_Data.stableSort(columnIndex - offset);
            if (!ascending) {
                Instances reversedData = new Instances(this.m_Data, this.m_Data.numInstances());
                int i = this.m_Data.numInstances();
                while (i > 0) {
                    --i;
                    int equalCount = 1;
                    while (i > 0 && this.m_Data.instance(i).value(columnIndex - offset) == this.m_Data.instance(i - 1).value(columnIndex - offset)) {
                        ++equalCount;
                        --i;
                    }
                    for (int j = 0; j < equalCount; ++j) {
                        reversedData.add(this.m_Data.instance(i + j));
                    }
                }
                this.m_Data = reversedData;
            }
            this.notifyListener(new TableModelEvent(this));
        }
    }

    public int getAttributeColumn(String name) {
        int result = -1;
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            if (!this.m_Data.attribute(i).name().equals(name)) continue;
            result = i + offset;
            break;
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = columnIndex == 0 ? Integer.class : (this.m_ShowWeightsColumn && columnIndex == 1 ? Double.class : (this.getType(columnIndex) == 0 ? Double.class : String.class));
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 1;
        if (this.m_ShowWeightsColumn) {
            ++result;
        }
        if (this.m_Data != null) {
            result += this.m_Data.numAttributes();
        }
        return result;
    }

    protected boolean isClassIndex(int columnIndex) {
        int index = this.m_Data.classIndex();
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        boolean result = index == columnIndex - offset;
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        Object result = "";
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                result = "<html><center>No.<br><font size=\"-2\">&nbsp;</font>" + (this.m_ShowAttributeWeights ? "<br>&nbsp;" : "") + "</center></html>";
            } else if (columnIndex == 1 && this.m_ShowWeightsColumn) {
                result = "<html><center>Weight<br><font size=\"-2\">&nbsp;</font>" + (this.m_ShowAttributeWeights ? "<br>&nbsp;" : "") + "</center></html>";
            } else if (this.m_Data != null && columnIndex - offset < this.m_Data.numAttributes()) {
                result = "<html><center>";
                if (this.m_ShowAttributeIndex) {
                    result = (String)result + (columnIndex - offset + 1) + ":";
                }
                result = this.isClassIndex(columnIndex) ? (String)result + "<b>" + this.m_Data.attribute(columnIndex - offset).name() + "</b>" : (String)result + this.m_Data.attribute(columnIndex - offset).name();
                switch (this.getType(columnIndex)) {
                    case 3: {
                        result = (String)result + "<br><font size=\"-2\">Date</font>";
                        break;
                    }
                    case 1: {
                        result = (String)result + "<br><font size=\"-2\">Nominal</font>";
                        break;
                    }
                    case 2: {
                        result = (String)result + "<br><font size=\"-2\">String</font>";
                        break;
                    }
                    case 0: {
                        result = (String)result + "<br><font size=\"-2\">Numeric</font>";
                        break;
                    }
                    case 4: {
                        result = (String)result + "<br><font size=\"-2\">Relational</font>";
                        break;
                    }
                    default: {
                        result = (String)result + "<br><font size=\"-2\">???</font>";
                    }
                }
                if (this.m_ShowAttributeWeights) {
                    result = (String)result + "<br><font size=\"-2\">" + Utils.doubleToString((double)this.m_Data.attribute(columnIndex - offset).weight(), (int)3) + "</font>";
                }
                result = (String)result + "</center></html>";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.numInstances();
    }

    public boolean isMissingAt(int rowIndex, int columnIndex) {
        boolean result = false;
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= offset && columnIndex < this.getColumnCount()) {
            result = this.m_Data.instance(rowIndex).isMissing(columnIndex - offset);
        }
        return result;
    }

    public double getInstancesValueAt(int rowIndex, int columnIndex) {
        double result = -1.0;
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= offset && columnIndex < this.getColumnCount()) {
            result = this.m_Data.instance(rowIndex).value(columnIndex - offset);
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            if (columnIndex == 0) {
                result = rowIndex + 1;
            } else if (this.m_ShowWeightsColumn && columnIndex == 1) {
                result = this.m_Data.instance(rowIndex).weight();
            } else if (!this.isMissingAt(rowIndex, columnIndex)) {
                switch (this.getType(columnIndex)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        result = this.m_Data.instance(rowIndex).stringValue(columnIndex - offset);
                        break;
                    }
                    case 0: {
                        result = this.m_Data.instance(rowIndex).value(columnIndex - offset);
                        break;
                    }
                    default: {
                        result = "-can't display-";
                    }
                }
                if (this.getType(columnIndex) != 0 && result != null) {
                    result = result.toString();
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        return columnIndex >= offset && !this.isReadOnly();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, rowIndex, columnIndex, true);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, boolean notify) {
        Object oldValue;
        boolean different;
        int offset = 1;
        if (this.m_ShowWeightsColumn) {
            ++offset;
        }
        boolean bl = different = !("" + (oldValue = this.getValueAt(rowIndex, columnIndex))).equals("" + aValue);
        if (!different) {
            return;
        }
        if (!this.m_IgnoreChanges) {
            this.addUndoPoint();
        }
        int type = this.getType(rowIndex, columnIndex);
        int index = columnIndex - offset;
        Instance inst = this.m_Data.instance(rowIndex);
        Attribute att = inst.attribute(index);
        if (aValue == null) {
            inst.setValue(index, Utils.missingValue());
        } else {
            String tmp = aValue.toString();
            switch (type) {
                case 3: {
                    try {
                        att.parseDate(tmp);
                        inst.setValue(index, att.parseDate(tmp));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    if (att.indexOfValue(tmp) <= -1) break;
                    inst.setValue(index, (double)att.indexOfValue(tmp));
                    break;
                }
                case 2: {
                    inst.setValue(index, tmp);
                    break;
                }
                case 0: {
                    try {
                        inst.setValue(index, Double.parseDouble(tmp));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 4: {
                    try {
                        inst.setValue(index, (double)inst.attribute(index).addRelation((Instances)aValue));
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Attribute type: " + type + "!");
                }
            }
        }
        if (notify) {
            this.notifyListener(new TableModelEvent(this, rowIndex, columnIndex));
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.m_Listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.m_Listeners.remove(l);
    }

    public void notifyListener(TableModelEvent e) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        for (TableModelListener l : this.m_Listeners) {
            l.tableChanged(e);
        }
    }

    public void clearUndo() {
        if (this.m_UndoHandler != null && this.m_UndoHandler.isUndoSupported()) {
            this.m_UndoHandler.getUndo().clear();
        }
        for (File file : this.m_UndoList) {
            file.delete();
        }
        this.m_UndoList.clear();
    }

    public boolean canUndo() {
        if (this.useUndoHandler()) {
            return this.m_UndoHandler.getUndo().canUndo();
        }
        return !this.m_UndoList.isEmpty();
    }

    public void undo() {
        if (this.canUndo()) {
            if (this.useUndoHandler()) {
                this.m_UndoHandler.undo();
            } else {
                File tempFile = this.m_UndoList.get(this.m_UndoList.size() - 1);
                try {
                    Instances inst = (Instances)SerializationHelper.read((String)tempFile.getAbsolutePath());
                    this.setInstances(inst);
                    this.notifyListener(new TableModelEvent(this, -1));
                    this.notifyListener(new TableModelEvent(this));
                }
                catch (Exception e) {
                    ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to perform undo!", (Throwable)e);
                }
                tempFile.delete();
                this.m_UndoList.remove(this.m_UndoList.size() - 1);
            }
        }
    }

    public void addUndoPoint() {
        if (!this.isUndoEnabled()) {
            return;
        }
        if (this.getInstances() != null) {
            if (this.useUndoHandler()) {
                this.m_UndoHandler.addUndoPoint("undo");
            } else {
                try {
                    File tempFile = File.createTempFile("instances", null);
                    tempFile.deleteOnExit();
                    SerializationHelper.write((String)tempFile.getAbsolutePath(), (Object)this.getInstances());
                    this.m_UndoList.add(tempFile);
                }
                catch (Exception e) {
                    ConsolePanel.getSingleton().append((Object)Level.SEVERE, "Failed to serialize undo point!", (Throwable)e);
                }
            }
        }
    }

    public void setShowAttributeIndex(boolean value) {
        this.m_ShowAttributeIndex = value;
        this.fireTableStructureChanged();
    }

    public boolean getShowAttributeIndex() {
        return this.m_ShowAttributeIndex;
    }

    public void setShowWeightsColumn(boolean value) {
        this.m_ShowWeightsColumn = value;
        this.fireTableStructureChanged();
    }

    public boolean getShowWeightsColumn() {
        return this.m_ShowWeightsColumn;
    }

    public void setShowAttributeWeights(boolean value) {
        this.m_ShowAttributeWeights = value;
        this.fireTableStructureChanged();
    }

    public boolean getShowAttributeWeights() {
        return this.m_ShowAttributeWeights;
    }

    public InstancesTableModel copy(Instances data) {
        InstancesTableModel result = new InstancesTableModel(data);
        result.setShowAttributeIndex(this.getShowAttributeIndex());
        result.setShowWeightsColumn(this.getShowWeightsColumn());
        result.setShowAttributeWeights(this.getShowAttributeWeights());
        result.setReadOnly(this.isReadOnly());
        result.setUndoEnabled(this.isUndoEnabled());
        result.setNotificationEnabled(this.isNotificationEnabled());
        return result;
    }

    public SpreadSheet toSpreadSheet() {
        return new InstancesView(this.m_Data);
    }
}

