/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.gui.core.GUIHelper;
import adams.gui.core.TableRowRange;
import adams.gui.dialog.TextDialog;
import adams.gui.visualization.instances.instancestable.AbstractProcessColumn;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import java.awt.Container;
import java.awt.Dialog;
import weka.core.AttributeStats;
import weka.core.Instances;

public class AttributeStatistics
extends AbstractProcessColumn {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Displays statistics for the selected attribute.";
    }

    @Override
    public String getMenuItem() {
        return "Attribute statistics...";
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    @Override
    protected boolean doProcessColumn(InstancesTablePopupMenuItemHelper.TableState state) {
        Instances data = state.table.toInstances(state.range, true);
        AttributeStats stats = data.attributeStats(state.actCol);
        TextDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new TextDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.MODELESS) : new TextDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), false);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Attribute statistics for column #" + (state.actCol + 1) + "/" + data.attribute(state.actCol).name());
        dialog.setUpdateParentTitle(false);
        dialog.setContent(stats.toString());
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return true;
    }
}

