/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instances.instancestable;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;
import adams.data.spreadsheet.rowstatistic.Mean;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.instances.instancestable.AbstractProcessRow;
import adams.gui.visualization.instances.instancestable.InstancesTablePopupMenuItemHelper;
import adams.ml.data.InstancesView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;

public class RowStatistic
extends AbstractProcessRow {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Allows the user to calculate statistics for a row.";
    }

    @Override
    public String getMenuItem() {
        return "Row statistics...";
    }

    @Override
    protected boolean doProcessRow(InstancesTablePopupMenuItemHelper.TableState state) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), true);
        setup.setDefaultCloseOperation(2);
        setup.setUISettingsPrefix(AbstractRowStatistic.class);
        setup.getGOEEditor().setClassType(AbstractRowStatistic.class);
        setup.getGOEEditor().setCanChangeClassInDialog(true);
        AbstractRowStatistic last = (AbstractRowStatistic)state.table.getLastSetup(this.getClass(), true, false);
        if (last == null) {
            last = new Mean();
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)((Object)state.table)));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return false;
        }
        last = (AbstractRowStatistic)setup.getCurrent();
        state.table.addLastSetup(this.getClass(), true, false, last);
        SpreadSheet stats = last.generate((SpreadSheet)new InstancesView(state.table.getInstances()), state.actRow);
        if (stats == null) {
            if (last.hasLastError()) {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)("Failed to calculate statistics for row #" + (state.actRow + 1) + ": " + last.getLastError()));
            } else {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)state.table)), (String)("Failed to calculate statistics for row #" + (state.actRow + 1) + "!"));
            }
        } else {
            SpreadSheetDialog dialog = GUIHelper.getParentDialog((Container)((Object)state.table)) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)((Object)state.table)), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)((Object)state.table)), false);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Statistics for row #" + (state.actRow + 1));
            dialog.setSpreadSheet(stats);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        return stats != null;
    }
}

