/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.core.DateTime;
import adams.core.DateTimeMsec;
import adams.core.Time;
import adams.core.TimeMsec;
import adams.core.Utils;
import adams.core.base.BaseDateTimeMsec;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.ml.data.InstanceView;
import java.util.Date;
import weka.core.Attribute;

public class DataCellView
implements Cell {
    private static final long serialVersionUID = -1124569966977121103L;
    protected InstanceView m_Owner;
    protected int m_ColIndex;

    public DataCellView(InstanceView owner, int colIndex) {
        this.m_Owner = owner;
        this.m_ColIndex = colIndex;
    }

    public void setOwner(Row owner) {
        if (!(owner instanceof InstanceView)) {
            throw new IllegalArgumentException("Owner can only be " + InstanceView.class.getName());
        }
        this.m_Owner = (InstanceView)owner;
    }

    public InstanceView getOwner() {
        return this.m_Owner;
    }

    public SpreadSheet getSpreadSheet() {
        if (this.m_Owner != null) {
            return this.m_Owner.getOwner();
        }
        return null;
    }

    public void assign(Cell cell) {
        switch (this.m_Owner.getData().attribute(this.m_ColIndex).type()) {
            case 0: {
                this.m_Owner.getData().setValue(this.m_ColIndex, cell.toDouble().doubleValue());
                break;
            }
            case 3: {
                this.m_Owner.getData().setValue(this.m_ColIndex, (double)cell.toAnyDateType().getTime());
                break;
            }
            case 1: 
            case 2: {
                this.m_Owner.getData().setValue(this.m_ColIndex, cell.getContent());
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle attribute type: " + Attribute.typeToString((int)this.m_Owner.getData().attribute(this.m_ColIndex).type()));
            }
        }
    }

    public void setMissing() {
        this.m_Owner.getData().setMissing(this.m_ColIndex);
    }

    public Cell setContent(Boolean value) {
        return this;
    }

    public Cell setContent(Byte value) {
        if (value != null) {
            this.m_Owner.getData().setValue(this.m_ColIndex, value.doubleValue());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(Short value) {
        if (value != null) {
            this.m_Owner.getData().setValue(this.m_ColIndex, value.doubleValue());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(Integer value) {
        if (value != null) {
            this.m_Owner.getData().setValue(this.m_ColIndex, value.doubleValue());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(Long value) {
        if (value != null) {
            this.m_Owner.getData().setValue(this.m_ColIndex, value.doubleValue());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(Float value) {
        if (value != null) {
            this.m_Owner.getData().setValue(this.m_ColIndex, value.doubleValue());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(Double value) {
        if (value != null) {
            this.m_Owner.getData().setValue(this.m_ColIndex, value.doubleValue());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(Date value) {
        if (value != null && this.isAnyDateType()) {
            this.m_Owner.getData().setValue(this.m_ColIndex, (double)value.getTime());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(DateTime value) {
        if (value != null && this.isAnyDateType()) {
            this.m_Owner.getData().setValue(this.m_ColIndex, (double)value.getTime());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(DateTimeMsec value) {
        if (value != null && this.isAnyDateType()) {
            this.m_Owner.getData().setValue(this.m_ColIndex, (double)value.getTime());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(Time value) {
        if (value != null && this.isAnyDateType()) {
            this.m_Owner.getData().setValue(this.m_ColIndex, (double)value.getTime());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContent(TimeMsec value) {
        if (value != null && this.isAnyDateType()) {
            this.m_Owner.getData().setValue(this.m_ColIndex, (double)value.getTime());
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell parseContent(String value) {
        if (value == null) {
            this.setMissing();
        } else if (Utils.isDouble((String)value)) {
            this.parseContent(value, Cell.ContentType.DOUBLE);
        } else if (value.contains(":")) {
            this.parseContent(value, Cell.ContentType.DATETIMEMSEC);
        } else {
            this.parseContent(value, Cell.ContentType.STRING);
        }
        return this;
    }

    public Cell setContent(String value) {
        if (value == null || value.equals("?")) {
            this.setMissing();
        } else if (value.length() > 0) {
            this.parseContent(value);
        } else {
            this.setContentAsString(value);
        }
        return this;
    }

    public Object parseContent(String value, Cell.ContentType type) {
        switch (type) {
            case DOUBLE: {
                if (value == null || !Utils.isDouble((String)value)) {
                    return "?";
                }
                return Double.parseDouble(value);
            }
            case STRING: {
                if (value == null) {
                    return "?";
                }
                return value;
            }
            case DATETIMEMSEC: {
                if (value == null || !new BaseDateTimeMsec().isValid(value)) {
                    return "?";
                }
                return new BaseDateTimeMsec(value);
            }
        }
        return "?";
    }

    public Cell setContentAsString(String value) {
        if (value != null) {
            this.m_Owner.getData().setValue(this.m_ColIndex, value);
        } else {
            this.m_Owner.getData().setMissing(this.m_ColIndex);
        }
        return this;
    }

    public Cell setContentAs(String value, Cell.ContentType type) {
        Object obj = this.parseContent(value, type);
        if (obj.equals("?")) {
            this.setMissing();
        } else {
            this.setNative(obj);
        }
        return this;
    }

    public Cell setObject(Object value) {
        return this;
    }

    public Cell setFormula(String value) {
        return this;
    }

    public String getFormula() {
        return null;
    }

    public Object getObject() {
        return null;
    }

    public String getContent() {
        switch (this.m_Owner.getData().attribute(this.m_ColIndex).type()) {
            case 0: {
                return "" + this.m_Owner.getData().value(this.m_ColIndex);
            }
            case 1: 
            case 2: 
            case 3: {
                return this.m_Owner.getData().stringValue(this.m_ColIndex);
            }
        }
        throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((int)this.m_Owner.getData().attribute(this.m_ColIndex).type()));
    }

    public Cell.ContentType getContentType() {
        switch (this.m_Owner.getData().attribute(this.m_ColIndex).type()) {
            case 0: {
                return Cell.ContentType.DOUBLE;
            }
            case 3: {
                return Cell.ContentType.DATETIMEMSEC;
            }
            case 1: 
            case 2: {
                return Cell.ContentType.STRING;
            }
        }
        throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((int)this.m_Owner.getData().attribute(this.m_ColIndex).type()));
    }

    public Cell setNative(Object value) {
        if (value == null) {
            this.setMissing();
        } else if (value instanceof String) {
            this.setContentAsString((String)value);
        } else if (value instanceof Integer) {
            this.setContent((Integer)value);
        } else if (value instanceof Long) {
            this.setContent((Long)value);
        } else if (value instanceof Double) {
            this.setContent((Double)value);
        } else if (value instanceof DateTime) {
            this.setContent((DateTime)value);
        } else if (value instanceof DateTimeMsec) {
            this.setContent((DateTimeMsec)value);
        } else if (value instanceof Time) {
            this.setContent((Time)value);
        } else if (value instanceof TimeMsec) {
            this.setContent((TimeMsec)value);
        } else if (value instanceof Date) {
            this.setContent((Date)value);
        } else if (value instanceof Boolean) {
            this.setContent((Boolean)value);
        } else if (value instanceof Byte) {
            this.setContent((Byte)value);
        } else if (value instanceof Short) {
            this.setContent((Short)value);
        } else if (value instanceof Float) {
            this.setContent((Float)value);
        } else if (value instanceof Number) {
            this.setContent(((Number)value).doubleValue());
        } else {
            this.setObject(value);
        }
        return this;
    }

    public Object getNative() {
        switch (this.getContentType()) {
            case MISSING: {
                return "?";
            }
            case BOOLEAN: {
                return this.toBoolean();
            }
            case TIME: {
                return this.toTime();
            }
            case TIMEMSEC: {
                return this.toTimeMsec();
            }
            case DATE: {
                return this.toDate();
            }
            case DATETIME: {
                return this.toDateTime();
            }
            case DATETIMEMSEC: {
                return this.toDateTimeMsec();
            }
            case LONG: {
                return this.toLong();
            }
            case DOUBLE: {
                return this.toDouble();
            }
            case STRING: {
                return this.toString();
            }
            case OBJECT: {
                return this.getObject();
            }
        }
        throw new IllegalStateException("Unhandled content type: " + this.getContentType());
    }

    public int index() {
        return this.m_ColIndex;
    }

    public boolean isNumeric() {
        return this.m_Owner.getData().attribute(this.m_ColIndex).isNumeric();
    }

    public boolean isMissing() {
        return this.m_Owner.getData().isMissing(this.m_ColIndex);
    }

    public boolean isBoolean() {
        return false;
    }

    public Boolean toBoolean() {
        return null;
    }

    public boolean isAnyDateType() {
        return this.isDateTimeMsec();
    }

    public Date toAnyDateType() {
        return this.toDateTimeMsec();
    }

    public boolean isDate() {
        return false;
    }

    public Date toDate() {
        return null;
    }

    public boolean isDateTime() {
        return false;
    }

    public DateTime toDateTime() {
        return null;
    }

    public boolean isDateTimeMsec() {
        return this.m_Owner.getData().attribute(this.m_ColIndex).isDate();
    }

    public DateTimeMsec toDateTimeMsec() {
        return new DateTimeMsec(new Date((long)this.m_Owner.getData().value(this.m_ColIndex)));
    }

    public boolean isTime() {
        return false;
    }

    public Time toTime() {
        return null;
    }

    public boolean isTimeMsec() {
        return false;
    }

    public TimeMsec toTimeMsec() {
        return null;
    }

    public boolean isDouble() {
        return this.m_Owner.getData().attribute(this.m_ColIndex).type() == 0;
    }

    public Double toDouble() {
        if (this.isDouble()) {
            return this.m_Owner.getData().value(this.m_ColIndex);
        }
        return null;
    }

    public boolean isLong() {
        return false;
    }

    public Long toLong() {
        return null;
    }

    public boolean isFormula() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public void calculate() {
    }
}

