/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Utils;
import adams.core.exception.NotImplementedException;
import adams.core.management.LocaleHelper;
import adams.data.SharedStringsTable;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.spreadsheet.SpreadSheetView;
import adams.ml.data.Dataset;
import adams.ml.data.InstanceView;
import adams.ml.data.InstancesHeaderRow;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class InstancesView
implements Dataset {
    private static final long serialVersionUID = -6570030309091506840L;
    protected Instances m_Data;
    protected InstancesHeaderRow m_Header;
    protected SharedStringsTable m_SharedStringsTable;

    public InstancesView() {
        this(InstancesView.createDummy());
    }

    protected static Instances createDummy() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("dummy"));
        return new Instances("dummy", atts, 0);
    }

    public InstancesView(Instances data) {
        this.m_Data = data;
        this.m_SharedStringsTable = new SharedStringsTable();
        this.m_Header = new InstancesHeaderRow(this);
    }

    public Instances getData() {
        return this.m_Data;
    }

    protected int rowKeyToIndex(String rowKey) {
        if (Utils.isInteger((String)rowKey)) {
            return Integer.parseInt(rowKey);
        }
        return -1;
    }

    protected int cellKeyToIndex(String cellKey) {
        if (Utils.isInteger((String)cellKey)) {
            return Integer.parseInt(cellKey);
        }
        return -1;
    }

    public void addComment(List<String> comment) {
    }

    public List<String> getComments() {
        return new ArrayList<String>();
    }

    public void clear() {
        this.m_Data.clear();
    }

    public HeaderRow getHeaderRow() {
        return this.m_Header;
    }

    public String getColumnName(int colIndex) {
        return this.m_Data.attribute(colIndex).name();
    }

    public List<String> getColumnNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            result.add(this.m_Data.attribute(i).name());
        }
        return result;
    }

    public boolean hasRow(int rowIndex) {
        return rowIndex < this.m_Data.numInstances();
    }

    public boolean hasRow(String rowKey) {
        int row = this.rowKeyToIndex(rowKey);
        return row >= 0 || row < this.m_Data.numInstances();
    }

    public Cell newCell() {
        return null;
    }

    public DataRow addRow() {
        DenseInstance inst = new DenseInstance(this.getColumnCount());
        inst.setDataset(this.m_Data);
        this.m_Data.add((Instance)inst);
        return new InstanceView(this, (Instance)inst);
    }

    public DataRow addRow(String rowKey) {
        throw new NotImplementedException();
    }

    public DataRow insertRow(int index) {
        DenseInstance inst = new DenseInstance(this.getColumnCount());
        inst.setDataset(this.m_Data);
        this.m_Data.add(index, (Instance)inst);
        return new InstanceView(this, (Instance)inst);
    }

    public Row removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return new InstanceView(this, this.m_Data.remove(rowIndex));
        }
        return null;
    }

    public Row removeRow(String rowKey) {
        return this.removeRow(this.rowKeyToIndex(rowKey));
    }

    public void insertColumn(int columnIndex, String header) {
        throw new NotImplementedException();
    }

    public void insertColumn(int columnIndex, String header, String initial) {
        throw new NotImplementedException();
    }

    public void insertColumn(int columnIndex, String header, String initial, boolean forceString) {
        throw new NotImplementedException();
    }

    public boolean removeColumn(int columnIndex) {
        throw new NotImplementedException();
    }

    public boolean removeColumn(String columnKey) {
        throw new NotImplementedException();
    }

    public DataRow getRow(String rowKey) {
        return this.getRow(this.rowKeyToIndex(rowKey));
    }

    public DataRow getRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return new InstanceView(this, this.m_Data.instance(rowIndex));
        }
        return null;
    }

    public String getRowKey(int rowIndex) {
        return "" + rowIndex;
    }

    public int getRowIndex(String rowKey) {
        return this.rowKeyToIndex(rowKey);
    }

    public int getCellIndex(String cellKey) {
        return this.cellKeyToIndex(cellKey);
    }

    public boolean hasCell(int rowIndex, int columnIndex) {
        return rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex < this.getColumnCount();
    }

    public Cell getCell(int rowIndex, int columnIndex) {
        DataRow row = this.getRow(rowIndex);
        if (row != null) {
            return row.getCell(columnIndex);
        }
        return null;
    }

    public String getCellPosition(String rowKey, String cellKey) {
        return SpreadSheetUtils.getCellPosition((int)this.rowKeyToIndex(rowKey), (int)this.cellKeyToIndex(cellKey));
    }

    public Collection<String> rowKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            result.add("" + i);
        }
        return result;
    }

    public Collection<DataRow> rows() {
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            result.add(this.getRow(i));
        }
        return result;
    }

    public void sortRowKeys() {
    }

    public void sortRowKeys(Comparator<String> comp) {
    }

    public void sort(int index, boolean asc) {
        this.m_Data.sort(index);
        if (!asc) {
            Collections.reverse(this.m_Data);
        }
    }

    public void sort(RowComparator comp) {
    }

    public void sort(RowComparator comp, boolean unique) {
    }

    public int getColumnCount() {
        return this.m_Data.numAttributes();
    }

    public int getRowCount() {
        return this.m_Data.numInstances();
    }

    public boolean isNumeric(int columnIndex) {
        return this.isNumeric(columnIndex, false);
    }

    public boolean isNumeric(int columnIndex, boolean allowMissing) {
        boolean result;
        boolean bl = result = this.m_Data.attribute(columnIndex).type() == 0;
        if (result && !allowMissing) {
            for (int i = 0; i < this.m_Data.numInstances(); ++i) {
                if (!this.m_Data.instance(i).isMissing(columnIndex)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isContentType(int columnIndex, Cell.ContentType type) {
        Attribute att = this.m_Data.attribute(columnIndex);
        if (type == Cell.ContentType.DOUBLE && att.type() == 0) {
            return true;
        }
        if (type == Cell.ContentType.DATETIMEMSEC && att.type() == 3) {
            return true;
        }
        if (type == Cell.ContentType.STRING && att.type() == 1) {
            return true;
        }
        return type == Cell.ContentType.STRING && att.type() == 2;
    }

    public Cell.ContentType getContentType(int columnIndex) {
        Collection<Cell.ContentType> types = this.getContentTypes(columnIndex);
        if (types.size() == 1) {
            return types.iterator().next();
        }
        return null;
    }

    public Collection<Cell.ContentType> getContentTypes(int columnIndex) {
        ArrayList<Cell.ContentType> result = new ArrayList<Cell.ContentType>();
        Attribute att = this.m_Data.attribute(columnIndex);
        if (att.type() == 0) {
            result.add(Cell.ContentType.DOUBLE);
        } else if (att.type() == 3) {
            result.add(Cell.ContentType.DATETIMEMSEC);
        } else if (att.type() == 1) {
            result.add(Cell.ContentType.STRING);
        } else if (att.type() == 2) {
            result.add(Cell.ContentType.STRING);
        }
        for (int i = 0; i < this.m_Data.numInstances(); ++i) {
            if (!this.m_Data.instance(i).isMissing(columnIndex)) continue;
            result.add(Cell.ContentType.MISSING);
            break;
        }
        return result;
    }

    public List<String> getCellValues(String colKey) {
        return this.getCellValues(this.cellKeyToIndex(colKey));
    }

    public List<String> getCellValues(int colIndex) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Cell cell = this.getCell(i, colIndex);
            if (cell == null || cell.isMissing()) continue;
            values.add(cell.getContent());
        }
        result.addAll(values);
        Collections.sort(result);
        return result;
    }

    public String equalsHeader(SpreadSheet other) {
        if (other instanceof InstancesView) {
            return this.m_Data.equalHeadersMsg(((InstancesView)other).getData());
        }
        throw new IllegalArgumentException("Can only compare with other " + InstancesView.class.getName() + " objects!");
    }

    public Object[][] toMatrix() {
        int c;
        Object[][] result = new Object[this.getRowCount() + 1][this.getColumnCount()];
        for (c = 0; c < this.getColumnCount(); ++c) {
            result[0][c] = this.m_Data.attribute(c).name();
        }
        for (int r = 0; r < this.getRowCount(); ++r) {
            DataRow row = this.getRow(r);
            for (c = 0; c < this.getColumnCount(); ++c) {
                Cell cell = row.getCell(c);
                result[r + 1][c] = cell == null || cell.isMissing() ? null : cell.getNative();
            }
        }
        return result;
    }

    public boolean removeMissing() {
        return false;
    }

    public SharedStringsTable getSharedStringsTable() {
        return this.m_SharedStringsTable;
    }

    public void setDateLenient(boolean value) {
    }

    public boolean isDateLenient() {
        return false;
    }

    public void setDateTimeLenient(boolean value) {
    }

    public boolean isDateTimeLenient() {
        return false;
    }

    public void setDateTimeMsecLenient(boolean value) {
    }

    public boolean isDateTimeMsecLenient() {
        return false;
    }

    public void setTimeLenient(boolean value) {
    }

    public boolean isTimeLenient() {
        return false;
    }

    public void setTimeMsecLenient(boolean value) {
    }

    public boolean isTimeMsecLenient() {
        return false;
    }

    public void setTimeZone(TimeZone value) {
    }

    public TimeZone getTimeZone() {
        return null;
    }

    public void setLocale(Locale value) {
    }

    public Locale getLocale() {
        return null;
    }

    public void calculate() {
    }

    public void mergeWith(SpreadSheet other) {
        throw new NotImplementedException();
    }

    public void assign(SpreadSheet sheet) {
        if (!(sheet instanceof InstancesView)) {
            throw new IllegalArgumentException("Other spreadsheet can only be " + InstancesView.class.getName());
        }
        this.m_Data = ((InstancesView)sheet).getData();
        this.m_Header = new InstancesHeaderRow(this);
    }

    public void setDataRowClass(Class cls) {
    }

    public Class getDataRowClass() {
        return InstanceView.class;
    }

    public SpreadSheet newInstance() {
        return null;
    }

    public Dataset getClone() {
        return new InstancesView(this.m_Data);
    }

    public Dataset getHeader() {
        Instances data = new Instances(this.m_Data);
        return new InstancesView(data);
    }

    public DateFormat getDateFormat() {
        return DateUtils.getDateFormatter();
    }

    public DateFormat getDateTimeFormat() {
        return DateUtils.getTimestampFormatter();
    }

    public DateFormat getDateTimeMsecFormat() {
        return DateUtils.getTimestampFormatterMsecs();
    }

    public DateFormat getTimeFormat() {
        return DateUtils.getTimeFormatter();
    }

    public DateFormat getTimeMsecFormat() {
        return DateUtils.getTimeFormatterMsecs();
    }

    public NumberFormat getNumberFormat() {
        return LocaleHelper.getSingleton().getNumberFormat(LocaleHelper.getSingleton().getDefault());
    }

    public void setName(String value) {
        this.m_Data.setRelationName(value);
    }

    public String getName() {
        return this.m_Data.relationName();
    }

    public boolean hasName() {
        return true;
    }

    public void addComment(String comment) {
    }

    public int indexOfColumn(String name) {
        if (this.m_Data.attribute(name) != null) {
            return this.m_Data.attribute(name).index();
        }
        return -1;
    }

    public void removeClassAttributes() {
        this.m_Data.setClassIndex(-1);
    }

    public boolean isClassAttribute(String colKey) {
        int col = this.cellKeyToIndex(colKey);
        return col > -1 && this.m_Data.classIndex() == col;
    }

    public boolean isClassAttributeByName(String name) {
        Attribute att = this.m_Data.attribute(name);
        return att != null && att.index() == this.m_Data.classIndex();
    }

    public boolean isClassAttribute(int colIndex) {
        return colIndex > -1 && colIndex == this.m_Data.classIndex();
    }

    public boolean setClassAttribute(String colKey, boolean isClass) {
        return this.setClassAttribute(this.cellKeyToIndex(colKey), isClass);
    }

    public boolean setClassAttributeByName(String name, boolean isClass) {
        Attribute att = this.m_Data.attribute(name);
        return att != null && this.setClassAttribute(att.index(), isClass);
    }

    public boolean setClassAttribute(int colIndex, boolean isClass) {
        if (colIndex > -1) {
            if (isClass) {
                this.m_Data.setClassIndex(colIndex);
                return true;
            }
            if (this.m_Data.classIndex() > -1 && this.m_Data.classIndex() == colIndex) {
                this.m_Data.setClassIndex(-1);
                return true;
            }
        }
        return false;
    }

    public String[] getClassAttributeKeys() {
        if (this.m_Data.classIndex() == -1) {
            return new String[0];
        }
        return new String[]{"" + this.m_Data.classIndex()};
    }

    public String[] getClassAttributeNames() {
        if (this.m_Data.classIndex() == -1) {
            return new String[0];
        }
        return new String[]{this.m_Data.classAttribute().name()};
    }

    public int[] getClassAttributeIndices() {
        if (this.m_Data.classIndex() == -1) {
            return new int[0];
        }
        return new int[]{this.m_Data.classIndex()};
    }

    public SpreadSheet getInputs() {
        if (this.m_Data.classIndex() == -1) {
            return this;
        }
        Instances data = new Instances(this.m_Data);
        data.setClassIndex(-1);
        data.deleteAttributeAt(this.m_Data.classIndex());
        return new InstancesView(data);
    }

    public SpreadSheet getOutputs() {
        if (this.m_Data.classIndex() == -1) {
            return null;
        }
        Instances data = new Instances(this.m_Data);
        data.setClassIndex(-1);
        Remove remove = new Remove();
        remove.setAttributeIndicesArray(new int[]{this.m_Data.classIndex()});
        remove.setInvertSelection(true);
        try {
            remove.setInputFormat(data);
            data = Filter.useFilter((Instances)data, (Filter)remove);
            return new InstancesView(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to apply Remove filter!", e);
        }
    }

    public SpreadSheetView toView(int[] rows, int[] columns) {
        return new SpreadSheetView((SpreadSheet)this, rows, columns);
    }
}

