/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.genetic;

import adams.data.weka.WekaLabelIndex;
import adams.flow.core.EvaluationHelper;
import adams.flow.core.EvaluationStatistic;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instances;

public enum Measure {
    ACC(false, true, false),
    CC(false, false, true),
    MAE(true, true, true),
    MSLE(false, false, true),
    RAE(true, true, true),
    RMSE(true, true, true),
    RRSE(true, true, true),
    RSQUARED(false, false, true),
    KAPPA(false, true, false),
    FALSE_POS_RATE(true, true, false, true),
    FALSE_NEG_RATE(true, true, false, true),
    TRUE_POS_RATE(false, true, false, true),
    TRUE_NEG_RATE(false, true, false, true),
    F_MEASURE(false, true, false, true),
    PRECISION(false, true, false, true),
    RECALL(false, true, false, true),
    AREA_UNDER_ROC(false, true, false, true),
    AREA_UNDER_PRC(false, true, false, true);

    private boolean m_Negative;
    private boolean m_Nominal;
    private boolean m_Numeric;
    private boolean m_PerClassLabel;

    private Measure(boolean negative, boolean nominal, boolean numeric) {
        this(negative, nominal, numeric, false);
    }

    private Measure(boolean negative, boolean nominal, boolean numeric, boolean perClassLabel) {
        this.m_Negative = negative;
        this.m_Nominal = nominal;
        this.m_Numeric = numeric;
        this.m_PerClassLabel = perClassLabel;
    }

    public EvaluationStatistic toEvaluationStatistic() {
        switch (this) {
            case ACC: {
                return EvaluationStatistic.PERCENT_CORRECT;
            }
            case CC: {
                return EvaluationStatistic.CORRELATION_COEFFICIENT;
            }
            case MAE: {
                return EvaluationStatistic.MEAN_ABSOLUTE_ERROR;
            }
            case RAE: {
                return EvaluationStatistic.RELATIVE_ABSOLUTE_ERROR;
            }
            case RMSE: {
                return EvaluationStatistic.ROOT_MEAN_SQUARED_ERROR;
            }
            case RRSE: {
                return EvaluationStatistic.ROOT_RELATIVE_SQUARED_ERROR;
            }
            case MSLE: {
                return EvaluationStatistic.MSLE;
            }
            case RSQUARED: {
                return EvaluationStatistic.RSQUARED;
            }
            case KAPPA: {
                return EvaluationStatistic.KAPPA_STATISTIC;
            }
            case FALSE_POS_RATE: {
                return EvaluationStatistic.FALSE_POSITIVE_RATE;
            }
            case FALSE_NEG_RATE: {
                return EvaluationStatistic.FALSE_NEGATIVE_RATE;
            }
            case TRUE_POS_RATE: {
                return EvaluationStatistic.TRUE_POSITIVE_RATE;
            }
            case TRUE_NEG_RATE: {
                return EvaluationStatistic.TRUE_NEGATIVE_RATE;
            }
            case F_MEASURE: {
                return EvaluationStatistic.F_MEASURE;
            }
            case PRECISION: {
                return EvaluationStatistic.IR_PRECISION;
            }
            case RECALL: {
                return EvaluationStatistic.IR_RECALL;
            }
            case AREA_UNDER_PRC: {
                return EvaluationStatistic.AREA_UNDER_PRC;
            }
            case AREA_UNDER_ROC: {
                return EvaluationStatistic.AREA_UNDER_ROC;
            }
        }
        throw new IllegalStateException("Unhandled measure: " + this);
    }

    public double extract(Evaluation evaluation, boolean adjust, int classLabel) throws Exception {
        double result = EvaluationHelper.getValue(evaluation, this.toEvaluationStatistic(), classLabel);
        if (adjust) {
            result = this.adjust(result);
        }
        return result;
    }

    public double adjust(double measure) {
        if (this.m_Negative) {
            return -measure;
        }
        return measure;
    }

    public String isValid(Instances data, String index) {
        if (data.classIndex() == -1) {
            return "No class attribute set!";
        }
        WekaLabelIndex idx = new WekaLabelIndex(index);
        idx.setData(data.classAttribute());
        int idxInt = idx.getIntIndex();
        if (data.classAttribute().isNominal()) {
            if (!this.m_Nominal) {
                return this + " is not for nominal classes!";
            }
            if (this.isPerClassLabel() && idxInt == -1) {
                return "Failed to locate class label '" + index + "'!";
            }
        } else if (data.classAttribute().isNumeric()) {
            if (!this.m_Numeric) {
                return this + " is not for numeric classes!";
            }
        } else {
            return "Class attribute type '" + Attribute.typeToString((int)data.classAttribute().type()) + "' not handled!";
        }
        return null;
    }

    public boolean isPerClassLabel() {
        return this.m_PerClassLabel;
    }
}

