/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.data.binning.Binnable;
import adams.data.binning.BinnableGroup;
import adams.data.binning.BinnableInstances;
import adams.data.binning.algorithm.BinningAlgorithm;
import adams.data.binning.algorithm.BinningAlgorithmUser;
import adams.data.binning.algorithm.ManualBinning;
import adams.data.binning.operation.Bins;
import adams.data.binning.operation.Grouping;
import adams.data.binning.operation.Stratify;
import adams.data.binning.operation.Wrapping;
import adams.data.binning.postprocessing.MinBinSize;
import adams.data.splitgenerator.generic.core.Subset;
import adams.data.splitgenerator.generic.crossvalidation.CrossValidationGenerator;
import adams.data.splitgenerator.generic.crossvalidation.FoldPair;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.Randomization;
import adams.data.weka.WekaAttributeIndex;
import adams.flow.container.WekaTrainTestSetContainer;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import weka.classifiers.AbstractSplitGenerator;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.CrossValidationHelper;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.InstancesView;

public class GroupedBinnedNumericClassCrossValidationFoldGenerator
extends AbstractSplitGenerator
implements CrossValidationFoldGenerator,
BinningAlgorithmUser {
    private static final long serialVersionUID = -8387205583429213079L;
    protected int m_NumFolds;
    protected boolean m_Stratify;
    protected transient int m_CurrentFold;
    protected String m_RelationName;
    protected boolean m_Randomize;
    protected WekaAttributeIndex m_Index;
    protected BaseRegExp m_RegExp;
    protected String m_Group;
    protected BinningAlgorithm m_Algorithm;
    protected transient List<FoldPair<Binnable<Instance>>> m_FoldPairs;

    public GroupedBinnedNumericClassCrossValidationFoldGenerator() {
    }

    public GroupedBinnedNumericClassCrossValidationFoldGenerator(Instances data, int numFolds, long seed, boolean stratify) {
        this(data, numFolds, seed, true, stratify, null);
    }

    public GroupedBinnedNumericClassCrossValidationFoldGenerator(Instances data, int numFolds, long seed, boolean randomize, boolean stratify, String relName) {
        this.setData(data);
        this.setSeed(seed);
        this.setNumFolds(numFolds);
        this.setRelationName(relName);
        this.setStratify(stratify);
        this.setRandomize(randomize);
    }

    public String globalInfo() {
        return "Generates cross-validation fold pairs. Uses binning algorithm to obtain similar class distributions. Groups instances according to the grouping expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-folds", "numFolds", (Object)10, (Number)2, null);
        this.m_OptionManager.add("relation-name", "relationName", (Object)"@");
        this.m_OptionManager.add("randomize", "randomize", (Object)true);
        this.m_OptionManager.add("stratify", "stratify", (Object)true);
        this.m_OptionManager.add("index", "index", (Object)new WekaAttributeIndex("first"));
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("group", "group", (Object)"$0");
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new ManualBinning());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentFold = 1;
        this.m_FoldPairs = null;
    }

    @Override
    public void setData(Instances value) {
        super.setData(value);
        if (this.m_Data != null) {
            if (this.m_Data.classIndex() == -1) {
                throw new IllegalArgumentException("No class attribute set!");
            }
            if (!this.m_Data.classAttribute().isNumeric()) {
                throw new IllegalArgumentException("Class attribute is not numeric!");
            }
        }
    }

    @Override
    public void setNumFolds(int value) {
        this.m_NumFolds = value;
        this.reset();
    }

    @Override
    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public String numFoldsTipText() {
        return "The number of folds; use <2 for leave one out (LOO).";
    }

    @Override
    public int getActualNumFolds() {
        return this.m_NumFolds;
    }

    @Override
    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    @Override
    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data is randomized first.";
    }

    @Override
    public void setStratify(boolean value) {
        this.m_Stratify = value;
        this.reset();
    }

    @Override
    public boolean getStratify() {
        return this.m_Stratify;
    }

    public String stratifyTipText() {
        return "If enabled, the folds get stratified in case of a nominal class attribute.";
    }

    @Override
    public void setRelationName(String value) {
        this.m_RelationName = value;
        this.reset();
    }

    @Override
    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return CrossValidationHelper.relationNameTemplateTipText();
    }

    public void setIndex(WekaAttributeIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public WekaAttributeIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The percentage to use for training (0-1).";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression for identifying the group (eg '^(.*)-([0-9]+)-(.*)$').";
    }

    public void setGroup(String value) {
        this.m_Group = value;
        this.reset();
    }

    public String getGroup() {
        return this.m_Group;
    }

    public String groupTipText() {
        return "The replacement string to use as group (eg '$2').";
    }

    public void setAlgorithm(BinningAlgorithm value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public BinningAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The binning algorithm to apply to the data.";
    }

    @Override
    protected boolean canRandomize() {
        return this.m_Randomize;
    }

    @Override
    protected boolean checkNext() {
        return this.m_CurrentFold <= this.m_NumFolds;
    }

    @Override
    protected void doInitializeIterator() {
        if (this.m_Data == null) {
            throw new IllegalStateException("No data provided!");
        }
        if (this.m_Data.numInstances() < this.m_NumFolds) {
            throw new IllegalArgumentException("Cannot have less data than folds: required=" + this.m_NumFolds + ", provided=" + this.m_Data.numInstances());
        }
        if (this.m_RelationName == null || this.m_RelationName.isEmpty()) {
            this.m_RelationName = "@";
        }
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        Instances test;
        Instances train;
        if (this.m_CurrentFold > this.m_NumFolds) {
            throw new NoSuchElementException("No more folds available!");
        }
        if (this.m_FoldPairs == null) {
            List binnableGroups;
            this.m_Index.setData(this.m_Data);
            try {
                List binnableInst = BinnableInstances.toBinnableUsingIndex(this.m_Data);
                binnableInst = Wrapping.addTmpIndex(binnableInst);
                List groupedInst = Grouping.groupAsList((List)binnableInst, (Grouping.GroupExtractor)new BinnableInstances.StringAttributeGroupExtractor(this.m_Index.getIntIndex(), this.m_RegExp.getValue(), this.m_Group));
                binnableGroups = Wrapping.wrap((Collection)groupedInst, (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create binnable groups!", e);
            }
            DefaultRandomization rand = new DefaultRandomization();
            rand.setSeed(this.m_Seed);
            if (this.canRandomize()) {
                binnableGroups = rand.randomize(binnableGroups);
            }
            List binGroups = this.m_Algorithm.generateBins(binnableGroups);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Bins: " + Utils.arrayToString((Object)Bins.binSizes((List)binGroups)));
            }
            MinBinSize minBinSize = new MinBinSize();
            minBinSize.setMinSize(2);
            binGroups = minBinSize.postProcessBins(binGroups);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Bins after post-processing: " + Utils.arrayToString((Object)Bins.binSizes((List)binGroups)));
            }
            binGroups = Bins.useBinIndex((List)binGroups);
            binnableGroups = Bins.flatten((List)binGroups);
            if (this.getStratify()) {
                binnableGroups = Stratify.stratify((List)binnableGroups, (int)this.m_NumFolds);
            }
            this.m_FoldPairs = new ArrayList<FoldPair<Binnable<Instance>>>();
            for (int i = 0; i < this.m_NumFolds; ++i) {
                List trainGrouped = CrossValidationGenerator.trainCV((List)binnableGroups, (int)this.m_NumFolds, (int)i, (Randomization)rand);
                ArrayList trainBinnable = new ArrayList();
                for (Binnable grouped : trainGrouped) {
                    trainBinnable.addAll(Grouping.ungroup((BinnableGroup)((BinnableGroup)grouped.getPayload())));
                }
                TIntList trainIndices = Wrapping.getTmpIndices(trainBinnable);
                Subset trainSub = new Subset(trainBinnable, trainIndices);
                List testGrouped = CrossValidationGenerator.testCV((List)binnableGroups, (int)this.m_NumFolds, (int)i);
                ArrayList testBinnable = new ArrayList();
                for (Binnable grouped : testGrouped) {
                    testBinnable.addAll(Grouping.ungroup((BinnableGroup)((BinnableGroup)grouped.getPayload())));
                }
                TIntList testIndices = Wrapping.getTmpIndices(testBinnable);
                Subset testSub = new Subset(testBinnable, testIndices);
                this.m_FoldPairs.add((FoldPair<Binnable<Instance>>)new FoldPair(i, trainSub, testSub));
            }
            this.m_OriginalIndices = new TIntArrayList();
            for (FoldPair<Binnable<Instance>> pair : this.m_FoldPairs) {
                this.m_OriginalIndices.addAll((TIntCollection)pair.getTest().getOriginalIndices());
            }
        }
        FoldPair<Binnable<Instance>> foldPair = this.m_FoldPairs.get(this.m_CurrentFold - 1);
        int[] trainRows = foldPair.getTrain().getOriginalIndices().toArray();
        int[] testRows = foldPair.getTest().getOriginalIndices().toArray();
        if (this.m_UseViews) {
            train = new InstancesView(this.m_Data, trainRows);
            test = new InstancesView(this.m_Data, testRows);
        } else {
            train = BinnableInstances.toInstances(foldPair.getTrain().getData());
            test = BinnableInstances.toInstances(foldPair.getTest().getData());
        }
        train.setRelationName(CrossValidationHelper.createRelationName(this.m_Data.relationName(), this.m_RelationName, this.m_CurrentFold, true));
        test.setRelationName(CrossValidationHelper.createRelationName(this.m_Data.relationName(), this.m_RelationName, this.m_CurrentFold, false));
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(train, test, this.m_Seed, this.m_CurrentFold, this.m_NumFolds, trainRows, testRows);
        ++this.m_CurrentFold;
        if (this.m_CurrentFold > this.m_NumFolds) {
            this.m_FoldPairs = null;
        }
        return result;
    }

    @Override
    public int[] crossValidationIndices() {
        return this.m_OriginalIndices.toArray();
    }

    @Override
    public String toString() {
        return super.toString() + ", numFolds=" + this.m_NumFolds + ", stratify=" + this.m_Stratify + ", relName=" + this.m_RelationName;
    }
}

