/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import adams.data.statistics.StatUtils;
import java.util.Arrays;
import java.util.List;
import weka.classifiers.evaluation.AbstractSimpleRegressionMeasure;
import weka.core.Utils;

public class Bias
extends AbstractSimpleRegressionMeasure {
    private static final long serialVersionUID = 6501729731780442367L;
    public static final String NAME = "Bias";

    public String getMetricName() {
        return NAME;
    }

    public String getMetricDescription() {
        return "Bias, also called Mean Error";
    }

    public List<String> getStatisticNames() {
        return Arrays.asList(NAME);
    }

    public double getStatistic(String statName) {
        if (statName.equals(NAME)) {
            if (this.m_Actual.size() == 0) {
                return Utils.missingValue();
            }
            return StatUtils.mean((double[])this.m_Predicted.toArray()) - StatUtils.mean((double[])this.m_Actual.toArray());
        }
        return Utils.missingValue();
    }

    public String toSummaryString() {
        double bias = this.getStatistic(NAME);
        int width = 41;
        if (bias >= 1.0) {
            width -= Integer.toString((int)bias).length() + 1;
        }
        return Utils.padRight((String)NAME, (int)width) + Utils.doubleToString((double)bias, (int)4) + "\n";
    }

    public boolean statisticIsMaximisable(String statName) {
        return false;
    }
}

