/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import adams.data.statistics.StatUtils;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Arrays;
import java.util.List;
import weka.classifiers.evaluation.AbstractSimpleRegressionMeasure;
import weka.core.Utils;

public class SDR
extends AbstractSimpleRegressionMeasure {
    private static final long serialVersionUID = -2991979775999208848L;
    public static final String NAME = "Standard Deviation of Residuals";

    public String getMetricName() {
        return NAME;
    }

    public String getMetricDescription() {
        return "Standard Deviation of Residuals = sqrt(mean((xc(:)-xm(:)-mean(xc(:))+mean(xm(:))).^2)); [m=measured, c=calculated]";
    }

    public List<String> getStatisticNames() {
        return Arrays.asList(NAME);
    }

    public double getStatistic(String statName) {
        if (statName.equals(NAME)) {
            if (this.m_Actual.size() == 0) {
                return Utils.missingValue();
            }
            TDoubleArrayList values = new TDoubleArrayList();
            double meanC = StatUtils.mean((double[])this.m_Predicted.toArray());
            double meanM = StatUtils.mean((double[])this.m_Actual.toArray());
            for (int i = 0; i < this.m_Actual.size(); ++i) {
                double val = this.m_Predicted.get(i) - this.m_Actual.get(i) - (meanC - meanM);
                values.add(val * val);
            }
            return Math.sqrt(StatUtils.mean((double[])values.toArray()));
        }
        return Utils.missingValue();
    }

    public String toSummaryString() {
        return Utils.padRight((String)NAME, (int)41) + Utils.doubleToString((double)this.getStatistic(NAME), (int)4) + "\n";
    }

    public boolean statisticIsMaximisable(String statName) {
        return false;
    }
}

