/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import adams.core.base.BaseString;
import adams.env.Environment;
import adams.parser.MathematicalExpression;
import adams.parser.MathematicalExpressionText;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class MathExpressionClassifier
extends AbstractClassifier
implements UpdateableClassifier {
    private static final long serialVersionUID = 8430850643799590721L;
    protected MathematicalExpressionText m_Expression = new MathematicalExpressionText("1.0");
    protected transient MathematicalExpression m_Parser;

    public MathExpressionClassifier() {
        if (Environment.getEnvironmentClass() == null) {
            Environment.setEnvironmentClass(Environment.class);
        }
    }

    public String globalInfo() {
        return "Simple classifier that uses a pre-defined formula that can make use of attribute values using their names.\nGrammar:\n" + new MathematicalExpression().getGrammar();
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe expression to use.\n\t(default: 1.0)", "expression", 1, "-expression <string>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<Object> result = new Vector<Object>();
        result.add("-expression");
        result.add("" + this.getExpression());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"expression", (String[])options);
        if (tmpStr.length() != 0) {
            this.setExpression(new MathematicalExpressionText(tmpStr));
        } else {
            this.setExpression(new MathematicalExpressionText("1.0"));
        }
        super.setOptions(options);
    }

    public void setExpression(MathematicalExpressionText value) {
        this.m_Expression = value;
    }

    public MathematicalExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The mathematical expression to evaluate.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected synchronized MathematicalExpression getParser() {
        if (this.m_Parser == null) {
            this.m_Parser = new MathematicalExpression();
            this.m_Parser.setExpression(this.m_Expression.getValue());
        }
        return this.m_Parser;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.m_Parser = this.getParser();
    }

    public void updateClassifier(Instance instance) throws Exception {
    }

    public double classifyInstance(Instance instance) throws Exception {
        MathematicalExpression parser = this.getParser();
        ArrayList<BaseString> values = new ArrayList<BaseString>();
        block4: for (int i = 0; i < instance.numAttributes(); ++i) {
            String name = instance.attribute(i).name();
            int type = instance.attribute(i).type();
            switch (type) {
                case 0: {
                    values.add(new BaseString(name + "=" + instance.value(i)));
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: {
                    values.add(new BaseString(name + "=" + instance.stringValue(i)));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((int)type));
                }
            }
        }
        parser.setSymbols(values.toArray(new BaseString[values.size()]));
        Double result = (Double)this.getParser().evaluate();
        if (result == null) {
            return Double.NaN;
        }
        return result;
    }

    public String getRevision() {
        return "$Revision$";
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(((Object)((Object)this)).getClass().getName() + "\n");
        result.append(((Object)((Object)this)).getClass().getName().replaceAll(".", "=") + "\n");
        result.append("\n");
        result.append("Expression: " + this.getExpression() + "\n");
        return result.toString();
    }

    public static void main(String[] args) {
        MathExpressionClassifier.runClassifier((Classifier)new MathExpressionClassifier(), (String[])args);
    }
}

