/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import org.apache.commons.math.distribution.TDistributionImpl;
import weka.classifiers.Classifier;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.functions.SimpleLinearRegressionWithAccess;
import weka.core.Instance;
import weka.core.RevisionUtils;
import weka.core.WekaException;

public class SimpleLinearRegressionIntervalEstimator
extends SimpleLinearRegressionWithAccess
implements IntervalEstimator {
    private static final long serialVersionUID = 2148259814445498954L;

    @Override
    public String globalInfo() {
        return super.globalInfo() + "\n\nProvides confidence intervals as well. For more information see:\nhttp://stattrek.com/regression/slope-confidence-interval.aspx";
    }

    public double[][] predictIntervals(Instance inst, double confidenceLevel) throws Exception {
        if (this.m_df < 1) {
            throw new WekaException("No degrees of freedom!");
        }
        double alpha = 1.0 - confidenceLevel;
        double critProb = 1.0 - alpha / 2.0;
        TDistributionImpl td = new TDistributionImpl((double)this.m_df);
        double critValue = td.inverseCumulativeProbability(critProb);
        double marginError = critValue * this.getSlopeSE();
        return new double[][]{{this.getSlope() - marginError, this.getSlope() + marginError}};
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 11128 $");
    }

    public static void main(String[] argv) {
        SimpleLinearRegressionIntervalEstimator.runClassifier((Classifier)new SimpleLinearRegressionIntervalEstimator(), (String[])argv);
    }
}

