/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ModelOutputHandler;
import weka.core.Utils;
import weka.core.WekaOptionUtils;

public class AbstainingCascade
extends MultipleClassifiersCombiner
implements ModelOutputHandler {
    private static final long serialVersionUID = 943666951855888860L;
    public static final String SUPPRESS_MODEL_OUTPUT = "suppress-model-output";
    protected boolean m_SuppressModelOutput = false;
    protected boolean m_Built = false;

    public String globalInfo() {
        return "The specified classifiers represent a cascade: if the first one abstains (or encounters an error making a prediction), the second is used (and so on), otherwise the prediction is returned.\nIf all classifiers prior to the last one abstained then the prediction of the last one is returned.";
    }

    @Override
    public void setSuppressModelOutput(boolean value) {
        this.m_SuppressModelOutput = value;
    }

    @Override
    public boolean getSuppressModelOutput() {
        return this.m_SuppressModelOutput;
    }

    @Override
    public String suppressModelOutputTipText() {
        return "If enabled, suppresses any large model output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addFlag(result, this.suppressModelOutputTipText(), SUPPRESS_MODEL_OUTPUT);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setSuppressModelOutput(Utils.getFlag((String)SUPPRESS_MODEL_OUTPUT, (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, SUPPRESS_MODEL_OUTPUT, this.getSuppressModelOutput());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            if (this.getDebug()) {
                System.err.println("Building classifier #" + (i + 1));
            }
            this.m_Classifiers[i].buildClassifier(data);
        }
        this.m_Built = true;
    }

    public double classifyInstance(Instance instance) throws Exception {
        double result = Utils.missingValue();
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            try {
                result = this.m_Classifiers[i].classifyInstance(instance);
                if (Utils.isMissingValue((double)result)) continue;
                break;
            }
            catch (Exception e) {
                if (i != this.m_Classifiers.length - 1) continue;
                throw e;
            }
        }
        return result;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = new double[instance.classAttribute().numValues()];
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            try {
                result = this.m_Classifiers[i].distributionForInstance(instance);
                if (!(Utils.sum((double[])result) > 0.0)) continue;
                break;
            }
            catch (Exception e) {
                if (i != this.m_Classifiers.length - 1) continue;
                throw e;
            }
        }
        return result;
    }

    public String toString() {
        if (!this.m_Built) {
            return "No model built yet";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=") + "\n\n");
        if (!this.m_SuppressModelOutput) {
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                result.append("\n");
                result.append("Classifier #" + (i + 1) + "\n");
                result.append(new String("Classifier #" + (i + 1)).replaceAll(".", "-") + "\n\n");
                result.append(this.m_Classifiers[i].toString());
            }
        }
        return result.toString();
    }
}

