/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import adams.data.statistics.StatUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Bagging;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class InputSmearing
extends Bagging {
    private static final long serialVersionUID = 8040692114355993432L;
    protected double m_StdDev = 1.0;

    public String globalInfo() {
        return "Extended version of " + Bagging.class.getName() + ", which allows input smearing of numeric attributes.\n" + super.globalInfo();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = super.getTechnicalInformation();
        TechnicalInformation additional = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Knowledge Discovery and Data Mining");
        additional.setValue(TechnicalInformation.Field.EDITOR, "Ng, Wee-Keong and Kitsuregawa, Masaru and Li, Jianzhong and Chang, Kuiyu");
        additional.setValue(TechnicalInformation.Field.TITLE, "Improving on Bagging with Input Smearing");
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Frank, Eibe and Pfahringer, Bernhard");
        additional.setValue(TechnicalInformation.Field.SERIES, "Lecture Notes in Computer Science");
        additional.setValue(TechnicalInformation.Field.VOLUME, "3918");
        additional.setValue(TechnicalInformation.Field.PAGES, "97-106");
        additional.setValue(TechnicalInformation.Field.YEAR, "2006");
        additional.setValue(TechnicalInformation.Field.ISBN, "978-3-540-33206-0");
        additional.setValue(TechnicalInformation.Field.URL, "http://dx.doi.org/10.1007/11731139_14");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Springer Berlin Heidelberg");
        result.add(additional);
        return result;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe multiplier for the standard deviation of a numeric attribute\n\tto use for performing the smearing (default 1.0)", "stddev", 1, "-stddev <number>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"stddev", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setStdDev(Double.parseDouble(tmpStr));
        } else {
            this.setStdDev(1.0);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<Object> options = new Vector<Object>();
        options.add("-stddev");
        options.add("" + this.getStdDev());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[options.size()]);
    }

    public double getStdDev() {
        return this.m_StdDev;
    }

    public void setStdDev(double value) {
        this.m_StdDev = value;
    }

    public String stdDevTipText() {
        return "The standard deviation to use for the input smearing.";
    }

    protected synchronized Instances getTrainingSet(int iteration) throws Exception {
        Instances bagData = super.getTrainingSet(iteration);
        Random rnd = new Random(this.m_Seed + iteration);
        for (int i = 0; i < bagData.numAttributes(); ++i) {
            if (bagData.attribute(i).type() != 0) continue;
            double[] values = bagData.attributeToDoubleArray(i);
            double stdev = StatUtils.stddev((double[])values, (boolean)true);
            for (Instance inst : bagData) {
                if (inst.attribute(i).type() != 0) continue;
                inst.setValue(i, inst.value(i) + rnd.nextGaussian() * stdev * this.m_StdDev);
            }
        }
        return bagData;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10470 $");
    }

    public static void main(String[] args) {
        InputSmearing.runClassifier((Classifier)new InputSmearing(), (String[])args);
    }
}

