/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.socketfacade;

import adams.data.conversion.Conversion;
import adams.data.conversion.MultiConversion;
import adams.data.conversion.SpreadSheetToString;
import adams.data.conversion.WekaInstancesToSpreadSheet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import weka.classifiers.meta.SocketFacade;
import weka.classifiers.meta.socketfacade.AbstractDataPreparation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class Simple
extends AbstractDataPreparation {
    private static final long serialVersionUID = -3495760632590255724L;

    public String globalInfo() {
        return "Simple preparation scheme, using JSON with the actual data in CSV format.";
    }

    protected byte[] toBytes(JsonObject json) {
        return json.toString().getBytes();
    }

    protected String toCSV(Instances data) {
        MultiConversion multi = new MultiConversion();
        multi.setSubConversions(new Conversion[]{new WekaInstancesToSpreadSheet(), new SpreadSheetToString()});
        multi.setInput((Object)data);
        multi.convert();
        return (String)multi.getOutput();
    }

    protected String toCSV(Instance inst) {
        Instances data = new Instances(inst.dataset(), 1);
        data.add((Instance)inst.copy());
        return this.toCSV(data);
    }

    protected void addDatasetInfo(JsonObject json, Instances data) {
        json.addProperty("class", data.classAttribute().name());
        json.addProperty("class_type", Attribute.typeToString((int)data.classAttribute().type()));
        if (data.classAttribute().isNominal()) {
            JsonArray labels = new JsonArray();
            for (int i = 0; i < data.classAttribute().numValues(); ++i) {
                labels.add(data.classAttribute().value(i));
            }
            json.add("class_labels", (JsonElement)labels);
        }
    }

    @Override
    public byte[] prepareTrain(Instances data, SocketFacade facade) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "train");
        json.addProperty("address", facade.getLocal().getValue());
        this.addDatasetInfo(json, data);
        json.addProperty("data", this.toCSV(data));
        return this.toBytes(json);
    }

    @Override
    public byte[] prepareClassify(Instance inst, SocketFacade facade) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "classify");
        json.addProperty("address", facade.getLocal().getValue());
        this.addDatasetInfo(json, inst.dataset());
        json.addProperty("data", this.toCSV(inst));
        return this.toBytes(json);
    }

    @Override
    public byte[] prepareDistribution(Instance inst, SocketFacade facade) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "distribution");
        json.addProperty("address", facade.getLocal().getValue());
        this.addDatasetInfo(json, inst.dataset());
        json.addProperty("data", this.toCSV(inst));
        return this.toBytes(json);
    }

    protected JsonElement fromBytes(byte[] data) {
        return JsonParser.parseReader((Reader)new StringReader(new String(data)));
    }

    @Override
    public String parseTrain(byte[] data) {
        JsonElement element = this.fromBytes(data);
        JsonObject json = element.getAsJsonObject();
        if (json.has("message") && !json.get("message").isJsonNull()) {
            return json.getAsJsonPrimitive("message").getAsString();
        }
        return null;
    }

    @Override
    public double parseClassify(byte[] data) {
        JsonElement element = this.fromBytes(data);
        JsonObject json = element.getAsJsonObject();
        if (json.has("error")) {
            this.getLogger().severe(json.get("error").getAsString());
            return Double.NaN;
        }
        return json.getAsJsonPrimitive("classification").getAsDouble();
    }

    @Override
    public double[] parseDistribution(byte[] data, int numClasses) {
        JsonElement element = this.fromBytes(data);
        JsonObject json = element.getAsJsonObject();
        if (json.has("error")) {
            this.getLogger().severe(json.get("error").getAsString());
            return new double[numClasses];
        }
        JsonArray array = json.getAsJsonArray("distribution");
        double[] result = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = array.get(i).getAsDouble();
        }
        return result;
    }
}

