/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import adams.multiprocess.CallableWithResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.clusterers.Canopy;
import weka.clusterers.Clusterer;
import weka.clusterers.FarthestFirst;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.RandomizableClusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ManhattanDistance;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SAXDistance;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class SAXKMeans
extends RandomizableClusterer
implements NumberOfClustersRequestable,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -3235809600124455376L;
    protected ReplaceMissingValues m_ReplaceMissingFilter;
    protected int m_NumClusters = 2;
    protected Instances m_initialStartPoints;
    protected Instances m_ClusterCentroids;
    protected Instances m_ClusterStdDevs;
    protected int[][][] m_ClusterNominalCounts;
    protected int[][] m_ClusterMissingCounts;
    protected double[] m_FullMeansOrMediansOrModes;
    protected double[] m_FullStdDevs;
    protected int[][] m_FullNominalCounts;
    protected int[] m_FullMissingCounts;
    protected boolean m_displayStdDevs;
    protected boolean m_dontReplaceMissing = false;
    protected int[] m_ClusterSizes;
    protected int m_MaxIterations = 500;
    protected int m_Iterations = 0;
    protected double[] m_squaredErrors;
    protected DistanceFunction m_DistanceFunction = new SAXDistance();
    protected boolean m_PreserveOrder = false;
    protected int[] m_Assignments = null;
    protected boolean m_FastDistanceCalc = false;
    public static final int RANDOM = 0;
    public static final int KMEANS_PLUS_PLUS = 1;
    public static final int CANOPY = 2;
    public static final int FARTHEST_FIRST = 3;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Random"), new Tag(1, "k-means++"), new Tag(2, "Canopy"), new Tag(3, "Farthest first")};
    protected int m_initializationMethod = 0;
    protected boolean m_speedUpDistanceCompWithCanopies = false;
    protected List<long[]> m_centroidCanopyAssignments;
    protected List<long[]> m_dataPointCanopyAssignments;
    protected Canopy m_canopyClusters;
    protected int m_maxCanopyCandidates = 100;
    protected int m_periodicPruningRate = 10000;
    protected double m_minClusterDensity = 2.0;
    protected double m_t2 = -1.0;
    protected double m_t1 = -1.25;
    protected int m_executionSlots = 1;
    protected transient ExecutorService m_executorPool;
    protected int m_completed;
    protected int m_failed;

    public SAXKMeans() {
        this.m_SeedDefault = 10;
        this.setSeed(this.m_SeedDefault);
    }

    protected void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = Executors.newFixedThreadPool(this.m_executionSlots);
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "D. Arthur and S. Vassilvitskii");
        result.setValue(TechnicalInformation.Field.TITLE, "k-means++: the advantages of carefull seeding");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the eighteenth annual ACM-SIAM symposium on Discrete algorithms");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.PAGES, "1027-1035");
        TechnicalInformation additional = new TechnicalInformation(TechnicalInformation.Type.PROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Chiu, B. and Keogh, E. and Lonardi, S.");
        additional.setValue(TechnicalInformation.Field.TITLE, "Probabilistic Discovery of Time Series Motifs");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "9th ACM SIGKDD International Conference on Knowledge Discovery and Data Mining");
        additional.setValue(TechnicalInformation.Field.PAGES, "493-498");
        additional.setValue(TechnicalInformation.Field.YEAR, "2003");
        additional.setValue(TechnicalInformation.Field.LOCATION, "Washington, DC, USA");
        additional.setValue(TechnicalInformation.Field.PDF, "http://www.cs.ucr.edu/~eamonn/SIGKDD_Motif.pdf");
        result.add(additional);
        return result;
    }

    public String globalInfo() {
        return "Cluster data using the k means algorithm. Can use either the Euclidean distance (default) or the Manhattan distance. If the Manhattan distance is used, then centroids are computed as the component-wise median rather than mean. For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    protected int launchMoveCentroids(Instances[] clusters) {
        int emptyClusterCount = 0;
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.m_NumClusters; ++i) {
            if (clusters[i].numInstances() == 0) {
                ++emptyClusterCount;
                continue;
            }
            Future future = this.m_executorPool.submit(new KMeansComputeCentroidTask(i, clusters[i]));
            results.add(future);
        }
        try {
            for (Future future : results) {
                this.m_ClusterCentroids.add((Instance)new DenseInstance(1.0, (double[])future.get()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return emptyClusterCount;
    }

    protected boolean launchAssignToClusters(Instances insts, int[] clusterAssignments) throws Exception {
        int numPerTask = insts.numInstances() / this.m_executionSlots;
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.m_executionSlots; ++i) {
            int start = i * numPerTask;
            int n = start + numPerTask;
            if (i == this.m_executionSlots - 1) {
                n = insts.numInstances();
            }
            Future futureKM = this.m_executorPool.submit(new KMeansClusterTask(insts, start, n, clusterAssignments));
            results.add(futureKM);
        }
        boolean converged = true;
        for (Future future : results) {
            if (((Boolean)future.get()).booleanValue()) continue;
            converged = false;
        }
        return converged;
    }

    public void buildClusterer(Instances data) throws Exception {
        int i;
        this.m_canopyClusters = null;
        this.getCapabilities().testWithFail(data);
        this.m_Iterations = 0;
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        Instances instances = new Instances(data);
        instances.setClassIndex(-1);
        if (!this.m_dontReplaceMissing) {
            this.m_ReplaceMissingFilter.setInputFormat(instances);
            instances = Filter.useFilter((Instances)instances, (Filter)this.m_ReplaceMissingFilter);
        }
        this.m_FullMissingCounts = new int[instances.numAttributes()];
        if (this.m_displayStdDevs) {
            this.m_FullStdDevs = new double[instances.numAttributes()];
        }
        this.m_FullNominalCounts = new int[instances.numAttributes()][0];
        this.m_FullMeansOrMediansOrModes = this.moveCentroid(0, instances, false, false);
        for (int i2 = 0; i2 < instances.numAttributes(); ++i2) {
            this.m_FullMissingCounts[i2] = instances.attributeStats((int)i2).missingCount;
            if (instances.attribute(i2).isNumeric()) {
                if (this.m_displayStdDevs) {
                    this.m_FullStdDevs[i2] = Math.sqrt(instances.variance(i2));
                }
                if (this.m_FullMissingCounts[i2] != instances.numInstances()) continue;
                this.m_FullMeansOrMediansOrModes[i2] = Double.NaN;
                continue;
            }
            this.m_FullNominalCounts[i2] = instances.attributeStats((int)i2).nominalCounts;
            if (this.m_FullMissingCounts[i2] <= this.m_FullNominalCounts[i2][Utils.maxIndex((int[])this.m_FullNominalCounts[i2])]) continue;
            this.m_FullMeansOrMediansOrModes[i2] = -1.0;
        }
        this.m_ClusterCentroids = new Instances(instances, this.m_NumClusters);
        int[] clusterAssignments = new int[instances.numInstances()];
        if (this.m_PreserveOrder) {
            this.m_Assignments = clusterAssignments;
        }
        this.m_DistanceFunction.setInstances(instances);
        Random RandomO = new Random(this.getSeed());
        HashMap initC = new HashMap();
        DecisionTableHashKey hk = null;
        Instances initInstances = null;
        initInstances = this.m_PreserveOrder ? new Instances(instances) : instances;
        if (this.m_speedUpDistanceCompWithCanopies) {
            this.m_canopyClusters = new Canopy();
            this.m_canopyClusters.setNumClusters(this.m_NumClusters);
            this.m_canopyClusters.setSeed(this.getSeed());
            this.m_canopyClusters.setT2(this.getCanopyT2());
            this.m_canopyClusters.setT1(this.getCanopyT1());
            this.m_canopyClusters.setMaxNumCandidateCanopiesToHoldInMemory(this.getCanopyMaxNumCanopiesToHoldInMemory());
            this.m_canopyClusters.setPeriodicPruningRate(this.getCanopyPeriodicPruningRate());
            this.m_canopyClusters.setMinimumCanopyDensity(this.getCanopyMinimumCanopyDensity());
            this.m_canopyClusters.setDebug(this.getDebug());
            this.m_canopyClusters.buildClusterer(initInstances);
            this.m_centroidCanopyAssignments = new ArrayList<long[]>();
            this.m_dataPointCanopyAssignments = new ArrayList<long[]>();
        }
        if (this.m_initializationMethod == 1) {
            this.kMeansPlusPlusInit(initInstances);
            this.m_initialStartPoints = new Instances(this.m_ClusterCentroids);
        } else if (this.m_initializationMethod == 2) {
            this.canopyInit(initInstances);
            this.m_initialStartPoints = new Instances(this.m_canopyClusters.getCanopies());
        } else if (this.m_initializationMethod == 3) {
            this.farthestFirstInit(initInstances);
            this.m_initialStartPoints = new Instances(this.m_ClusterCentroids);
        } else {
            for (int j = initInstances.numInstances() - 1; j >= 0; --j) {
                int instIndex = RandomO.nextInt(j + 1);
                hk = new DecisionTableHashKey(initInstances.instance(instIndex), initInstances.numAttributes(), true);
                if (!initC.containsKey(hk)) {
                    this.m_ClusterCentroids.add(initInstances.instance(instIndex));
                    initC.put(hk, null);
                }
                initInstances.swap(j, instIndex);
                if (this.m_ClusterCentroids.numInstances() == this.m_NumClusters) break;
            }
            this.m_initialStartPoints = new Instances(this.m_ClusterCentroids);
        }
        if (this.m_speedUpDistanceCompWithCanopies) {
            for (i = 0; i < instances.numInstances(); ++i) {
                this.m_dataPointCanopyAssignments.add(this.m_canopyClusters.assignCanopies(instances.instance(i)));
            }
        }
        this.m_NumClusters = this.m_ClusterCentroids.numInstances();
        initInstances = null;
        boolean converged = false;
        Instances[] tempI = new Instances[this.m_NumClusters];
        this.m_squaredErrors = new double[this.m_NumClusters];
        this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances.numAttributes()][0];
        this.m_ClusterMissingCounts = new int[this.m_NumClusters][instances.numAttributes()];
        this.startExecutorPool();
        while (!converged) {
            if (this.m_speedUpDistanceCompWithCanopies) {
                this.m_centroidCanopyAssignments.clear();
                for (int kk = 0; kk < this.m_ClusterCentroids.numInstances(); ++kk) {
                    this.m_centroidCanopyAssignments.add(this.m_canopyClusters.assignCanopies(this.m_ClusterCentroids.instance(kk)));
                }
            }
            int emptyClusterCount = 0;
            ++this.m_Iterations;
            converged = true;
            if (this.m_executionSlots <= 1 || instances.numInstances() < 2 * this.m_executionSlots) {
                for (i = 0; i < instances.numInstances(); ++i) {
                    Instance toCluster = instances.instance(i);
                    int newC = this.clusterProcessedInstance(toCluster, false, true, this.m_speedUpDistanceCompWithCanopies ? this.m_dataPointCanopyAssignments.get(i) : null);
                    if (newC != clusterAssignments[i]) {
                        converged = false;
                    }
                    clusterAssignments[i] = newC;
                }
            } else {
                converged = this.launchAssignToClusters(instances, clusterAssignments);
            }
            this.m_ClusterCentroids = new Instances(instances, this.m_NumClusters);
            for (i = 0; i < this.m_NumClusters; ++i) {
                tempI[i] = new Instances(instances, 0);
            }
            for (i = 0; i < instances.numInstances(); ++i) {
                tempI[clusterAssignments[i]].add(instances.instance(i));
            }
            if (this.m_executionSlots <= 1 || instances.numInstances() < 2 * this.m_executionSlots) {
                for (i = 0; i < this.m_NumClusters; ++i) {
                    if (tempI[i].numInstances() == 0) {
                        ++emptyClusterCount;
                        continue;
                    }
                    this.moveCentroid(i, tempI[i], true, true);
                }
            } else {
                emptyClusterCount = this.launchMoveCentroids(tempI);
            }
            if (this.m_Iterations == this.m_MaxIterations) {
                converged = true;
            }
            if (emptyClusterCount > 0) {
                this.m_NumClusters -= emptyClusterCount;
                if (converged) {
                    Instances[] t = new Instances[this.m_NumClusters];
                    int index = 0;
                    for (int k = 0; k < tempI.length; ++k) {
                        if (tempI[k].numInstances() <= 0) continue;
                        t[index] = tempI[k];
                        for (i = 0; i < tempI[k].numAttributes(); ++i) {
                            this.m_ClusterNominalCounts[index][i] = this.m_ClusterNominalCounts[k][i];
                        }
                        ++index;
                    }
                    tempI = t;
                } else {
                    tempI = new Instances[this.m_NumClusters];
                }
            }
            if (converged) continue;
            this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances.numAttributes()][0];
        }
        if (!this.m_FastDistanceCalc) {
            for (i = 0; i < instances.numInstances(); ++i) {
                this.clusterProcessedInstance(instances.instance(i), true, false, null);
            }
        }
        if (this.m_displayStdDevs) {
            this.m_ClusterStdDevs = new Instances(instances, this.m_NumClusters);
        }
        this.m_ClusterSizes = new int[this.m_NumClusters];
        for (i = 0; i < this.m_NumClusters; ++i) {
            if (this.m_displayStdDevs) {
                double[] vals2 = new double[instances.numAttributes()];
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    vals2[j] = instances.attribute(j).isNumeric() ? Math.sqrt(tempI[i].variance(j)) : Utils.missingValue();
                }
                this.m_ClusterStdDevs.add((Instance)new DenseInstance(1.0, vals2));
            }
            this.m_ClusterSizes[i] = tempI[i].numInstances();
        }
        this.m_executorPool.shutdown();
        this.m_DistanceFunction.clean();
    }

    protected void canopyInit(Instances data) throws Exception {
        if (this.m_canopyClusters == null) {
            this.m_canopyClusters = new Canopy();
            this.m_canopyClusters.setNumClusters(this.m_NumClusters);
            this.m_canopyClusters.setSeed(this.getSeed());
            this.m_canopyClusters.setT2(this.getCanopyT2());
            this.m_canopyClusters.setT1(this.getCanopyT1());
            this.m_canopyClusters.setMaxNumCandidateCanopiesToHoldInMemory(this.getCanopyMaxNumCanopiesToHoldInMemory());
            this.m_canopyClusters.setPeriodicPruningRate(this.getCanopyPeriodicPruningRate());
            this.m_canopyClusters.setMinimumCanopyDensity(this.getCanopyMinimumCanopyDensity());
            this.m_canopyClusters.setDebug(this.getDebug());
            this.m_canopyClusters.buildClusterer(data);
        }
        this.m_ClusterCentroids = this.m_canopyClusters.getCanopies();
    }

    protected void farthestFirstInit(Instances data) throws Exception {
        FarthestFirst ff = new FarthestFirst();
        ff.setNumClusters(this.m_NumClusters);
        ff.buildClusterer(data);
        this.m_ClusterCentroids = ff.getClusterCentroids();
    }

    protected void kMeansPlusPlusInit(Instances data) throws Exception {
        Random randomO = new Random(this.getSeed());
        HashMap initC = new HashMap();
        int index = randomO.nextInt(data.numInstances());
        this.m_ClusterCentroids.add(data.instance(index));
        DecisionTableHashKey hk = new DecisionTableHashKey(data.instance(index), data.numAttributes(), true);
        initC.put(hk, null);
        int iteration = 0;
        int remainingInstances = data.numInstances() - 1;
        if (this.m_NumClusters > 1) {
            int i;
            double[] distances = new double[data.numInstances()];
            double[] cumProbs = new double[data.numInstances()];
            for (i = 0; i < data.numInstances(); ++i) {
                distances[i] = this.m_DistanceFunction.distance(data.instance(i), this.m_ClusterCentroids.instance(iteration));
            }
            for (i = 1; i < this.m_NumClusters; ++i) {
                int k;
                double[] weights = new double[data.numInstances()];
                System.arraycopy(distances, 0, weights, 0, distances.length);
                Utils.normalize((double[])weights);
                double sumOfProbs = 0.0;
                for (int k2 = 0; k2 < data.numInstances(); ++k2) {
                    cumProbs[k2] = sumOfProbs += weights[k2];
                }
                cumProbs[data.numInstances() - 1] = 1.0;
                double prob = randomO.nextDouble();
                for (k = 0; k < cumProbs.length; ++k) {
                    if (!(prob < cumProbs[k])) continue;
                    Instance candidateCenter = data.instance(k);
                    hk = new DecisionTableHashKey(candidateCenter, data.numAttributes(), true);
                    if (!initC.containsKey(hk)) {
                        initC.put(hk, null);
                        this.m_ClusterCentroids.add(candidateCenter);
                    } else {
                        System.err.println("We shouldn't get here....");
                    }
                    --remainingInstances;
                    break;
                }
                ++iteration;
                if (remainingInstances == 0) break;
                for (k = 0; k < data.numInstances(); ++k) {
                    double newDist;
                    if (!(distances[k] > 0.0) || !((newDist = this.m_DistanceFunction.distance(data.instance(k), this.m_ClusterCentroids.instance(iteration))) < distances[k])) continue;
                    distances[k] = newDist;
                }
            }
        }
    }

    protected double[] moveCentroid(int centroidIndex, Instances members, boolean updateClusterInfo, boolean addToCentroidInstances) {
        double[] vals = new double[members.numAttributes()];
        Instances sortedMembers = null;
        int middle = 0;
        boolean dataIsEven = false;
        if (this.m_DistanceFunction instanceof ManhattanDistance) {
            middle = (members.numInstances() - 1) / 2;
            dataIsEven = members.numInstances() % 2 == 0;
            sortedMembers = this.m_PreserveOrder ? members : new Instances(members);
        }
        for (int j = 0; j < members.numAttributes(); ++j) {
            if (this.m_DistanceFunction instanceof EuclideanDistance || this.m_DistanceFunction instanceof SAXDistance || members.attribute(j).isNominal()) {
                vals[j] = members.meanOrMode(j);
            } else if (this.m_DistanceFunction instanceof ManhattanDistance) {
                if (members.numInstances() == 1) {
                    vals[j] = members.instance(0).value(j);
                } else {
                    vals[j] = sortedMembers.kthSmallestValue(j, middle + 1);
                    if (dataIsEven) {
                        vals[j] = (vals[j] + sortedMembers.kthSmallestValue(j, middle + 2)) / 2.0;
                    }
                }
            }
            if (!updateClusterInfo) continue;
            this.m_ClusterMissingCounts[centroidIndex][j] = members.attributeStats((int)j).missingCount;
            this.m_ClusterNominalCounts[centroidIndex][j] = members.attributeStats((int)j).nominalCounts;
            if (members.attribute(j).isNominal()) {
                if (this.m_ClusterMissingCounts[centroidIndex][j] <= this.m_ClusterNominalCounts[centroidIndex][j][Utils.maxIndex((int[])this.m_ClusterNominalCounts[centroidIndex][j])]) continue;
                vals[j] = Utils.missingValue();
                continue;
            }
            if (this.m_ClusterMissingCounts[centroidIndex][j] != members.numInstances()) continue;
            vals[j] = Utils.missingValue();
        }
        if (addToCentroidInstances) {
            this.m_ClusterCentroids.add((Instance)new DenseInstance(1.0, vals));
        }
        return vals;
    }

    private int clusterProcessedInstance(Instance instance, boolean updateErrors, boolean useFastDistCalc, long[] instanceCanopies) {
        double minDist = 2.147483647E9;
        int bestCluster = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            double dist;
            if (useFastDistCalc) {
                if (this.m_speedUpDistanceCompWithCanopies && instanceCanopies != null && instanceCanopies.length > 0) {
                    try {
                        if (!Canopy.nonEmptyCanopySetIntersection((long[])this.m_centroidCanopyAssignments.get(i), (long[])instanceCanopies)) {
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    dist = this.m_DistanceFunction.distance(instance, this.m_ClusterCentroids.instance(i), minDist);
                } else {
                    dist = this.m_DistanceFunction.distance(instance, this.m_ClusterCentroids.instance(i), minDist);
                }
            } else {
                dist = this.m_DistanceFunction.distance(instance, this.m_ClusterCentroids.instance(i));
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
            bestCluster = i;
        }
        if (updateErrors) {
            if (this.m_DistanceFunction instanceof EuclideanDistance || this.m_DistanceFunction instanceof SAXDistance) {
                minDist *= minDist;
            }
            int n = bestCluster;
            this.m_squaredErrors[n] = this.m_squaredErrors[n] + minDist;
        }
        return bestCluster;
    }

    public int clusterInstance(Instance instance) throws Exception {
        Instance inst = null;
        if (!this.m_dontReplaceMissing) {
            this.m_ReplaceMissingFilter.input(instance);
            this.m_ReplaceMissingFilter.batchFinished();
            inst = this.m_ReplaceMissingFilter.output();
        } else {
            inst = instance;
        }
        return this.clusterProcessedInstance(inst, false, true, null);
    }

    public int numberOfClusters() throws Exception {
        return this.m_NumClusters;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tNumber of clusters.\n\t(default 2).", "N", 1, "-N <num>"));
        result.addElement(new Option("\tInitialization method to use.\n\t0 = random, 1 = k-means++, 2 = canopy, 3 = farthest first.\n\t(default = 0)", "init", 1, "-init"));
        result.addElement(new Option("\tUse canopies to reduce the number of distance calculations.", "C", 0, "-C"));
        result.addElement(new Option("\tMaximum number of candidate canopies to retain in memory\n\tat any one time when using canopy clustering.\n\tT2 distance plus, data characteristics,\n\twill determine how many candidate canopies are formed before\n\tperiodic and final pruning are performed, which might result\n\tin exceess memory consumption. This setting avoids large numbers\n\tof candidate canopies consuming memory. (default = 100)", "-max-candidates", 1, "-max-candidates <num>"));
        result.addElement(new Option("\tHow often to prune low density canopies when using canopy clustering. \n\t(default = every 10,000 training instances)", "periodic-pruning", 1, "-periodic-pruning <num>"));
        result.addElement(new Option("\tMinimum canopy density, when using canopy clustering, below which\n\t a canopy will be pruned during periodic pruning. (default = 2 instances)", "min-density", 1, "-min-density"));
        result.addElement(new Option("\tThe T2 distance to use when using canopy clustering. Values < 0 indicate that\n\ta heuristic based on attribute std. deviation should be used to set this.\n\t(default = -1.0)", "t2", 1, "-t2"));
        result.addElement(new Option("\tThe T1 distance to use when using canopy clustering. A value < 0 is taken as a\n\tpositive multiplier for T2. (default = -1.5)", "t1", 1, "-t1"));
        result.addElement(new Option("\tDisplay std. deviations for centroids.\n", "V", 0, "-V"));
        result.addElement(new Option("\tDon't replace missing values with mean/mode.\n", "M", 0, "-M"));
        result.add(new Option("\tDistance function to use.\n\t(default: weka.core.SAXDistance)", "A", 1, "-A <classname and options>"));
        result.add(new Option("\tMaximum number of iterations.\n", "I", 1, "-I <num>"));
        result.addElement(new Option("\tPreserve order of instances.\n", "O", 0, "-O"));
        result.addElement(new Option("\tEnables faster distance calculations, using cut-off values.\n\tDisables the calculation/output of squared errors/distances.\n", "fast", 0, "-fast"));
        result.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public String numClustersTipText() {
        return "set number of clusters";
    }

    public void setNumClusters(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public String initializationMethodTipText() {
        return "The initialization method to use. Random, k-means++, Canopy or farthest first";
    }

    public void setInitializationMethod(SelectedTag method) {
        if (method.getTags() == TAGS_SELECTION) {
            this.m_initializationMethod = method.getSelectedTag().getID();
        }
    }

    public SelectedTag getInitializationMethod() {
        return new SelectedTag(this.m_initializationMethod, TAGS_SELECTION);
    }

    public String reduceNumberOfDistanceCalcsViaCanopiesTipText() {
        return "Use canopy clustering to reduce the number of distance calculations performed by k-means";
    }

    public void setReduceNumberOfDistanceCalcsViaCanopies(boolean c) {
        this.m_speedUpDistanceCompWithCanopies = c;
    }

    public boolean getReduceNumberOfDistanceCalcsViaCanopies() {
        return this.m_speedUpDistanceCompWithCanopies;
    }

    public String canopyPeriodicPruningRateTipText() {
        return "If using canopy clustering for initialization and/or speedup this is how often to prune low density canopies during training";
    }

    public void setCanopyPeriodicPruningRate(int p) {
        this.m_periodicPruningRate = p;
    }

    public int getCanopyPeriodicPruningRate() {
        return this.m_periodicPruningRate;
    }

    public String canopyMinimumCanopyDensityTipText() {
        return "If using canopy clustering for initialization and/or speedup this is the minimum T2-based density below which a canopy will be pruned during periodic pruning";
    }

    public void setCanopyMinimumCanopyDensity(double dens) {
        this.m_minClusterDensity = dens;
    }

    public double getCanopyMinimumCanopyDensity() {
        return this.m_minClusterDensity;
    }

    public String canopyMaxNumCanopiesToHoldInMemoryTipText() {
        return "If using canopy clustering for initialization and/or speedup this is the maximum number of candidate canopies to retain in main memory during training of the canopy clusterer. T2 distance and data characteristics determine how many candidate canopies are formed before periodic and final pruning are performed. There may not be enough memory available if T2 is set too low.";
    }

    public void setCanopyMaxNumCanopiesToHoldInMemory(int max) {
        this.m_maxCanopyCandidates = max;
    }

    public int getCanopyMaxNumCanopiesToHoldInMemory() {
        return this.m_maxCanopyCandidates;
    }

    public String canopyT2TipText() {
        return "The T2 distance to use when using canopy clustering. Values < 0 indicate that this should be set using a heuristic based on attribute standard deviation";
    }

    public void setCanopyT2(double t2) {
        this.m_t2 = t2;
    }

    public double getCanopyT2() {
        return this.m_t2;
    }

    public String canopyT1TipText() {
        return "The T1 distance to use when using canopy clustering. Values < 0 are taken as a positive multiplier for the T2 distance";
    }

    public void setCanopyT1(double t1) {
        this.m_t1 = t1;
    }

    public double getCanopyT1() {
        return this.m_t1;
    }

    public String maxIterationsTipText() {
        return "set maximum number of iterations";
    }

    public void setMaxIterations(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Maximum number of iterations must be > 0");
        }
        this.m_MaxIterations = n;
    }

    public int getMaxIterations() {
        return this.m_MaxIterations;
    }

    public String displayStdDevsTipText() {
        return "Display std deviations of numeric attributes and counts of nominal attributes.";
    }

    public void setDisplayStdDevs(boolean stdD) {
        this.m_displayStdDevs = stdD;
    }

    public boolean getDisplayStdDevs() {
        return this.m_displayStdDevs;
    }

    public String dontReplaceMissingValuesTipText() {
        return "Replace missing values globally with mean/mode.";
    }

    public void setDontReplaceMissingValues(boolean r) {
        this.m_dontReplaceMissing = r;
    }

    public boolean getDontReplaceMissingValues() {
        return this.m_dontReplaceMissing;
    }

    public String distanceFunctionTipText() {
        return "The distance function to use for instances comparison (default: weka.core.SAXDistance). ";
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public void setDistanceFunction(DistanceFunction df) throws Exception {
        if (!(df instanceof EuclideanDistance || df instanceof ManhattanDistance || df instanceof SAXDistance)) {
            throw new Exception("SimpleKMeans currently only supports the Euclidean, SAX and Manhattan distances.");
        }
        this.m_DistanceFunction = df;
    }

    public String preserveInstancesOrderTipText() {
        return "Preserve order of instances.";
    }

    public void setPreserveInstancesOrder(boolean r) {
        this.m_PreserveOrder = r;
    }

    public boolean getPreserveInstancesOrder() {
        return this.m_PreserveOrder;
    }

    public String fastDistanceCalcTipText() {
        return "Uses cut-off values for speeding up distance calculation, but suppresses also the calculation and output of the within cluster sum of squared errors/sum of distances.";
    }

    public void setFastDistanceCalc(boolean value) {
        this.m_FastDistanceCalc = value;
    }

    public boolean getFastDistanceCalc() {
        return this.m_FastDistanceCalc;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use. Set equal to the number of available cpu/cores";
    }

    public void setNumExecutionSlots(int slots) {
        this.m_executionSlots = slots;
    }

    public int getNumExecutionSlots() {
        return this.m_executionSlots;
    }

    public void setOptions(String[] options) throws Exception {
        String distFunctionClass;
        String optionString;
        this.m_displayStdDevs = Utils.getFlag((String)"V", (String[])options);
        this.m_dontReplaceMissing = Utils.getFlag((String)"M", (String[])options);
        String initM = Utils.getOption((String)"init", (String[])options);
        if (initM.length() > 0) {
            this.setInitializationMethod(new SelectedTag(Integer.parseInt(initM), TAGS_SELECTION));
        }
        this.m_speedUpDistanceCompWithCanopies = Utils.getFlag((char)'C', (String[])options);
        String temp = Utils.getOption((String)"max-candidates", (String[])options);
        if (temp.length() > 0) {
            this.setCanopyMaxNumCanopiesToHoldInMemory(Integer.parseInt(temp));
        }
        if ((temp = Utils.getOption((String)"periodic-pruning", (String[])options)).length() > 0) {
            this.setCanopyPeriodicPruningRate(Integer.parseInt(temp));
        }
        if ((temp = Utils.getOption((String)"min-density", (String[])options)).length() > 0) {
            this.setCanopyMinimumCanopyDensity(Double.parseDouble(temp));
        }
        if ((temp = Utils.getOption((String)"t2", (String[])options)).length() > 0) {
            this.setCanopyT2(Double.parseDouble(temp));
        }
        if ((temp = Utils.getOption((String)"t1", (String[])options)).length() > 0) {
            this.setCanopyT1(Double.parseDouble(temp));
        }
        if ((optionString = Utils.getOption((char)'N', (String[])options)).length() != 0) {
            this.setNumClusters(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption((String)"I", (String[])options)).length() != 0) {
            this.setMaxIterations(Integer.parseInt(optionString));
        }
        if ((distFunctionClass = Utils.getOption((char)'A', (String[])options)).length() != 0) {
            String[] distFunctionClassSpec = Utils.splitOptions((String)distFunctionClass);
            if (distFunctionClassSpec.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String className = distFunctionClassSpec[0];
            distFunctionClassSpec[0] = "";
            this.setDistanceFunction((DistanceFunction)Utils.forName(DistanceFunction.class, (String)className, (String[])distFunctionClassSpec));
        } else {
            this.setDistanceFunction((DistanceFunction)new SAXDistance());
        }
        this.m_PreserveOrder = Utils.getFlag((String)"O", (String[])options);
        this.m_FastDistanceCalc = Utils.getFlag((String)"fast", (String[])options);
        String slotsS = Utils.getOption((String)"num-slots", (String[])options);
        if (slotsS.length() > 0) {
            this.setNumExecutionSlots(Integer.parseInt(slotsS));
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<Object> result = new Vector<Object>();
        result.add("-init");
        result.add("" + this.getInitializationMethod().getSelectedTag().getID());
        if (this.m_speedUpDistanceCompWithCanopies) {
            result.add("-C");
        }
        result.add("-max-candidates");
        result.add("" + this.getCanopyMaxNumCanopiesToHoldInMemory());
        result.add("-periodic-pruning");
        result.add("" + this.getCanopyPeriodicPruningRate());
        result.add("-min-density");
        result.add("" + this.getCanopyMinimumCanopyDensity());
        result.add("-t1");
        result.add("" + this.getCanopyT1());
        result.add("-t2");
        result.add("" + this.getCanopyT2());
        if (this.m_displayStdDevs) {
            result.add("-V");
        }
        if (this.m_dontReplaceMissing) {
            result.add("-M");
        }
        result.add("-N");
        result.add("" + this.getNumClusters());
        result.add("-A");
        result.add((this.m_DistanceFunction.getClass().getName() + " " + Utils.joinOptions((String[])this.m_DistanceFunction.getOptions())).trim());
        result.add("-I");
        result.add("" + this.getMaxIterations());
        if (this.m_PreserveOrder) {
            result.add("-O");
        }
        if (this.m_FastDistanceCalc) {
            result.add("-fast");
        }
        result.add("-num-slots");
        result.add("" + this.getNumExecutionSlots());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        int i;
        int i2;
        int i3;
        if (this.m_ClusterCentroids == null) {
            return "No clusterer built yet!";
        }
        int maxWidth = 0;
        int maxAttWidth = 0;
        boolean containsNumeric = false;
        for (i3 = 0; i3 < this.m_NumClusters; ++i3) {
            for (int j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
                if (this.m_ClusterCentroids.attribute(j).name().length() > maxAttWidth) {
                    maxAttWidth = this.m_ClusterCentroids.attribute(j).name().length();
                }
                if (!this.m_ClusterCentroids.attribute(j).isNumeric()) continue;
                containsNumeric = true;
                double width = Math.log(Math.abs(this.m_ClusterCentroids.instance(i3).value(j))) / Math.log(10.0);
                if (width < 0.0) {
                    width = 1.0;
                }
                if ((int)(width += 6.0) <= maxWidth) continue;
                maxWidth = (int)width;
            }
        }
        for (i3 = 0; i3 < this.m_ClusterCentroids.numAttributes(); ++i3) {
            Object val;
            int j;
            if (!this.m_ClusterCentroids.attribute(i3).isNominal()) continue;
            Attribute a = this.m_ClusterCentroids.attribute(i3);
            for (j = 0; j < this.m_ClusterCentroids.numInstances(); ++j) {
                val = a.value((int)this.m_ClusterCentroids.instance(j).value(i3));
                if (((String)val).length() <= maxWidth) continue;
                maxWidth = ((String)val).length();
            }
            for (j = 0; j < a.numValues(); ++j) {
                val = a.value(j) + " ";
                if (((String)val).length() <= maxAttWidth) continue;
                maxAttWidth = ((String)val).length();
            }
        }
        if (this.m_displayStdDevs) {
            for (i3 = 0; i3 < this.m_ClusterCentroids.numAttributes(); ++i3) {
                if (!this.m_ClusterCentroids.attribute(i3).isNominal()) continue;
                int maxV = Utils.maxIndex((int[])this.m_FullNominalCounts[i3]);
                int percent = 6;
                String nomV = "" + this.m_FullNominalCounts[i3][maxV];
                if (nomV.length() + percent <= maxWidth) continue;
                maxWidth = nomV.length() + 1;
            }
        }
        for (int m_ClusterSize : this.m_ClusterSizes) {
            String size = "(" + m_ClusterSize + ")";
            if (size.length() <= maxWidth) continue;
            maxWidth = size.length();
        }
        if (this.m_displayStdDevs && maxAttWidth < "missing".length()) {
            maxAttWidth = "missing".length();
        }
        String plusMinus = "+/-";
        maxAttWidth += 2;
        if (this.m_displayStdDevs && containsNumeric) {
            maxWidth += plusMinus.length();
        }
        if (maxAttWidth < "Attribute".length() + 2) {
            maxAttWidth = "Attribute".length() + 2;
        }
        if (maxWidth < "Full Data".length()) {
            maxWidth = "Full Data".length() + 1;
        }
        if (maxWidth < "missing".length()) {
            maxWidth = "missing".length() + 1;
        }
        StringBuffer temp = new StringBuffer();
        temp.append("\nkMeans\n======\n");
        temp.append("\nNumber of iterations: " + this.m_Iterations);
        if (!this.m_FastDistanceCalc) {
            temp.append("\n");
            if (this.m_DistanceFunction instanceof EuclideanDistance || this.m_DistanceFunction instanceof SAXDistance) {
                temp.append("Within cluster sum of squared errors: " + Utils.sum((double[])this.m_squaredErrors));
            } else {
                temp.append("Sum of within cluster distances: " + Utils.sum((double[])this.m_squaredErrors));
            }
        }
        temp.append("\n\nInitial staring points (");
        switch (this.m_initializationMethod) {
            case 3: {
                temp.append("farthest first");
                break;
            }
            case 1: {
                temp.append("k-means++");
                break;
            }
            case 2: {
                temp.append("canopy");
                break;
            }
            default: {
                temp.append("random");
            }
        }
        temp.append("):\n");
        if (this.m_initializationMethod != 2) {
            temp.append("\n");
            for (i2 = 0; i2 < this.m_initialStartPoints.numInstances(); ++i2) {
                temp.append("Cluster " + i2 + ": " + this.m_initialStartPoints.instance(i2)).append("\n");
            }
        } else {
            temp.append(this.m_canopyClusters.toString(false));
        }
        if (this.m_speedUpDistanceCompWithCanopies) {
            temp.append("\nReduced number of distance calculations by using canopies.");
            if (this.m_initializationMethod != 2) {
                temp.append("\nCanopy T2 radius: " + String.format("%-10.3f", this.m_canopyClusters.getActualT2()));
                temp.append("\nCanopy T1 radius: " + String.format("%-10.3f", this.m_canopyClusters.getActualT1())).append("\n");
            }
        }
        if (!this.m_dontReplaceMissing) {
            temp.append("\nMissing values globally replaced with mean/mode");
        }
        temp.append("\n\nFinal cluster centroids:\n");
        temp.append(this.pad("Cluster#", " ", maxAttWidth + (maxWidth * 2 + 2) - "Cluster#".length(), true));
        temp.append("\n");
        temp.append(this.pad("Attribute", " ", maxAttWidth - "Attribute".length(), false));
        temp.append(this.pad("Full Data", " ", maxWidth + 1 - "Full Data".length(), true));
        for (i2 = 0; i2 < this.m_NumClusters; ++i2) {
            String clustNum = "" + i2;
            temp.append(this.pad(clustNum, " ", maxWidth + 1 - clustNum.length(), true));
        }
        temp.append("\n");
        String cSize = "(" + Utils.sum((int[])this.m_ClusterSizes) + ")";
        temp.append(this.pad(cSize, " ", maxAttWidth + maxWidth + 1 - cSize.length(), true));
        for (i = 0; i < this.m_NumClusters; ++i) {
            cSize = "(" + this.m_ClusterSizes[i] + ")";
            temp.append(this.pad(cSize, " ", maxWidth + 1 - cSize.length(), true));
        }
        temp.append("\n");
        temp.append(this.pad("", "=", maxAttWidth + (maxWidth * (this.m_ClusterCentroids.numInstances() + 1) + this.m_ClusterCentroids.numInstances() + 1), true));
        temp.append("\n");
        for (i = 0; i < this.m_ClusterCentroids.numAttributes(); ++i) {
            String valMeanMode;
            String attName = this.m_ClusterCentroids.attribute(i).name();
            temp.append(attName);
            for (int j = 0; j < maxAttWidth - attName.length(); ++j) {
                temp.append(" ");
            }
            if (this.m_ClusterCentroids.attribute(i).isNominal()) {
                if (this.m_FullMeansOrMediansOrModes[i] == -1.0) {
                    valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
                } else {
                    String strVal = this.m_ClusterCentroids.attribute(i).value((int)this.m_FullMeansOrMediansOrModes[i]);
                    valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                }
            } else if (Double.isNaN(this.m_FullMeansOrMediansOrModes[i])) {
                valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
            } else {
                String strVal = Utils.doubleToString((double)this.m_FullMeansOrMediansOrModes[i], (int)maxWidth, (int)4).trim();
                valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
            }
            temp.append(valMeanMode);
            for (int j = 0; j < this.m_NumClusters; ++j) {
                if (this.m_ClusterCentroids.attribute(i).isNominal()) {
                    if (this.m_ClusterCentroids.instance(j).isMissing(i)) {
                        valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
                    } else {
                        String strVal = this.m_ClusterCentroids.attribute(i).value((int)this.m_ClusterCentroids.instance(j).value(i));
                        valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                    }
                } else if (this.m_ClusterCentroids.instance(j).isMissing(i)) {
                    valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
                } else {
                    String strVal = Utils.doubleToString((double)this.m_ClusterCentroids.instance(j).value(i), (int)maxWidth, (int)4).trim();
                    valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                }
                temp.append(valMeanMode);
            }
            temp.append("\n");
            if (!this.m_displayStdDevs) continue;
            Object stdDevVal = "";
            if (this.m_ClusterCentroids.attribute(i).isNominal()) {
                Attribute a = this.m_ClusterCentroids.attribute(i);
                for (int j = 0; j < a.numValues(); ++j) {
                    String val = "  " + a.value(j);
                    temp.append(this.pad(val, " ", maxAttWidth + 1 - val.length(), false));
                    int count = this.m_FullNominalCounts[i][j];
                    int percent = (int)((double)this.m_FullNominalCounts[i][j] / (double)Utils.sum((int[])this.m_ClusterSizes) * 100.0);
                    Object percentS = percent + "%)";
                    percentS = this.pad((String)percentS, " ", 5 - ((String)percentS).length(), true);
                    stdDevVal = count + " (" + (String)percentS;
                    stdDevVal = this.pad((String)stdDevVal, " ", maxWidth + 1 - ((String)stdDevVal).length(), true);
                    temp.append((String)stdDevVal);
                    for (int k = 0; k < this.m_NumClusters; ++k) {
                        count = this.m_ClusterNominalCounts[k][i][j];
                        percent = (int)((double)this.m_ClusterNominalCounts[k][i][j] / (double)this.m_ClusterSizes[k] * 100.0);
                        percentS = percent + "%)";
                        percentS = this.pad((String)percentS, " ", 5 - ((String)percentS).length(), true);
                        stdDevVal = count + " (" + (String)percentS;
                        stdDevVal = this.pad((String)stdDevVal, " ", maxWidth + 1 - ((String)stdDevVal).length(), true);
                        temp.append((String)stdDevVal);
                    }
                    temp.append("\n");
                }
                if (this.m_FullMissingCounts[i] > 0) {
                    temp.append(this.pad("  missing", " ", maxAttWidth + 1 - "  missing".length(), false));
                    int count = this.m_FullMissingCounts[i];
                    int percent = (int)((double)this.m_FullMissingCounts[i] / (double)Utils.sum((int[])this.m_ClusterSizes) * 100.0);
                    Object percentS = percent + "%)";
                    percentS = this.pad((String)percentS, " ", 5 - ((String)percentS).length(), true);
                    stdDevVal = count + " (" + (String)percentS;
                    stdDevVal = this.pad((String)stdDevVal, " ", maxWidth + 1 - ((String)stdDevVal).length(), true);
                    temp.append((String)stdDevVal);
                    for (int k = 0; k < this.m_NumClusters; ++k) {
                        count = this.m_ClusterMissingCounts[k][i];
                        percent = (int)((double)this.m_ClusterMissingCounts[k][i] / (double)this.m_ClusterSizes[k] * 100.0);
                        percentS = percent + "%)";
                        percentS = this.pad((String)percentS, " ", 5 - ((String)percentS).length(), true);
                        stdDevVal = count + " (" + (String)percentS;
                        stdDevVal = this.pad((String)stdDevVal, " ", maxWidth + 1 - ((String)stdDevVal).length(), true);
                        temp.append((String)stdDevVal);
                    }
                    temp.append("\n");
                }
                temp.append("\n");
                continue;
            }
            if (Double.isNaN(this.m_FullMeansOrMediansOrModes[i])) {
                stdDevVal = this.pad("--", " ", maxAttWidth + maxWidth + 1 - 2, true);
            } else {
                String strVal = plusMinus + Utils.doubleToString((double)this.m_FullStdDevs[i], (int)maxWidth, (int)4).trim();
                stdDevVal = this.pad(strVal, " ", maxWidth + maxAttWidth + 1 - strVal.length(), true);
            }
            temp.append((String)stdDevVal);
            for (int j = 0; j < this.m_NumClusters; ++j) {
                if (this.m_ClusterCentroids.instance(j).isMissing(i)) {
                    stdDevVal = this.pad("--", " ", maxWidth + 1 - 2, true);
                } else {
                    String strVal = plusMinus + Utils.doubleToString((double)this.m_ClusterStdDevs.instance(j).value(i), (int)maxWidth, (int)4).trim();
                    stdDevVal = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                }
                temp.append((String)stdDevVal);
            }
            temp.append("\n\n");
        }
        temp.append("\n\n");
        return temp.toString();
    }

    private String pad(String source, String padChar, int length, boolean leftPad) {
        StringBuffer temp = new StringBuffer();
        if (leftPad) {
            for (int i = 0; i < length; ++i) {
                temp.append(padChar);
            }
            temp.append(source);
        } else {
            temp.append(source);
            for (int i = 0; i < length; ++i) {
                temp.append(padChar);
            }
        }
        return temp.toString();
    }

    public Instances getClusterCentroids() {
        return this.m_ClusterCentroids;
    }

    public Instances getClusterStandardDevs() {
        return this.m_ClusterStdDevs;
    }

    public int[][][] getClusterNominalCounts() {
        return this.m_ClusterNominalCounts;
    }

    public double getSquaredError() {
        if (this.m_FastDistanceCalc) {
            return Double.NaN;
        }
        return Utils.sum((double[])this.m_squaredErrors);
    }

    public int[] getClusterSizes() {
        return this.m_ClusterSizes;
    }

    public int[] getAssignments() throws Exception {
        if (!this.m_PreserveOrder) {
            throw new Exception("The assignments are only available when order of instances is preserved (-O)");
        }
        if (this.m_Assignments == null) {
            throw new Exception("No assignments made.");
        }
        return this.m_Assignments;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10605 $");
    }

    public static void main(String[] args) {
        SAXKMeans.runClusterer((Clusterer)new SimpleKMeans(), (String[])args);
    }

    private class KMeansClusterTask
    extends CallableWithResult<Boolean> {
        protected int m_start;
        protected int m_end;
        protected Instances m_inst;
        protected int[] m_clusterAssignments;

        public KMeansClusterTask(Instances inst, int start, int end, int[] clusterAssignments) {
            this.m_start = start;
            this.m_end = end;
            this.m_inst = inst;
            this.m_clusterAssignments = clusterAssignments;
        }

        protected Boolean doCall() {
            boolean converged = true;
            for (int i = this.m_start; i < this.m_end; ++i) {
                long[] instanceCanopies;
                Instance toCluster = this.m_inst.instance(i);
                int newC = this.clusterInstance(toCluster, instanceCanopies = SAXKMeans.this.m_speedUpDistanceCompWithCanopies ? SAXKMeans.this.m_dataPointCanopyAssignments.get(i) : null);
                if (newC != this.m_clusterAssignments[i]) {
                    converged = false;
                }
                this.m_clusterAssignments[i] = newC;
            }
            return converged;
        }

        protected int clusterInstance(Instance inst, long[] instanceCanopies) {
            double minDist = 2.147483647E9;
            int bestCluster = 0;
            for (int i = 0; i < SAXKMeans.this.m_NumClusters; ++i) {
                double dist;
                if (SAXKMeans.this.m_speedUpDistanceCompWithCanopies && instanceCanopies != null && instanceCanopies.length > 0) {
                    try {
                        if (!Canopy.nonEmptyCanopySetIntersection((long[])SAXKMeans.this.m_centroidCanopyAssignments.get(i), (long[])instanceCanopies)) {
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (!((dist = SAXKMeans.this.m_DistanceFunction.distance(inst, SAXKMeans.this.m_ClusterCentroids.instance(i), minDist)) < minDist)) continue;
                minDist = dist;
                bestCluster = i;
            }
            return bestCluster;
        }
    }

    private class KMeansComputeCentroidTask
    extends CallableWithResult<double[]> {
        protected Instances m_cluster;
        protected int m_centroidIndex;

        public KMeansComputeCentroidTask(int centroidIndex, Instances cluster) {
            this.m_cluster = cluster;
            this.m_centroidIndex = centroidIndex;
        }

        protected double[] doCall() {
            return SAXKMeans.this.moveCentroid(this.m_centroidIndex, this.m_cluster, true, false);
        }
    }
}

