/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import adams.core.management.User;
import adams.core.option.OptionUtils;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;

public class SpreadSheetLoader
extends AbstractFileLoader
implements BatchConverter,
OptionHandler {
    private static final long serialVersionUID = -5037505317395902292L;
    protected Instances m_structure = null;
    protected Instances m_Data = null;
    protected File m_sourceFile = new File(User.getCWD());
    protected boolean m_Debug = false;
    protected SpreadSheetReader m_Reader = new CsvSpreadSheetReader();
    protected Conversion m_Conversion = new SpreadSheetToWekaInstances();

    public SpreadSheetLoader() {
        this.setRetrieval(0);
    }

    public String globalInfo() {
        return "Loads a CSV file using an ADAMS spreadsheet reader and converts it into an Instances object.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tEnables debug output.\n\t(default: off)", "D", 0, "-D"));
        result.add(new Option("\tThe ADAMS spreadsheet reader to use.\t(default: " + CsvSpreadSheetReader.class.getName() + ")", "-reader", 1, "-reader <classname + options>"));
        result.add(new Option("\tThe conversion scheme for converting the spreadsheet into an\n\tInstances object to work on.\n\t(default: " + SpreadSheetToWekaInstances.class.getName() + ")", "-conversion", 1, "-conversion <classname + options>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag((String)"D", (String[])options));
        String tmpStr = Utils.getOption((String)"reader", (String[])options);
        if (tmpStr.length() > 0) {
            this.setReader((SpreadSheetReader)OptionUtils.forAnyCommandLine(SpreadSheetReader.class, (String)tmpStr));
        } else {
            this.setReader((SpreadSheetReader)new CsvSpreadSheetReader());
        }
        tmpStr = Utils.getOption((String)"conversion", (String[])options);
        if (tmpStr.length() > 0) {
            this.setConversion((Conversion)OptionUtils.forAnyCommandLine(Conversion.class, (String)tmpStr));
        } else {
            this.setConversion((Conversion)new SpreadSheetToWekaInstances());
        }
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getDebug()) {
            options.add("-D");
        }
        options.add("-reader");
        options.add(OptionUtils.getCommandLine((Object)this.m_Reader));
        options.add("-conversion");
        options.add(OptionUtils.getCommandLine((Object)this.m_Conversion));
        return options.toArray(new String[options.size()]);
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Whether to print additional debug information to the console.";
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The ADAMS spreadsheet reader to use.";
    }

    public void setConversion(Conversion value) {
        this.m_Conversion = value;
    }

    public Conversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion scheme to convert the spreadsheet into an Instances object.";
    }

    public String getFileDescription() {
        return "ADAMS Spreadsheets";
    }

    public String getFileExtension() {
        return this.getFileExtensions()[0];
    }

    public String[] getFileExtensions() {
        String[] result = this.m_Reader.getFormatExtensions();
        for (int i = 0; i < result.length; ++i) {
            if (result[i].startsWith(".")) continue;
            result[i] = "." + result[i];
        }
        return result;
    }

    public void reset() throws IOException {
        super.reset();
        this.m_structure = null;
        this.m_Data = null;
    }

    public void setSource(File file) throws IOException {
        File original = file;
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        String fName = file.getPath();
        try {
            if (this.m_env == null) {
                this.m_env = Environment.getSystemWide();
            }
            fName = this.m_env.substitute(fName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = new File(fName);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File '" + file + "' not found or not an actual file!");
        }
        this.m_sourceFile = file;
        if (this.m_useRelativePath) {
            try {
                this.m_sourceFile = Utils.convertToRelativePath((File)original);
                this.m_File = this.m_sourceFile.getPath();
            }
            catch (Exception ex) {
                this.m_sourceFile = original;
                this.m_File = this.m_sourceFile.getPath();
            }
        } else {
            this.m_sourceFile = original;
            this.m_File = this.m_sourceFile.getPath();
        }
    }

    public Instances getStructure() throws IOException {
        if (this.m_structure == null) {
            if (this.m_Debug) {
                System.out.println("Loading data from '" + this.m_sourceFile + "'...");
            }
            SpreadSheet sheet = this.m_Reader.read(this.m_sourceFile);
            if (this.m_Debug) {
                System.out.println("Loading complete");
            }
            if (this.m_Debug) {
                System.out.println("Converting SpreadSheet to Instances...");
            }
            this.m_Conversion.setInput((Object)sheet);
            String msg = this.m_Conversion.convert();
            if (msg != null) {
                throw new IOException("Conversion from SpreadSheet to Instances failed: " + msg);
            }
            this.m_Data = (Instances)this.m_Conversion.getOutput();
            this.m_Conversion.cleanUp();
            this.m_structure = new Instances(this.m_Data, 0);
            if (this.m_Debug) {
                System.out.println("Conversion complete");
            }
        }
        return this.m_structure;
    }

    public Instances getDataSet() throws IOException {
        this.getStructure();
        return this.m_Data;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("SpreadSheetLoader can't read data sets incrementally.");
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                SpreadSheetLoader loader = new SpreadSheetLoader();
                loader.setOptions(args);
                Instances data = loader.getDataSet();
                System.out.println(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("\nUsage:\n\tSpreadSheetLoader [options]\n\nOptions:\n");
            Enumeration enm = new SpreadSheetLoader().listOptions();
            while (enm.hasMoreElements()) {
                Option option = (Option)enm.nextElement();
                System.err.println(option.synopsis());
                System.err.println(option.description());
            }
            System.err.println();
        }
    }
}

