/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;

public class ResultMatrixMediaWiki
extends ResultMatrix {
    private static final long serialVersionUID = 6501952611900558450L;
    protected int m_Border = 1;
    protected int m_CellSpacing = 0;
    protected int m_CellPadding = 5;

    public ResultMatrixMediaWiki() {
        this(1, 1);
    }

    public ResultMatrixMediaWiki(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixMediaWiki(ResultMatrix matrix) {
        super(matrix);
    }

    public String globalInfo() {
        return "Generates table output in MediaWiki format.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add((Option)enm.nextElement());
        }
        result.addElement(new Option("\tThe thickness of the table border.\n\t(default: 1)", "border", 1, "-border <int>"));
        result.addElement(new Option("\tThe cell spacing of the table.\n\t(default: 0)", "cell-spacing", 1, "-cell-spacing <int>"));
        result.addElement(new Option("\tThe cell padding of the table.\n\t(default: 5)", "cell-padding", 1, "-cell-padding <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"border", (String[])options);
        if (tmpStr.length() > 0) {
            this.setBorder(Integer.parseInt(tmpStr));
        } else {
            this.setBorder(this.getDefaultBorder());
        }
        tmpStr = Utils.getOption((String)"cell-spacing", (String[])options);
        if (tmpStr.length() > 0) {
            this.setCellSpacing(Integer.parseInt(tmpStr));
        } else {
            this.setCellSpacing(this.getDefaultCellSpacing());
        }
        tmpStr = Utils.getOption((String)"cell-padding", (String[])options);
        if (tmpStr.length() > 0) {
            this.setCellPadding(Integer.parseInt(tmpStr));
        } else {
            this.setCellPadding(this.getDefaultCellPadding());
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-border");
        result.add("" + this.getBorder());
        result.add("-cell-spacing");
        result.add("" + this.getCellSpacing());
        result.add("-cell-padding");
        result.add("" + this.getCellPadding());
        return result.toArray(new String[result.size()]);
    }

    public String getDisplayName() {
        return "MediaWiki";
    }

    public int getDefaultRowNameWidth() {
        return 25;
    }

    public boolean getDefaultPrintColNames() {
        return false;
    }

    public boolean getDefaultEnumerateColNames() {
        return true;
    }

    protected int getDefaultBorder() {
        return 1;
    }

    public void setBorder(int value) {
        if (value >= 0) {
            this.m_Border = value;
        }
    }

    public int getBorder() {
        return this.m_Border;
    }

    public String borderTipText() {
        return "The thickness of the table border.";
    }

    protected int getDefaultCellSpacing() {
        return 0;
    }

    public void setCellSpacing(int value) {
        if (value >= 0) {
            this.m_CellSpacing = value;
        }
    }

    public int getCellSpacing() {
        return this.m_CellSpacing;
    }

    public String cellSpacingTipText() {
        return "The cell spacing of the table.";
    }

    protected int getDefaultCellPadding() {
        return 5;
    }

    public void setCellPadding(int value) {
        if (value >= 0) {
            this.m_CellPadding = value;
        }
    }

    public int getCellPadding() {
        return this.m_CellPadding;
    }

    public String cellPaddingTipText() {
        return "The cell padding of the table.";
    }

    protected String getTableProlog() {
        return "{| border=\"" + this.m_Border + "\" cellspacing=\"" + this.m_CellSpacing + "\" cellpadding=\"" + this.m_CellPadding + "\"\n";
    }

    protected String getTableEpilog() {
        return "|-\n|}\n";
    }

    public String toStringHeader() {
        StringBuilder result = new StringBuilder();
        result.append(this.getTableProlog());
        for (int i = 0; i < this.m_HeaderKeys.size(); ++i) {
            result.append("|-\n");
            result.append("| " + ((String)this.m_HeaderKeys.get(i)).toString() + "\n");
            result.append("| " + ((String)this.m_HeaderValues.get(i)).toString() + "\n");
        }
        result.append(this.getTableEpilog());
        return result.toString();
    }

    public String toStringMatrix() {
        StringBuilder result = new StringBuilder();
        String[][] cells = this.toArray();
        result.append(this.getTableProlog());
        for (int i = 0; i < cells.length; ++i) {
            result.append("|-\n");
            for (int n = 0; n < cells[i].length; ++n) {
                if (i == 0) {
                    if (n > 0) {
                        result.append("! align=\"center\" | ");
                    } else {
                        result.append("! ");
                    }
                    result.append(cells[i][n] + "\n");
                    continue;
                }
                if (n > 0) {
                    result.append("| align=\"right\" ");
                }
                result.append("| " + cells[i][n] + "\n");
            }
        }
        result.append(this.getTableEpilog());
        return result.toString();
    }

    public String toStringKey() {
        StringBuilder result = new StringBuilder();
        result.append(this.getTableProlog());
        result.append("|-\n");
        result.append("! Key\n");
        result.append("! \n");
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            result.append("|-\n");
            result.append("| " + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + "\n");
            result.append("| " + this.removeFilterName(this.m_ColNames[i]) + "\n");
        }
        result.append(this.getTableEpilog());
        return result.toString();
    }

    public String toStringSummary() {
        int i;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        StringBuilder result = new StringBuilder(this.getTableProlog());
        StringBuilder titles = new StringBuilder();
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            titles.append("! " + this.getSummaryTitle(i) + "\n");
        }
        titles.append("! (No. of datasets where [col] >> [row])\n");
        result.append("|-\n");
        result.append(titles.toString());
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            Object line = "";
            for (int j = 0; j < this.getColCount(); ++j) {
                if (this.getColHidden(j)) continue;
                line = j == i ? (String)line + "| -\n" : (String)line + "| " + this.m_NonSigWins[i][j] + " (" + this.m_Wins[i][j] + ")\n";
            }
            result.append("|-\n");
            result.append((String)line);
            result.append("| '''" + this.getSummaryTitle(i) + "''' = " + this.removeFilterName(this.m_ColNames[i]) + "\n");
        }
        result.append(this.getTableEpilog());
        return result.toString();
    }

    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        StringBuilder result = new StringBuilder(this.getTableProlog());
        result.append("|-\n");
        result.append("! >-<\n");
        result.append("! >\n");
        result.append("! <\n");
        result.append("! Resultset\n");
        int[] ranking = Utils.sort((int[])this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int curr = ranking[i];
            if (this.getColHidden(curr)) continue;
            result.append("|-\n");
            result.append("| align=\"right\" | " + this.m_RankingDiff[curr] + "\n");
            result.append("| align=\"right\" | " + this.m_RankingWins[curr] + "\n");
            result.append("| align=\"right\" | " + this.m_RankingLosses[curr] + "\n");
            result.append("| " + this.removeFilterName(this.m_ColNames[curr]) + "\n");
        }
        result.append(this.getTableEpilog());
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        ResultMatrixMediaWiki matrix = new ResultMatrixMediaWiki(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i != n) continue;
                if (i % 2 == 1) {
                    matrix.setSignificance(n, i, 1);
                    continue;
                }
                matrix.setSignificance(n, i, 2);
            }
        }
        System.out.println("\n\n--> " + matrix.getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(matrix.toStringHeader() + "\n");
        System.out.println(matrix.toStringMatrix() + "\n");
        System.out.println(matrix.toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(matrix.toStringMatrix());
    }
}

