/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.weka.columnfinder.AbstractColumnFinder;
import adams.data.weka.columnfinder.ColumnFinder;
import adams.data.weka.columnfinder.NullFinder;
import adams.data.weka.columnfinder.TrainableColumnFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.Option;
import weka.filters.SimpleBatchFilter;

public abstract class AbstractColumnFinderApplier
extends SimpleBatchFilter {
    private static final long serialVersionUID = 2750612199034543886L;
    protected ColumnFinder m_ColumnFinder = new NullFinder();
    protected boolean m_Invert = false;

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tFull class name of column finder to use, followed\n\tby scheme options. eg:\n\t\t\"" + NullFinder.class.getName() + " -D 1\"\n\t(default: " + NullFinder.class.getName() + ")", "W", 1, "-W <column finder specification>"));
        result.addElement(new Option("\tWhether to invert the found column indices.\n\t(default: off)", "invert", 0, "-invert"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setInvert(weka.core.Utils.getFlag((String)"invert", (String[])options));
        String tmpStr = weka.core.Utils.getOption((char)'W', (String[])options);
        if (tmpStr.length() == 0) {
            tmpStr = NullFinder.class.getName();
        }
        this.setColumnFinder(AbstractColumnFinder.forCommandLine(tmpStr));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        if (this.getInvert()) {
            result.add("-invert");
        }
        result.add("-W");
        result.add(OptionUtils.getCommandLine((Object)this.getColumnFinder()));
        return result.toArray(new String[result.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_ColumnFinder instanceof CapabilitiesHandler) {
            result = ((CapabilitiesHandler)this.m_ColumnFinder).getCapabilities();
        } else {
            result = new Capabilities((CapabilitiesHandler)this);
            result.enableAll();
            result.enable(Capabilities.Capability.NO_CLASS);
            result.enable(Capabilities.Capability.MISSING_VALUES);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
            result.setMinimumNumberInstances(1);
        }
        return result;
    }

    public void setColumnFinder(ColumnFinder value) {
        this.m_ColumnFinder = value;
    }

    public ColumnFinder getColumnFinder() {
        return this.m_ColumnFinder;
    }

    public abstract String columnFinderTipText();

    public void setInvert(boolean value) {
        this.m_Invert = value;
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled the column indices get inverted, ie the indices of the columns get returned that weren't identified by the column finder.";
    }

    protected abstract Instances determineOutputFormat(Instances var1) throws Exception;

    protected abstract Instances apply(Instances var1, int[] var2);

    protected Instances process(Instances instances) throws Exception {
        if (this.m_ColumnFinder instanceof TrainableColumnFinder && !((TrainableColumnFinder)this.m_ColumnFinder).isColumnFinderTrained()) {
            ((TrainableColumnFinder)this.m_ColumnFinder).trainColumnFinder(instances);
        }
        int[] indices = this.m_ColumnFinder.findColumns(instances);
        if (this.m_Invert) {
            HashSet set = new HashSet(Utils.toList((int[])indices));
            ArrayList<Integer> inverted = new ArrayList<Integer>();
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (set.contains(i)) continue;
                inverted.add(i);
            }
            indices = Utils.toIntArray(inverted);
        }
        return this.apply(instances, indices);
    }
}

