/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.Range;
import adams.core.base.BaseObject;
import adams.core.base.BaseRegExp;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;

public class EquiDistance
extends SimpleBatchFilter {
    private static final long serialVersionUID = 1579715266499862368L;
    public static final String NUM_POINTS = "num-points";
    public static final String ATTRIBUTE_SELECTION = "att-sel";
    public static final String RANGE = "range";
    public static final String REGEXP = "regexp";
    public static final String PREFIX = "prefix";
    protected int m_NumPoints = this.getDefaultNumPoints();
    protected AttributeSelection m_AttributeSelection = this.getDefaultAttributeSelection();
    protected Range m_Range = this.getDefaultRange();
    protected BaseRegExp m_RegExp = this.getDefaultRegExp();
    protected String m_Prefix = this.getDefaultPrefix();
    protected TIntList m_Attributes;
    protected double m_AverageSpacing;

    public String globalInfo() {
        return "A filter for interpolating the numeric attributes.Using the same number of points as are currently present in the input will have no effect.";
    }

    protected void reset() {
        super.reset();
        this.m_Attributes = null;
    }

    protected int getDefaultNumPoints() {
        return -1;
    }

    public void setNumPoints(int value) {
        if (value > 0 || value == -1) {
            this.m_NumPoints = value;
            this.reset();
        } else {
            System.err.println(((Object)((Object)this)).getClass().getName() + ": only '-1' (uses the number of points currently in the data) or positive numbers are allowed!");
        }
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points to generate, '-1' will use the same amount of points as currently in the input data.";
    }

    protected AttributeSelection getDefaultAttributeSelection() {
        return AttributeSelection.RANGE;
    }

    public void setAttributeSelection(AttributeSelection value) {
        this.m_AttributeSelection = value;
        this.reset();
    }

    public AttributeSelection getAttributeSelection() {
        return this.m_AttributeSelection;
    }

    public String attributeSelectionTipText() {
        return "Determines how the attributes are selected.";
    }

    protected Range getDefaultRange() {
        return new Range("first-last");
    }

    public void setRange(Range value) {
        this.m_Range = value;
        this.reset();
    }

    public Range getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The range of attributes to use, if " + AttributeSelection.RANGE + " selected.";
    }

    protected BaseRegExp getDefaultRegExp() {
        return new BaseRegExp(".*");
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression for identifying the attributes via their name, if " + AttributeSelection.REGEXP + " selected.";
    }

    protected String getDefaultPrefix() {
        return "att-";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the new attributes; 1-based index gets appended.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.numPointsTipText(), "" + this.getDefaultNumPoints(), NUM_POINTS);
        WekaOptionUtils.addOption(result, this.attributeSelectionTipText(), "" + this.getDefaultAttributeSelection(), ATTRIBUTE_SELECTION);
        WekaOptionUtils.addOption(result, this.rangeTipText(), "" + this.getDefaultRange(), RANGE);
        WekaOptionUtils.addOption(result, this.regExpTipText(), "" + this.getDefaultRegExp(), REGEXP);
        WekaOptionUtils.addOption(result, this.prefixTipText(), this.getDefaultPrefix(), PREFIX);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setNumPoints(WekaOptionUtils.parse(options, NUM_POINTS, this.getDefaultNumPoints()));
        this.setAttributeSelection((AttributeSelection)WekaOptionUtils.parse(options, ATTRIBUTE_SELECTION, (Enum)this.getDefaultAttributeSelection()));
        this.setRange(WekaOptionUtils.parse(options, RANGE, this.getDefaultRange()));
        this.setRegExp((BaseRegExp)WekaOptionUtils.parse(options, REGEXP, (BaseObject)this.getDefaultRegExp()));
        this.setPrefix(WekaOptionUtils.parse(options, PREFIX, this.getDefaultPrefix()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, NUM_POINTS, this.getNumPoints());
        WekaOptionUtils.add(result, ATTRIBUTE_SELECTION, (Enum)this.getAttributeSelection());
        WekaOptionUtils.add(result, RANGE, this.getRange());
        WekaOptionUtils.add(result, REGEXP, (BaseObject)this.getRegExp());
        WekaOptionUtils.add(result, PREFIX, this.getPrefix());
        return WekaOptionUtils.toArray(result);
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected double interpolate(double index, int indexLeft, double valueLeft, int indexRight, double valueRight) {
        double indexdiff = indexRight - indexLeft;
        double percLeft = 1.0 - (index - (double)indexLeft) / indexdiff;
        double percRight = 1.0 - ((double)indexRight - index) / indexdiff;
        double result = valueLeft * percLeft + valueRight * percRight;
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        if (this.m_NumPoints == -1) {
            return new Instances(inputFormat, 0);
        }
        this.m_Attributes = new TIntArrayList();
        switch (this.m_AttributeSelection) {
            case RANGE: {
                this.m_Range.setMax(inputFormat.numAttributes());
                this.m_Attributes.add(this.m_Range.getIntIndices());
                if (this.m_Attributes.size() != 0) break;
                throw new IllegalStateException("No matching attributes found (range: " + this.m_Range.getRange() + ")!");
            }
            case REGEXP: {
                for (i = 0; i < inputFormat.numAttributes(); ++i) {
                    if (!this.m_RegExp.isMatch(inputFormat.attribute(i).name())) continue;
                    this.m_Attributes.add(i);
                }
                if (this.m_Attributes.size() != 0) break;
                throw new IllegalStateException("No matching attributes found (regexp: " + this.m_RegExp.getValue() + ")!");
            }
            default: {
                throw new IllegalStateException("Unhandled attribute selection: " + this.m_AttributeSelection);
            }
        }
        if (this.getDebug()) {
            System.out.println("# Attributes: " + this.m_Attributes.size());
        }
        if (this.m_Attributes.size() == this.m_NumPoints) {
            return new Instances(inputFormat, 0);
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < this.m_NumPoints; ++i) {
            atts.add(new Attribute(this.m_Prefix + (i + 1)));
        }
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (this.m_Attributes.contains(i)) continue;
            switch (inputFormat.attribute(i).type()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    atts.add((Attribute)inputFormat.attribute(i).copy());
                }
            }
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        this.m_AverageSpacing = this.m_NumPoints < this.m_Attributes.size() ? (double)this.m_Attributes.size() / (double)(this.m_NumPoints - 1) : (double)(this.m_Attributes.size() - 1) / (double)(this.m_NumPoints - 1);
        if (this.getDebug()) {
            System.out.println("Average spacing: " + this.m_AverageSpacing);
        }
        return result;
    }

    protected Instance process(Instances header, Instance instance) throws Exception {
        int i;
        if (this.m_NumPoints == -1) {
            return instance;
        }
        if (this.m_Attributes.size() == this.m_NumPoints) {
            return instance;
        }
        TDoubleArrayList valuesOld = new TDoubleArrayList();
        for (i = 0; i < this.m_Attributes.size(); ++i) {
            valuesOld.add(instance.value(this.m_Attributes.get(i)));
        }
        TDoubleArrayList values = new TDoubleArrayList();
        values.add(valuesOld.get(0));
        for (i = 1; i < this.m_NumPoints - 1; ++i) {
            double newValue;
            double index = (double)i * this.m_AverageSpacing;
            if (Math.floor(index) != Math.ceil(index)) {
                newValue = this.interpolate(index, (int)Math.floor(index), valuesOld.get((int)Math.floor(index)), (int)Math.ceil(index), valuesOld.get((int)Math.ceil(index)));
                values.add(newValue);
                continue;
            }
            newValue = index < (double)this.m_Attributes.get(this.m_Attributes.size() - 1) ? this.interpolate(index, (int)index - 1, valuesOld.get((int)index - 1), (int)index + 1, valuesOld.get((int)index + 1)) : this.interpolate(index, (int)index - 1, valuesOld.get((int)index - 1), (int)index, valuesOld.get((int)index));
            newValue = (newValue + instance.value(this.m_Attributes.get((int)index))) / 2.0;
            values.add(newValue);
        }
        values.add(valuesOld.get(valuesOld.size() - 1));
        block6: for (i = 0; i < instance.numAttributes(); ++i) {
            if (this.m_Attributes.contains(i)) continue;
            switch (instance.attribute(i).type()) {
                case 0: 
                case 1: 
                case 3: {
                    values.add(instance.value(i));
                    continue block6;
                }
                case 2: {
                    values.add((double)header.attribute(values.size()).addStringValue(instance.stringValue(i)));
                }
            }
        }
        DenseInstance result = new DenseInstance(instance.weight(), values.toArray());
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = this.getOutputFormat();
        for (Instance inst : instances) {
            result.add(this.process(result, inst));
        }
        return result;
    }

    public static void main(String[] args) {
        EquiDistance.runFilter((Filter)new EquiDistance(), (String[])args);
    }

    public static enum AttributeSelection {
        RANGE,
        REGEXP;

    }
}

