/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import JSci.maths.wavelet.cdf2_4.FastCDF2_4;
import JSci.maths.wavelet.daubechies2.FastDaubechies2;
import JSci.maths.wavelet.haar.FastHaar;
import JSci.maths.wavelet.symmlet8.FastSymmlet8;
import adams.core.option.OptionUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class FastWavelet
extends SimpleBatchFilter
implements TechnicalInformationHandler,
UnsupervisedFilter {
    private static final long serialVersionUID = -8596728919861340618L;
    public static final int ALGORITHM_HAAR = 0;
    public static final int ALGORITHM_CDF2_4 = 1;
    public static final int ALGORITHM_DAUBECHIES2 = 2;
    public static final int ALGORITHM_SYMMLET8 = 3;
    public static final Tag[] TAGS_ALGORITHM = new Tag[]{new Tag(0, "HAAR", "Haar"), new Tag(1, "CDF2_4", "CDF2 4"), new Tag(2, "DAUBECHIES2", "Daubechies2"), new Tag(3, "SYMMLET8", "Symmlet8")};
    public static final int PADDING_ZERO = 0;
    public static final Tag[] TAGS_PADDING = new Tag[]{new Tag(0, "ZERO", "Zero")};
    protected Filter m_Filter = new MultiFilter();
    protected int m_Algorithm = 0;
    protected int m_Padding = 0;
    protected boolean m_InverseTransform = false;

    public FastWavelet() {
        ((MultiFilter)this.m_Filter).setFilters(new Filter[]{new ReplaceMissingValues(), new Normalize()});
    }

    public String globalInfo() {
        return "A filter for wavelet transformation using the JSci library's fast wavelet transform (FWT) algorithms.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.TITLE, "JSci - A science API for Java");
        result.setValue(TechnicalInformation.Field.HTTP, "http://jsci.sourceforge.net/");
        return result;
    }

    public Enumeration listOptions() {
        SelectedTag tag;
        int i;
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        Object param = "";
        for (i = 0; i < TAGS_ALGORITHM.length; ++i) {
            if (i > 0) {
                param = (String)param + "|";
            }
            tag = new SelectedTag(TAGS_ALGORITHM[i].getID(), TAGS_ALGORITHM);
            param = (String)param + tag.getSelectedTag().getIDStr();
        }
        result.addElement(new Option("\tThe algorithm to use.\n\t(default: " + new SelectedTag(0, TAGS_ALGORITHM) + ")", "A", 1, "-A <" + (String)param + ">"));
        param = "";
        for (i = 0; i < TAGS_PADDING.length; ++i) {
            if (i > 0) {
                param = (String)param + "|";
            }
            tag = new SelectedTag(TAGS_PADDING[i].getID(), TAGS_PADDING);
            param = (String)param + tag.getSelectedTag().getIDStr();
        }
        result.addElement(new Option("\tThe padding to use.\n\t(default: " + new SelectedTag(0, TAGS_PADDING) + ")", "P", 1, "-P <" + (String)param + ">"));
        result.addElement(new Option("\tThe filter to use as preprocessing step (classname and options).\n\t(default: MultiFilter with ReplaceMissingValues and Normalize)", "F", 1, "-F <filter specification>"));
        result.addElement(new Option("\tWhether to perform the inverse transform (from wavelet space into\n\tnormal space again).\n\t(default: off)", "inverse", 0, "-inverse"));
        if (this.getFilter() instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-F'):"));
            enm = this.getFilter().listOptions();
            while (enm.hasMoreElements()) {
                result.addElement(enm.nextElement());
            }
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<Object> result = new Vector<Object>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-A");
        result.add(this.getAlgorithm().getSelectedTag().getReadable());
        result.add("-P");
        result.add(this.getPadding().getSelectedTag().getReadable());
        result.add("-F");
        if (this.getFilter() instanceof OptionHandler) {
            result.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions((String[])this.getFilter().getOptions()));
        } else {
            result.add(this.getFilter().getClass().getName());
        }
        if (this.getInverseTransform()) {
            result.add("-inverse");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"A", (String[])options);
        if (tmpStr.length() != 0) {
            this.setAlgorithm(new SelectedTag(tmpStr, TAGS_ALGORITHM));
        } else {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        }
        tmpStr = Utils.getOption((String)"P", (String[])options);
        if (tmpStr.length() != 0) {
            this.setPadding(new SelectedTag(tmpStr, TAGS_PADDING));
        } else {
            this.setPadding(new SelectedTag(0, TAGS_PADDING));
        }
        tmpStr = Utils.getOption((String)"F", (String[])options);
        String[] tmpOptions = Utils.splitOptions((String)tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setFilter((Filter)OptionUtils.forName(Filter.class, (String)tmpStr, (String[])tmpOptions));
        } else {
            MultiFilter filter = new MultiFilter();
            filter.setFilters(new Filter[]{new ReplaceMissingValues(), new Normalize()});
            this.setFilter((Filter)filter);
        }
        this.setInverseTransform(Utils.getFlag((String)"inverse", (String[])options));
        super.setOptions(options);
    }

    public String filterTipText() {
        return "The preprocessing filter to use.";
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String algorithmTipText() {
        return "Sets the type of algorithm to use.";
    }

    public void setAlgorithm(SelectedTag value) {
        if (value.getTags() == TAGS_ALGORITHM) {
            this.m_Algorithm = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getAlgorithm() {
        return new SelectedTag(this.m_Algorithm, TAGS_ALGORITHM);
    }

    public String paddingTipText() {
        return "Sets the type of padding to use.";
    }

    public void setPadding(SelectedTag value) {
        if (value.getTags() == TAGS_PADDING) {
            this.m_Padding = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getPadding() {
        return new SelectedTag(this.m_Padding, TAGS_PADDING);
    }

    public String inverseTransformTipText() {
        return "If true, performs inverse transform (wavelet -> normal space).";
    }

    public void setInverseTransform(boolean value) {
        this.m_InverseTransform = value;
    }

    public boolean getInverseTransform() {
        return this.m_InverseTransform;
    }

    protected static int nextPowerOf2(int n) {
        int exp = (int)StrictMath.ceil(StrictMath.log(n) / StrictMath.log(2.0));
        exp = StrictMath.max(2, exp);
        return (int)StrictMath.pow(2.0, exp);
    }

    protected Instances pad(Instances data) {
        int n;
        int i;
        int numAtts;
        switch (this.m_Padding) {
            case 0: {
                if (data.classIndex() > -1) {
                    numAtts = FastWavelet.nextPowerOf2(data.numAttributes() - 1) + 1 - data.numAttributes();
                    break;
                }
                numAtts = FastWavelet.nextPowerOf2(data.numAttributes()) - data.numAttributes();
                break;
            }
            default: {
                throw new IllegalStateException("Padding " + new SelectedTag(this.m_Algorithm, TAGS_PADDING) + " not implemented!");
            }
        }
        Instances result = new Instances(data);
        String prefix = this.getAlgorithm().getSelectedTag().getReadable();
        if (numAtts > 0) {
            boolean isLast = data.classIndex() == data.numAttributes() - 1;
            Vector<Integer> padded = new Vector<Integer>();
            for (i = 0; i < numAtts; ++i) {
                int index = isLast ? result.numAttributes() - 1 : result.numAttributes();
                result.insertAttributeAt(new Attribute(prefix + "_padding_" + (i + 1)), index);
                padded.add(new Integer(index));
            }
            int[] indices = new int[padded.size()];
            for (i = 0; i < padded.size(); ++i) {
                indices[i] = (Integer)padded.get(i);
            }
            switch (this.m_Padding) {
                case 0: {
                    for (i = 0; i < result.numInstances(); ++i) {
                        for (n = 0; n < indices.length; ++n) {
                            result.instance(i).setValue(indices[n], 0.0);
                        }
                    }
                    break;
                }
            }
        }
        data = result;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        n = 0;
        for (i = 0; i < data.numAttributes(); ++i) {
            ++n;
            if (i == data.classIndex()) {
                atts.add((Attribute)data.attribute(i).copy());
                continue;
            }
            atts.add(new Attribute(prefix + "_" + n));
        }
        result = new Instances(data.relationName(), atts, data.numInstances());
        result.setClassIndex(data.classIndex());
        for (i = 0; i < data.numInstances(); ++i) {
            result.add((Instance)new DenseInstance(1.0, data.instance(i).toDoubleArray()));
        }
        return result;
    }

    protected Instances inverse(Instances data) {
        int i;
        data = new Instances(data);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        String prefix = this.getAlgorithm().getSelectedTag().getReadable() + "-inv";
        int n = 0;
        for (i = 0; i < data.numAttributes(); ++i) {
            ++n;
            if (i == data.classIndex()) {
                atts.add((Attribute)data.attribute(i).copy());
                continue;
            }
            atts.add(new Attribute(prefix + "_" + n));
        }
        Instances result = new Instances(data.relationName(), atts, data.numInstances());
        for (i = 0; i < data.numInstances(); ++i) {
            result.add(data.instance(i));
        }
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        if (this.m_InverseTransform) {
            return this.inverse(new Instances(inputFormat, 0));
        }
        return this.pad(new Instances(inputFormat, 0));
    }

    protected Instances processData(Instances instances) throws Exception {
        int i;
        FastHaar fwt;
        int clsIdx = instances.classIndex();
        double[] clsVal = null;
        Attribute clsAtt = null;
        if (clsIdx > -1) {
            clsVal = instances.attributeToDoubleArray(clsIdx);
            clsAtt = (Attribute)instances.classAttribute().copy();
            instances.setClassIndex(-1);
            instances.deleteAttributeAt(clsIdx);
        }
        instances = this.m_InverseTransform ? this.inverse(instances) : this.pad(instances);
        Instances result = new Instances(instances, 0);
        switch (this.m_Algorithm) {
            case 0: {
                fwt = new FastHaar();
                break;
            }
            case 1: {
                fwt = new FastCDF2_4();
                break;
            }
            case 2: {
                fwt = new FastDaubechies2();
                break;
            }
            case 3: {
                fwt = new FastSymmlet8();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled algorithm type: " + this.m_Algorithm);
            }
        }
        for (i = 0; i < instances.numInstances(); ++i) {
            int n;
            double[] newVal = instances.instance(i).toDoubleArray();
            float[] vals = new float[newVal.length];
            for (n = 0; n < newVal.length; ++n) {
                vals[n] = (float)newVal[n];
            }
            if (this.m_InverseTransform) {
                fwt.invTransform(vals);
            } else {
                fwt.transform(vals);
            }
            for (n = 0; n < newVal.length; ++n) {
                newVal[n] = vals[n];
            }
            result.add((Instance)new DenseInstance(1.0, newVal));
        }
        if (clsIdx > -1) {
            result.insertAttributeAt(clsAtt, result.numAttributes());
            result.setClassIndex(result.numAttributes() - 1);
            for (i = 0; i < clsVal.length; ++i) {
                if (Utils.isMissingValue((double)clsVal[i])) {
                    result.instance(i).setClassMissing();
                    continue;
                }
                if (result.classAttribute().isString()) {
                    result.instance(i).setClassValue((double)result.classAttribute().addStringValue(clsAtt.value((int)clsVal[i])));
                    continue;
                }
                if (result.classAttribute().isRelationValued()) {
                    result.instance(i).setClassValue((double)result.classAttribute().addRelation(clsAtt.relation((int)clsVal[i])));
                    continue;
                }
                result.instance(i).setClassValue(clsVal[i]);
            }
        }
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.m_Filter.setInputFormat(instances);
        }
        instances = Filter.useFilter((Instances)instances, (Filter)this.m_Filter);
        return this.processData(instances);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        FastWavelet.runFilter((Filter)new FastWavelet(), (String[])args);
    }
}

