/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class JoinAttributes
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -4180301757935955561L;
    protected Range m_AttributeRange = new Range("first-last");
    protected String m_Glue = "";
    protected int[] m_Indices = new int[0];
    protected HashSet<Integer> m_Hashed = new HashSet();

    public String globalInfo() {
        return "A simple filter that joins several attributes into a single STRING one, with a user defined string acting as 'glue'.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tThe range of the attributes to combine.\n\t(default: first-last).", "R", 1, "-R <range>"));
        result.addElement(new Option("\tThe 'glue' string to insert between the attribute values.\n\t(default: none).", "glue", 1, "-glue <string>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (tmpStr.length() > 0) {
            this.setAttributeRange(tmpStr);
        } else {
            this.setAttributeRange("first-last");
        }
        tmpStr = Utils.getOption((String)"glue", (String[])options);
        if (tmpStr.length() > 0) {
            this.setGlue(tmpStr);
        } else {
            this.setGlue("");
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-R");
        result.add(this.getAttributeRange());
        result.add("-glue");
        result.add(this.getGlue());
        return result.toArray(new String[result.size()]);
    }

    public void setAttributeRange(String value) {
        this.m_AttributeRange.setRanges(value);
        this.reset();
    }

    public String getAttributeRange() {
        return this.m_AttributeRange.getRanges();
    }

    public String attributeRangeTipText() {
        return "The range of attributes to combine (1-based); 'first' and 'last' are accepted as well.";
    }

    public void setGlue(String value) {
        this.m_Glue = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getGlue() {
        return Utils.backQuoteChars((String)this.m_Glue);
    }

    public String glueTipText() {
        return "The glue to insert between the attribute values; tabs can be written as escaped sequence ('\t').";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        this.m_AttributeRange.setUpper(inputFormat.numAttributes() - 1);
        this.m_Indices = this.m_AttributeRange.getSelection();
        if (this.m_Indices.length == 0) {
            throw new IllegalStateException("No attributes selected!");
        }
        this.m_Hashed = new HashSet();
        Object newName = "";
        for (i = 0; i < this.m_Indices.length; ++i) {
            this.m_Hashed.add(this.m_Indices[i]);
            newName = i == 0 ? inputFormat.attribute(this.m_Indices[i]).name() : (String)newName + this.m_Glue + inputFormat.attribute(this.m_Indices[i]).name();
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == this.m_Indices[0]) {
                atts.add(new Attribute((String)newName, (List)((FastVector)null)));
            }
            if (this.m_Hashed.contains(i)) continue;
            atts.add((Attribute)inputFormat.attribute(i).copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (inputFormat.classIndex() != -1 && result.attribute(inputFormat.classAttribute().name()) != null) {
            result.setClassIndex(result.attribute(inputFormat.classAttribute().name()).index());
        }
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = this.getOutputFormat();
        for (Instance instance : instances) {
            int i;
            double[] valuesOld = instance.toDoubleArray();
            double[] valuesNew = new double[this.outputFormatPeek().numAttributes()];
            Object valueNew = "";
            for (i = 0; i < this.m_Indices.length; ++i) {
                Object part = instance.attribute(this.m_Indices[i]).isNumeric() ? "" + instance.value(this.m_Indices[i]) : instance.stringValue(this.m_Indices[i]);
                valueNew = i == 0 ? part : (String)valueNew + this.m_Glue + (String)part;
            }
            int n = 0;
            for (i = 0; i < valuesOld.length; ++i) {
                if (i == this.m_Indices[0]) {
                    valuesNew[n] = result.attribute(n).addStringValue((String)valueNew);
                    ++n;
                } else {
                    valuesNew[n] = instance.attribute(i).isString() ? (double)result.attribute(n).addStringValue(instance.stringValue(i)) : valuesOld[i];
                }
                if (this.m_Hashed.contains(i)) continue;
                ++n;
            }
            Object inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), valuesNew) : new DenseInstance(instance.weight(), valuesNew);
            result.add((Instance)inst);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        JoinAttributes.runFilter((Filter)new JoinAttributes(), (String[])args);
    }
}

