/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.multiplicativescattercorrection;

import adams.core.base.BaseInterval;
import adams.data.statistics.StatUtils;
import gnu.trove.list.array.TDoubleArrayList;
import weka.filters.unsupervised.attribute.multiplicativescattercorrection.AbstractMultiplicativeScatterCorrection;

public class RangeBased
extends AbstractMultiplicativeScatterCorrection {
    private static final long serialVersionUID = -6754404982002787538L;
    protected BaseInterval[] m_Ranges;

    public String globalInfo() {
        return "Performs the correction using slopes/intercepts calculated for the defined ranges.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "ranges", (Object)new BaseInterval[]{new BaseInterval("(-Infinity;+Infinity)")});
    }

    public void setRanges(BaseInterval[] value) {
        this.m_Ranges = value;
        this.reset();
    }

    public BaseInterval[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The ranges of wave numbers to use for calculating the intercept/slope corrections.";
    }

    @Override
    public double[] correct(double[] waveno, double[] average, double[] data) {
        double[] result = (double[])data.clone();
        TDoubleArrayList x = new TDoubleArrayList();
        TDoubleArrayList y = new TDoubleArrayList();
        for (int n = 0; n < this.m_Ranges.length; ++n) {
            int i;
            x.clear();
            y.clear();
            for (i = 0; i < average.length; ++i) {
                if (!this.m_Ranges[n].isInside(waveno[i])) continue;
                y.add(data[i]);
                x.add(average[i]);
            }
            double[] lr = StatUtils.linearRegression((double[])x.toArray(), (double[])y.toArray());
            double inter = lr[0];
            double slope = lr[1];
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.m_Ranges[n] + ": intercept=" + inter + ", slope=" + slope);
            }
            for (i = 0; i < result.length; ++i) {
                if (!this.m_Ranges[n].isInside(waveno[i])) continue;
                result[i] = (result[i] - inter) / slope;
            }
        }
        return result;
    }
}

