/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.weka.rowfinder.AbstractRowFinder;
import adams.data.weka.rowfinder.NullFinder;
import adams.data.weka.rowfinder.RowFinder;
import adams.data.weka.rowfinder.TrainableRowFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.Option;
import weka.filters.SimpleBatchFilter;

public abstract class AbstractRowFinderApplier
extends SimpleBatchFilter {
    private static final long serialVersionUID = 2750612199034543886L;
    protected RowFinder m_RowFinder = new NullFinder();
    protected boolean m_Invert = false;
    protected boolean m_OnlyFirstBatch = false;

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tFull class name of row finder to use, followed\n\tby scheme options. eg:\n\t\t\"" + NullFinder.class.getName() + " -D 1\"\n\t(default: " + NullFinder.class.getName() + ")", "W", 1, "-W <row finder specification>"));
        result.addElement(new Option("\tWhether to invert the found row indices.\n\t(default: off)", "invert", 0, "-invert"));
        result.addElement(new Option("\tWhether to only apply filtering to first batch.\n\t(default: off)", "only-first-batch", 0, "-only-first-batch"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setInvert(weka.core.Utils.getFlag((String)"invert", (String[])options));
        this.setOnlyFirstBatch(weka.core.Utils.getFlag((String)"only-first-batch", (String[])options));
        String tmpStr = weka.core.Utils.getOption((char)'W', (String[])options);
        if (tmpStr.length() == 0) {
            tmpStr = NullFinder.class.getName();
        }
        this.setRowFinder(AbstractRowFinder.forCommandLine(tmpStr));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        if (this.getInvert()) {
            result.add("-invert");
        }
        if (this.getOnlyFirstBatch()) {
            result.add("-only-first-batch");
        }
        result.add("-W");
        result.add(OptionUtils.getCommandLine((Object)this.getRowFinder()));
        return result.toArray(new String[result.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_RowFinder instanceof CapabilitiesHandler) {
            result = ((CapabilitiesHandler)this.m_RowFinder).getCapabilities();
        } else {
            result = new Capabilities((CapabilitiesHandler)this);
            result.enableAll();
            result.enable(Capabilities.Capability.NO_CLASS);
            result.enable(Capabilities.Capability.MISSING_VALUES);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
            result.setMinimumNumberInstances(1);
        }
        return result;
    }

    protected abstract boolean mayRemoveInstances();

    public boolean mayRemoveInstanceAfterFirstBatchDone() {
        return this.mayRemoveInstances();
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public abstract String rowFinderTipText();

    public void setInvert(boolean value) {
        this.m_Invert = value;
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled the row indices get inverted, ie the indices of the rows get returned that weren't identified by the row finder.";
    }

    public void setOnlyFirstBatch(boolean value) {
        this.m_OnlyFirstBatch = value;
    }

    public boolean getOnlyFirstBatch() {
        return this.m_OnlyFirstBatch;
    }

    public String onlyFirstBatchTipText() {
        return "If enabled the row finder will only get applied during the first batch.";
    }

    protected abstract Instances determineOutputFormat(Instances var1) throws Exception;

    protected abstract Instances apply(Instances var1, int[] var2);

    protected Instances process(Instances instances) throws Exception {
        if (this.m_OnlyFirstBatch && this.isFirstBatchDone()) {
            return instances;
        }
        if (this.m_RowFinder instanceof TrainableRowFinder && !((TrainableRowFinder)this.m_RowFinder).isRowFinderTrained()) {
            ((TrainableRowFinder)this.m_RowFinder).trainRowFinder(instances);
        }
        int[] indices = this.m_RowFinder.findRows(instances);
        if (this.m_Invert) {
            HashSet set = new HashSet(Utils.toList((int[])indices));
            ArrayList<Integer> inverted = new ArrayList<Integer>();
            for (int i = 0; i < instances.numInstances(); ++i) {
                if (set.contains(i)) continue;
                inverted.add(i);
            }
            indices = Utils.toIntArray(inverted);
        }
        return this.apply(instances, indices);
    }
}

