/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.core.ObjectCopyHelper;
import adams.core.logging.LoggingLevel;
import adams.data.weka.rowfinder.NullFinder;
import adams.data.weka.rowfinder.RowFinder;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.lazy.LWLDatasetBuilder;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class AccumulatedLWLWeights
extends SimpleBatchFilter
implements UnsupervisedFilter,
WeightedInstancesHandler {
    private static final long serialVersionUID = -6784901276150528252L;
    protected int m_kNN = 0;
    protected int m_WeightKernel = 0;
    protected NearestNeighbourSearch m_NNSearch = new LinearNNSearch();
    protected boolean m_NoUpdate;
    protected boolean m_RowFinderEnabled = false;
    protected RowFinder m_RowFinder = new NullFinder();

    public String globalInfo() {
        return "Generates an LWL-like dataset for each instance of the data from the first batch and accumulate these weights. Once accumulated, the weights get normalized to be within the range of [0;1] and the output dataset accordingly adjusted.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe nearest neighbour search algorithm to use (default: " + LinearNNSearch.class.getName() + ").\n", "A", 0, "-A"));
        result.addElement(new Option("\tSet the number of neighbours used to set the kernel bandwidth.\n\t(default all)", "K", 1, "-K <number of neighbours>"));
        result.addElement(new Option("\tSet the weighting kernel shape to use. 0=Linear, 1=Epanechnikov,\n\t2=Tricube, 3=Inverse, 4=Gaussian.\n\t(default 0 = Linear)", "U", 1, "-U <number of weighting method>"));
        result.addElement(new Option("\tSuppresses the update of the nearest neighbor search (nns)\n\talgorithm with the data that is to be classified.\n(default: nns gets updated).\n", "no-update", 0, "-no-update"));
        result.addElement(new Option("\tWhether to use a row finder to limit the instances for which \tto determine the LWL neighborhoods for.\n\t(default off)", "row-finder-enabled", 0, "-row-finder-enabled"));
        result.addElement(new Option("\tThe row finder scheme to use for limiting the instances to \tdetermine the LWL neighborhoods for.\n\t(default: " + NullFinder.class.getName() + ")", "row-finder", 1, "-row-finder <classname + options>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String knnString = Utils.getOption((char)'K', (String[])options);
        if (knnString.length() != 0) {
            this.setKNN(Integer.parseInt(knnString));
        } else {
            this.setKNN(0);
        }
        String weightString = Utils.getOption((char)'U', (String[])options);
        if (weightString.length() != 0) {
            this.setWeightingKernel(Integer.parseInt(weightString));
        } else {
            this.setWeightingKernel(0);
        }
        String nnSearchClass = Utils.getOption((char)'A', (String[])options);
        if (nnSearchClass.length() != 0) {
            String[] nnSearchClassSpec = Utils.splitOptions((String)nnSearchClass);
            if (nnSearchClassSpec.length == 0) {
                throw new Exception("Invalid NearestNeighbourSearch algorithm specification string.");
            }
            String className = nnSearchClassSpec[0];
            nnSearchClassSpec[0] = "";
            this.setNearestNeighbourSearchAlgorithm((NearestNeighbourSearch)Utils.forName(NearestNeighbourSearch.class, (String)className, (String[])nnSearchClassSpec));
        } else {
            this.setNearestNeighbourSearchAlgorithm((NearestNeighbourSearch)new LinearNNSearch());
        }
        this.setNoUpdate(Utils.getFlag((String)"no-update", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<Object> options = new Vector<Object>();
        options.add("-U");
        options.add("" + this.getWeightingKernel());
        options.add("-K");
        options.add("" + this.getKNN());
        options.add("-A");
        options.add(this.m_NNSearch.getClass().getName() + " " + Utils.joinOptions((String[])this.m_NNSearch.getOptions()));
        if (this.getNoUpdate()) {
            options.add("-no-update");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public void setKNN(int knn) {
        if (knn < 0) {
            knn = 0;
        }
        this.m_kNN = knn;
    }

    public int getKNN() {
        return this.m_kNN;
    }

    public String KNNTipText() {
        return "How many neighbours are used to determine the width of the weighting function (<= 0 means all neighbours).";
    }

    public void setWeightingKernel(int kernel) {
        if (kernel != 0 && kernel != 1 && kernel != 2 && kernel != 3 && kernel != 4 && kernel != 5) {
            return;
        }
        this.m_WeightKernel = kernel;
    }

    public int getWeightingKernel() {
        return this.m_WeightKernel;
    }

    public String weightingKernelTipText() {
        return "Determines weighting function. [0 = Linear, 1 = Epnechnikov,2 = Tricube, 3 = Inverse, 4 = Gaussian and 5 = Constant. (default 0 = Linear)].";
    }

    public void setNearestNeighbourSearchAlgorithm(NearestNeighbourSearch nearestNeighbourSearchAlgorithm) {
        this.m_NNSearch = nearestNeighbourSearchAlgorithm;
    }

    public NearestNeighbourSearch getNearestNeighbourSearchAlgorithm() {
        return this.m_NNSearch;
    }

    public String nearestNeighbourSearchAlgorithmTipText() {
        return "The nearest neighbour search algorithm to use (Default: LinearNN).";
    }

    public void setNoUpdate(boolean value) {
        this.m_NoUpdate = value;
    }

    public boolean getNoUpdate() {
        return this.m_NoUpdate;
    }

    public String noUpdateTipText() {
        return "If turned on, suppresses the update of the nearest-neighbor search algorithm when making predictions (EXPERIMENTAL).";
    }

    public void setRowFinderEnabled(boolean value) {
        this.m_RowFinderEnabled = value;
    }

    public boolean getRowFinderEnabled() {
        return this.m_RowFinderEnabled;
    }

    public String rowFinderEnabledTipText() {
        return "If enabled, the row finder is used to limit the instances to build the LWL neighborhoods for.";
    }

    public void setRowFinder(RowFinder value) {
        this.m_RowFinder = value;
    }

    public RowFinder getRowFinder() {
        return this.m_RowFinder;
    }

    public String rowFinderTipText() {
        return "The row finder scheme to use, if enabled.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        int i;
        if (this.m_FirstBatchDone) {
            return new Instances(instances);
        }
        LWLDatasetBuilder lwl = new LWLDatasetBuilder();
        lwl.setTrain(instances);
        lwl.setKNN(this.m_kNN);
        lwl.setNoUpdate(this.m_NoUpdate);
        lwl.setWeightingKernel(this.m_WeightKernel);
        lwl.setSearchAlgorithm((NearestNeighbourSearch)ObjectCopyHelper.copyObject((Object)this.m_NNSearch));
        if (this.m_Debug) {
            lwl.setLoggingLevel(LoggingLevel.INFO);
        }
        TIntArrayList indices = new TIntArrayList();
        if (this.m_RowFinderEnabled) {
            indices.add(this.m_RowFinder.findRows(instances));
            if (this.m_Debug) {
                System.err.println("Before/after row finder: " + instances.numInstances() + "/" + indices.size());
            }
        } else {
            for (i = 0; i < instances.numInstances(); ++i) {
                indices.add(i);
            }
        }
        double[] weights = new double[instances.numInstances()];
        for (i = 0; i < indices.size(); ++i) {
            LWLDatasetBuilder.LWLContainer cont = lwl.build(instances.instance(indices.get(i)));
            for (int n = 0; n < cont.originalIndices.length; ++n) {
                int n2 = cont.originalIndices[n];
                weights[n2] = weights[n2] + cont.dataset.instance(n).weight();
            }
        }
        double min = weights[Utils.minIndex((double[])weights)];
        double max = weights[Utils.maxIndex((double[])weights)];
        double range = max - min;
        if (range == 0.0) {
            System.err.println("Weights are all the same, not adjusting weights!");
            return new Instances(instances);
        }
        Instances result = new Instances(instances);
        for (i = 0; i < weights.length; ++i) {
            result.instance(i).setWeight((weights[i] - min) / range);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        AccumulatedLWLWeights.runFilter((Filter)new AccumulatedLWLWeights(), (String[])args);
    }
}

