/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class LatestRecords
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -6195745510550220758L;
    public static final String DEFAULT_ATTNAME = "db_id";
    public static final double DEFAULT_AMOUNT = 0.5;
    protected String m_AttributeName = "db_id";
    protected double m_Amount = 0.5;

    public String globalInfo() {
        return "Retains the latest database records.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe name of the attribute that holds the numeric DB ID.\n\t(default: db_id)", "att-name", 1, "-att-name"));
        result.addElement(new Option("\tThe amount of latest records to keep.\n\t(0,1]: percentage, (1,+inf): absolute number\n\t(default: 0.5)", "amount", 1, "-amount"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"att-name", (String[])options);
        if (tmpStr.length() > 0) {
            this.setAttributeName(tmpStr);
        } else {
            this.setAttributeName(DEFAULT_ATTNAME);
        }
        tmpStr = Utils.getOption((String)"amount", (String[])options);
        if (tmpStr.length() > 0) {
            this.setAmount(Double.parseDouble(tmpStr));
        } else {
            this.setAmount(0.5);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-att-name");
        result.add(this.getAttributeName());
        result.add("-amount");
        result.add("" + this.getAmount());
        return result.toArray(new String[result.size()]);
    }

    public void setAttributeName(String value) {
        if (value != null && value.length() > 0) {
            this.m_AttributeName = value;
        } else {
            System.err.println("Attribute name cannot be null or empty!");
        }
    }

    public String getAttributeName() {
        return this.m_AttributeName;
    }

    public String attributeNameTipText() {
        return "The name of the attribute containing the numeric database ID.";
    }

    public void setAmount(double value) {
        if (value > 0.0) {
            this.m_Amount = value;
        } else {
            System.err.println("Amount must be >0, provided: " + value);
        }
    }

    public double getAmount() {
        return this.m_Amount;
    }

    public String amountTipText() {
        return "The amount of records to keep: (0,1]=percentage; (1,+inf)=absolute number.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Attribute att = inputFormat.attribute(this.m_AttributeName);
        if (att == null) {
            throw new WekaException("Attribute '" + this.m_AttributeName + "' not present!");
        }
        if (!att.isNumeric()) {
            throw new UnsupportedAttributeTypeException("Database ID attribute ('" + this.m_AttributeName + "') must be numeric!");
        }
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        int i;
        int amount = this.m_Amount <= 1.0 ? (int)Math.round((double)instances.numInstances() * this.m_Amount) : (int)Math.round(this.m_Amount);
        if (amount < 0) {
            amount = 0;
        }
        if (amount > instances.numInstances()) {
            amount = instances.numInstances();
        }
        if (amount == instances.numInstances()) {
            Instances result = new Instances(instances);
            return result;
        }
        double[] ids = new double[instances.numInstances()];
        int index = instances.attribute(this.m_AttributeName).index();
        for (i = 0; i < instances.numInstances(); ++i) {
            ids[i] = instances.instance(i).value(index);
        }
        Arrays.sort(ids);
        double min = ids[ids.length - amount];
        ids = null;
        Instances result = new Instances(instances, amount);
        for (i = 0; i < instances.numInstances(); ++i) {
            if (!(instances.instance(i).value(index) >= min)) continue;
            result.add((Instance)instances.instance(i).copy());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        LatestRecords.runFilter((Filter)new LatestRecords(), (String[])args);
    }
}

