/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.core.option.OptionUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.instance.multirowprocessor.processor.AbstractSelectionProcessor;
import weka.filters.unsupervised.instance.multirowprocessor.processor.PassThrough;
import weka.filters.unsupervised.instance.multirowprocessor.selection.AbstractRowSelection;
import weka.filters.unsupervised.instance.multirowprocessor.selection.IndividualRows;

public class MultiRowProcessor
extends SimpleBatchFilter {
    private static final long serialVersionUID = 7355559053694071645L;
    protected static String ROW_SELECTION = "row-selection";
    protected AbstractRowSelection m_RowSelection = this.getDefaultRowSelection();
    protected static String SELECTION_PROCESSOR = "selection-processor";
    protected AbstractSelectionProcessor m_SelectionProcessor = this.getDefaultSelectionProcessor();

    public String globalInfo() {
        return "Uses the specified row selection scheme to identify groups of rows in the data coming through and then applies the selected row processor to these subsets.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, this.rowSelectionTipText(), OptionUtils.getCommandLine((Object)this.getDefaultRowSelection()), ROW_SELECTION);
        WekaOptionUtils.addOption(result, this.selectionProcessorTipText(), OptionUtils.getCommandLine((Object)this.getDefaultSelectionProcessor()), SELECTION_PROCESSOR);
        WekaOptionUtils.add(result, super.listOptions());
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setRowSelection((AbstractRowSelection)WekaOptionUtils.parse(options, ROW_SELECTION, (OptionHandler)this.getDefaultRowSelection()));
        this.setSelectionProcessor((AbstractSelectionProcessor)WekaOptionUtils.parse(options, SELECTION_PROCESSOR, (OptionHandler)this.getDefaultSelectionProcessor()));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, ROW_SELECTION, (OptionHandler)this.getRowSelection());
        WekaOptionUtils.add(result, SELECTION_PROCESSOR, (OptionHandler)this.getSelectionProcessor());
        WekaOptionUtils.add(result, super.getOptions());
        return WekaOptionUtils.toArray(result);
    }

    protected AbstractRowSelection getDefaultRowSelection() {
        return new IndividualRows();
    }

    public void setRowSelection(AbstractRowSelection value) {
        this.m_RowSelection = value;
        this.reset();
    }

    public AbstractRowSelection getRowSelection() {
        return this.m_RowSelection;
    }

    public String rowSelectionTipText() {
        return "The scheme for identifying the row subsets to process.";
    }

    protected AbstractSelectionProcessor getDefaultSelectionProcessor() {
        return new PassThrough();
    }

    public void setSelectionProcessor(AbstractSelectionProcessor value) {
        this.m_SelectionProcessor = value;
        this.reset();
    }

    public AbstractSelectionProcessor getSelectionProcessor() {
        return this.m_SelectionProcessor;
    }

    public String selectionProcessorTipText() {
        return "The scheme for processing the identified row subsets.";
    }

    protected void debugMsg(String msg) {
        System.err.println(((Object)((Object)this)).getClass().getName() + ": " + msg);
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return this.m_SelectionProcessor.generateOutputFormat(inputFormat);
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(this.getOutputFormat(), instances.numInstances());
        if (this.getDebug()) {
            this.debugMsg("Identifying subsets...");
        }
        List<int[]> subsets = this.m_RowSelection.selectRows(instances);
        if (this.getDebug()) {
            this.debugMsg("Processing subsets...");
        }
        for (int i = 0; i < subsets.size(); ++i) {
            int[] rows = subsets.get(i);
            if (this.getDebug()) {
                this.debugMsg("Subset " + (i + 1) + "/" + subsets.size() + ": " + Utils.arrayToString((Object)rows));
            }
            ArrayList<Instance> subset = new ArrayList<Instance>();
            for (int row : rows) {
                subset.add(instances.instance(row));
            }
            List<Instance> processed = this.m_SelectionProcessor.processRows(subset);
            Object object = processed.iterator();
            while (object.hasNext()) {
                Instance p = (Instance)object.next();
                this.copyValues(p, false, instances, result);
                result.add(p);
            }
        }
        result.compactify();
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        MultiRowProcessor.runFilter((Filter)new MultiRowProcessor(), (String[])args);
    }
}

