/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class Sort
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -6195745510550220758L;
    protected boolean m_IncludeClass = false;

    public String globalInfo() {
        return "Sorts the instances.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tWhether to include the class attribute in the comparison as well.\n", "include-class", 0, "-include-class"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setIncludeClass(Utils.getFlag((String)"include-class", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        if (this.getIncludeClass()) {
            result.add("-include-class");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setIncludeClass(boolean value) {
        this.m_IncludeClass = value;
    }

    public boolean getIncludeClass() {
        return this.m_IncludeClass;
    }

    public String includeClassTipText() {
        return "If enabled, the class attribute gets taken into account when comparing instances.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(instances);
        InstanceComparator comp = new InstanceComparator(this.m_IncludeClass);
        Collections.sort(result, comp);
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        Sort.runFilter((Filter)new Sort(), (String[])args);
    }
}

