/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance.multirowprocessor.processor;

import adams.data.statistics.StatUtils;
import java.util.ArrayList;
import java.util.List;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.unsupervised.instance.multirowprocessor.processor.AbstractRangeBasedSelectionProcessor;

public class Average
extends AbstractRangeBasedSelectionProcessor {
    private static final long serialVersionUID = 273226641478995302L;

    @Override
    public String globalInfo() {
        return "Computes the average of the numeric attributes defined in the range.\nIn case of attributes outside the range or non-numeric ones, the values of the first row are used in the output.";
    }

    @Override
    public Instances generateOutputFormat(Instances data) throws Exception {
        return new Instances(data, 0);
    }

    @Override
    protected List<Instance> doProcessRows(List<Instance> rows) throws Exception {
        if (rows.size() < 2) {
            return rows;
        }
        this.m_Range.setData(rows.get(0).dataset());
        int[] indices = this.m_Range.getIntIndices();
        if (indices.length == 0) {
            this.debugMsg("[WARNING] No attributes to work on? Range: " + this.m_Range.getRange());
            return rows;
        }
        ArrayList<Instance> result = new ArrayList<Instance>();
        double[] values = rows.get(0).toDoubleArray();
        double[] data = new double[rows.size()];
        for (int i = 0; i < indices.length; ++i) {
            if (!rows.get(0).attribute(indices[i]).isNumeric()) continue;
            for (int n = 0; n < rows.size(); ++n) {
                data[n] = rows.get(n).value(indices[i]);
            }
            values[indices[i]] = StatUtils.mean((double[])data);
        }
        result.add((Instance)new DenseInstance(1.0, values));
        return result;
    }
}

