/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.DateFormat;
import adams.core.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import nz.ac.waikato.adams.webservice.weka.Attribute;
import nz.ac.waikato.adams.webservice.weka.Attributes;
import nz.ac.waikato.adams.webservice.weka.Body;
import nz.ac.waikato.adams.webservice.weka.Dataset;
import nz.ac.waikato.adams.webservice.weka.Header;
import nz.ac.waikato.adams.webservice.weka.Instance;
import nz.ac.waikato.adams.webservice.weka.InstanceType;
import nz.ac.waikato.adams.webservice.weka.Labels;
import nz.ac.waikato.adams.webservice.weka.Type;
import nz.ac.waikato.adams.webservice.weka.Value;
import nz.ac.waikato.adams.webservice.weka.YesNo;
import weka.classifiers.Evaluation;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.Version;

public class DatasetHelper {
    protected static DateFormat m_DateFormat = DateUtils.getTimestampFormatterMsecs();

    public static Dataset fromInstances(Instances inst) {
        Dataset xrffDataset = new Dataset();
        Header header = new Header();
        Body body = new Body();
        xrffDataset.setBody(body);
        xrffDataset.setHeader(header);
        xrffDataset.setName(inst.relationName());
        xrffDataset.setVersion(Version.VERSION);
        Attributes attributes = new Attributes();
        header.setAttributes(attributes);
        int classIndex = inst.classIndex();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            Attribute attribute = new Attribute();
            weka.core.Attribute wekaAttribute = inst.attribute(i);
            attribute.setName(wekaAttribute.name());
            Type type = Type.STRING;
            switch (wekaAttribute.type()) {
                case 1: {
                    type = Type.NOMINAL;
                    Labels l = new Labels();
                    attribute.setLabels(l);
                    Enumeration enm = wekaAttribute.enumerateValues();
                    while (enm.hasMoreElements()) {
                        l.getLabel().add((String)enm.nextElement());
                    }
                    break;
                }
                case 0: {
                    type = Type.NUMERIC;
                    break;
                }
                case 3: {
                    type = Type.DATE;
                    attribute.setFormat(wekaAttribute.getDateFormat());
                    break;
                }
                case 2: {
                    type = Type.STRING;
                    break;
                }
                case 4: {
                    type = Type.RELATIONAL;
                }
            }
            attribute.setType(type);
            if (i == classIndex) {
                attribute.setClassAttribute(YesNo.YES);
            }
            attribute.setWeight(wekaAttribute.weight());
            attributes.getAttribute().add(attribute);
        }
        nz.ac.waikato.adams.webservice.weka.Instances instances = new nz.ac.waikato.adams.webservice.weka.Instances();
        body.setInstances(instances);
        for (int i = 0; i < inst.size(); ++i) {
            weka.core.Instance wekaInstance = inst.get(i);
            Instance instanceToAdd = new Instance();
            instanceToAdd.setInstanceWeight(wekaInstance.weight());
            boolean isSparse = wekaInstance instanceof SparseInstance;
            instanceToAdd.setInstanceType(InstanceType.NORMAL);
            if (isSparse) {
                instanceToAdd.setInstanceType(InstanceType.SPARSE);
            }
            for (int v = 0; v < wekaInstance.numValues(); ++v) {
                String attributeValue;
                Value value = new Value();
                int index = wekaInstance.index(v);
                if (wekaInstance.attribute(index).isNumeric()) {
                    Double val = wekaInstance.value(index);
                    attributeValue = val.toString();
                } else {
                    attributeValue = wekaInstance.stringValue(index);
                }
                if (attributeValue != null) {
                    value.setValue(attributeValue);
                } else {
                    value.setValueMissing(YesNo.YES);
                }
                if (isSparse) {
                    value.setValueIndex(index);
                }
                instanceToAdd.getValue().add(value);
            }
            instances.getInstance().add(instanceToAdd);
        }
        return xrffDataset;
    }

    public static Instances toInstances(Dataset d) {
        int n;
        ArrayList<weka.core.Attribute> attributes = new ArrayList<weka.core.Attribute>();
        int classIndex = -1;
        block15: for (n = 0; n < d.getHeader().getAttributes().getAttribute().size(); ++n) {
            Attribute a = d.getHeader().getAttributes().getAttribute().get(n);
            if (a.getClassAttribute() == YesNo.YES) {
                classIndex = n;
            }
            switch (a.getType()) {
                case NOMINAL: {
                    ArrayList<String> attributeVals = new ArrayList<String>();
                    for (String s : a.getLabels().getLabel()) {
                        attributeVals.add(s);
                    }
                    weka.core.Attribute toAdd = new weka.core.Attribute(a.getName(), attributeVals);
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
                case NUMERIC: {
                    weka.core.Attribute toAdd = new weka.core.Attribute(a.getName());
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
                case DATE: {
                    weka.core.Attribute toAdd = new weka.core.Attribute(a.getName(), a.getFormat());
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
                case STRING: {
                    weka.core.Attribute toAdd = new weka.core.Attribute(a.getName(), (List)null);
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
            }
        }
        Instances data = new Instances(d.getName(), attributes, 0);
        for (Instance i : d.getBody().getInstances().getInstance()) {
            double[] values = new double[i.getValue().size()];
            boolean isSparse = i.getInstanceType() == InstanceType.SPARSE;
            block18: for (n = 0; n < i.getValue().size(); ++n) {
                values[n] = Utils.missingValue();
                switch (d.getHeader().getAttributes().getAttribute().get(n).getType()) {
                    case NOMINAL: {
                        values[n] = ((weka.core.Attribute)attributes.get(n)).indexOfValue(i.getValue().get(n).getValue());
                        continue block18;
                    }
                    case NUMERIC: {
                        values[n] = new Double(i.getValue().get(n).getValue());
                        continue block18;
                    }
                    case RELATIONAL: {
                        continue block18;
                    }
                    case DATE: {
                        try {
                            values[n] = data.attribute(n).parseDate(i.getValue().get(n).getValue());
                        }
                        catch (ParseException e) {
                            values[n] = Utils.missingValue();
                            e.printStackTrace();
                        }
                        continue block18;
                    }
                    case STRING: {
                        values[n] = data.attribute(n).addStringValue(i.getValue().get(n).getValue());
                    }
                }
            }
            if (isSparse) {
                data.add((weka.core.Instance)new SparseInstance(1.0, values));
                continue;
            }
            data.add((weka.core.Instance)new DenseInstance(1.0, values));
        }
        data.setClassIndex(classIndex);
        return data;
    }

    public static String datasetToString(Dataset dataset) {
        StringBuilder dataSetString = new StringBuilder();
        for (Attribute a : dataset.getHeader().getAttributes().getAttribute()) {
            dataSetString.append(a.getName() + "\t" + (Object)((Object)a.getType()) + "\t");
            if (a.getType() == Type.NOMINAL) {
                dataSetString.append("{");
                int count = 0;
                for (String s : a.getLabels().getLabel()) {
                    if (count == 0) {
                        dataSetString.append(s);
                    } else {
                        dataSetString.append(", " + s);
                    }
                    ++count;
                }
                dataSetString.append("}");
            }
            dataSetString.append("\n");
        }
        for (Instance i : dataset.getBody().getInstances().getInstance()) {
            dataSetString.append("Instance: \t ");
            for (Value v : i.getValue()) {
                dataSetString.append(v.getValue() + " ");
            }
            dataSetString.append("\n");
        }
        return dataSetString.toString();
    }

    public static void addAttribute(Dataset dataset, String name, Type type) {
        Attributes atts = dataset.getHeader().getAttributes();
        Attribute att = new Attribute();
        att.setName(name);
        att.setType(type);
        atts.getAttribute().add(att);
    }

    public static void addValue(Instance inst, int index, String value) {
        Value val = new Value();
        val.setValueIndex(0);
        val.setValue(value);
        inst.getValue().add(val);
    }

    public static void addValue(Instance inst, int index, double value) {
        Value val = new Value();
        val.setValueIndex(0);
        val.setValue("" + value);
        inst.getValue().add(val);
    }

    public static void addStatistic(Dataset dataset, String name, double value) {
        Instance inst = new Instance();
        inst.setInstanceType(InstanceType.NORMAL);
        inst.setInstanceWeight(1.0);
        dataset.getBody().getInstances().getInstance().add(inst);
        DatasetHelper.addValue(inst, 0, name);
        DatasetHelper.addValue(inst, 1, value);
    }

    public static Dataset evaluationToDataset(Evaluation eval) {
        Dataset result = new Dataset();
        result.setName(eval.getHeader().relationName());
        result.setVersion(DatasetHelper.getDateFormat().format(new Date()));
        result.setHeader(new Header());
        result.getHeader().setAttributes(new Attributes());
        DatasetHelper.addAttribute(result, "Statistic", Type.STRING);
        DatasetHelper.addAttribute(result, "Value", Type.NUMERIC);
        result.setBody(new Body());
        result.getBody().setInstances(new nz.ac.waikato.adams.webservice.weka.Instances());
        if (eval.getHeader().classAttribute().isNominal()) {
            DatasetHelper.addStatistic(result, "Percent correct", eval.pctCorrect());
            DatasetHelper.addStatistic(result, "Percent incorrect", eval.pctIncorrect());
            DatasetHelper.addStatistic(result, "Num correct", eval.correct());
            DatasetHelper.addStatistic(result, "Num incorrect", eval.incorrect());
            DatasetHelper.addStatistic(result, "Kappa", eval.kappa());
        } else {
            try {
                DatasetHelper.addStatistic(result, "Correlation coefficient", eval.correlationCoefficient());
            }
            catch (Exception e) {
                DatasetHelper.addStatistic(result, "Correlation coefficient", Double.NaN);
            }
        }
        DatasetHelper.addStatistic(result, "Mean absolute error", eval.meanAbsoluteError());
        DatasetHelper.addStatistic(result, "Root mean squared error", eval.rootMeanSquaredError());
        try {
            DatasetHelper.addStatistic(result, "Relative absolute error", eval.relativeAbsoluteError());
        }
        catch (Exception e) {
            DatasetHelper.addStatistic(result, "Relative absolute error", Double.NaN);
        }
        DatasetHelper.addStatistic(result, "Root relative squared error", eval.rootRelativeSquaredError());
        DatasetHelper.addStatistic(result, "Unclassified instances", eval.unclassified());
        DatasetHelper.addStatistic(result, "Total number of instances", eval.numInstances());
        return result;
    }

    public static DateFormat getDateFormat() {
        return m_DateFormat;
    }
}

