/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.LRUCache;
import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.core.option.WekaCommandLineHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Compatibility;
import adams.flow.core.DatasetHelper;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.webservice.OwnedByWekaServiceWS;
import adams.flow.webservice.WekaServiceWS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import nz.ac.waikato.adams.webservice.weka.Attributes;
import nz.ac.waikato.adams.webservice.weka.Body;
import nz.ac.waikato.adams.webservice.weka.CrossValidateResponseObject;
import nz.ac.waikato.adams.webservice.weka.Dataset;
import nz.ac.waikato.adams.webservice.weka.DisplayClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.DisplayClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.DownloadClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.DownloadClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.Header;
import nz.ac.waikato.adams.webservice.weka.Instance;
import nz.ac.waikato.adams.webservice.weka.InstanceType;
import nz.ac.waikato.adams.webservice.weka.OptimizeReturnObject;
import nz.ac.waikato.adams.webservice.weka.PredictClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.PredictClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.TestClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.TrainClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.TrainClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.TransformResponseObject;
import nz.ac.waikato.adams.webservice.weka.Type;
import nz.ac.waikato.adams.webservice.weka.WekaService;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.MultiSearch;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.setupgenerator.AbstractParameter;

public class SimpleWekaService
extends AbstractOptionHandler
implements WekaService,
OwnedByWekaServiceWS {
    private static final long serialVersionUID = -6102580694812360595L;
    protected WekaServiceWS m_Owner;
    protected LRUCache<String, Classifier> m_Classifiers;
    protected LRUCache<String, Clusterer> m_Clusterers;

    public SimpleWekaService() {
        this.setOwner(null);
    }

    public String globalInfo() {
        return "Simple implementation of a WEKA webservice. Not multi-threaded.";
    }

    @Override
    public void setOwner(WekaServiceWS value) {
        this.m_Owner = value;
        if (this.m_Owner != null) {
            this.m_Classifiers = new LRUCache(this.m_Owner.getClassifierCacheSize());
            this.m_Clusterers = new LRUCache(this.m_Owner.getClassifierCacheSize());
        } else {
            this.m_Classifiers = new LRUCache(10);
            this.m_Clusterers = new LRUCache(10);
        }
    }

    @Override
    public WekaServiceWS getOwner() {
        return this.m_Owner;
    }

    @Override
    public TrainClassifierResponseObject trainClassifier(Dataset dataset, String classifier, String name) {
        TrainClassifierResponseObject result = new TrainClassifierResponseObject();
        this.m_Owner.getLogger().info("training classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(classifier);
        this.m_Owner.getLogger().info(name);
        try {
            Instances data = DatasetHelper.toInstances(dataset);
            Classifier cls = (Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)classifier);
            cls.buildClassifier(data);
            this.m_Classifiers.put((Object)name, (Object)cls);
            result.setModel(cls.toString());
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)("Failed to train classifier: " + classifier), (Throwable)ex));
        }
        return result;
    }

    @Override
    public TestClassifierResponseObject testClassifier(Dataset dataset, String modelName) {
        TestClassifierResponseObject result = new TestClassifierResponseObject();
        this.m_Owner.getLogger().info("testing classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        if (!this.m_Classifiers.contains((Object)modelName)) {
            result.setErrorMessage("Failed to test model '" + modelName + "', as it is not (or no longer) cached!");
            return result;
        }
        try {
            Instances data = DatasetHelper.toInstances(dataset);
            Classifier cls = (Classifier)this.m_Classifiers.get((Object)modelName);
            Evaluation eval = new Evaluation(data);
            eval.evaluateModel(cls, data, new Object[0]);
            result.setReturnDataset(DatasetHelper.evaluationToDataset(eval));
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)("Failed to test model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public CrossValidateResponseObject crossValidateClassifier(Dataset dataset, int seed, int folds, String classifier) {
        CrossValidateResponseObject result = new CrossValidateResponseObject();
        this.m_Owner.getLogger().info("cross-validation");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info("" + seed);
        this.m_Owner.getLogger().info("" + folds);
        this.m_Owner.getLogger().info(classifier);
        try {
            Instances data = DatasetHelper.toInstances(dataset);
            Classifier cls = (Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)classifier);
            Evaluation eval = new Evaluation(data);
            eval.crossValidateModel(cls, data, folds, new Random(seed), new Object[0]);
            result.setReturnDataset(DatasetHelper.evaluationToDataset(eval));
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)("Failed to cross-validate classifier '" + classifier + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public PredictClassifierResponseObject predictClassifier(Dataset dataset, String modelName) {
        PredictClassifierResponseObject result = new PredictClassifierResponseObject();
        this.m_Owner.getLogger().info("predicting using classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        if (!this.m_Classifiers.contains((Object)modelName)) {
            result.setErrorMessage("Failed to make predictions using classifier model '" + modelName + "', as it is not (or no longer) cached!");
            return result;
        }
        Instances data = DatasetHelper.toInstances(dataset);
        if (data.classIndex() == -1) {
            result.setErrorMessage("No class attribute set!");
            return result;
        }
        try {
            int i;
            boolean nominal = data.classAttribute().isNominal();
            Attribute wAtt = data.classAttribute();
            Classifier cls = (Classifier)this.m_Classifiers.get((Object)modelName);
            Dataset pred = new Dataset();
            result.setReturnDataset(pred);
            pred.setName("Predictions on '" + data.relationName() + "' using " + "'" + modelName + "'");
            pred.setVersion(DatasetHelper.getDateFormat().format(new Date()));
            pred.setHeader(new Header());
            pred.getHeader().setAttributes(new Attributes());
            if (nominal) {
                DatasetHelper.addAttribute(pred, "Classification", Type.STRING);
                for (i = 0; i < wAtt.numValues(); ++i) {
                    DatasetHelper.addAttribute(pred, "Distribution (" + wAtt.value(i) + ")", Type.NUMERIC);
                }
            } else {
                DatasetHelper.addAttribute(pred, "Classification", Type.NUMERIC);
            }
            pred.setBody(new Body());
            pred.getBody().setInstances(new nz.ac.waikato.adams.webservice.weka.Instances());
            for (i = 0; i < data.numInstances(); ++i) {
                double classification;
                weka.core.Instance inst = data.instance(i);
                inst.setClassMissing();
                Instance in = new Instance();
                in.setInstanceType(InstanceType.NORMAL);
                in.setInstanceWeight(1.0);
                pred.getBody().getInstances().getInstance().add(in);
                if (nominal) {
                    classification = cls.classifyInstance(inst);
                    DatasetHelper.addValue(in, 0, wAtt.value((int)classification));
                    double[] distribution = cls.distributionForInstance(inst);
                    for (int n = 0; n < distribution.length; ++n) {
                        DatasetHelper.addValue(in, 1 + n, distribution[n]);
                    }
                    continue;
                }
                classification = cls.classifyInstance(inst);
                DatasetHelper.addValue(in, 0, classification);
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)("Failed to make predictions with classifier model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public DownloadClassifierResponseObject downloadClassifier(String modelName) {
        DownloadClassifierResponseObject result = new DownloadClassifierResponseObject();
        this.m_Owner.getLogger().info("downloading classifier");
        this.m_Owner.getLogger().info(modelName);
        if (!this.m_Classifiers.contains((Object)modelName)) {
            result.setErrorMessage("No Classifier available named: " + modelName);
            return result;
        }
        try {
            result.setModelData(new DataHandler((DataSource)new ByteArrayDataSource(SerializationHelper.toByteArray((Object)this.m_Classifiers.get((Object)modelName)), "application/octet-stream")));
        }
        catch (Exception e) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this, (String)("Failed to serialize classifier: " + modelName), (Throwable)e));
        }
        return result;
    }

    @Override
    public DownloadClustererResponseObject downloadClusterer(String modelName) {
        DownloadClustererResponseObject result = new DownloadClustererResponseObject();
        this.m_Owner.getLogger().info("downloading clusterer");
        this.m_Owner.getLogger().info(modelName);
        if (!this.m_Clusterers.contains((Object)modelName)) {
            result.setErrorMessage("No Clusterer available named: " + modelName);
            return result;
        }
        try {
            result.setModelData(new DataHandler((DataSource)new ByteArrayDataSource(SerializationHelper.toByteArray((Object)this.m_Clusterers.get((Object)modelName)), "application/octet-stream")));
        }
        catch (Exception e) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this, (String)("Failed to serialize clusterer: " + modelName), (Throwable)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformResponseObject transform(Dataset dataset, String actorName) {
        TransformResponseObject result = new TransformResponseObject();
        this.m_Owner.getLogger().info("transform");
        CallableActorHelper helper = new CallableActorHelper();
        AbstractActor callable = helper.findCallableActor(this.m_Owner.getOwner().getRoot(), new CallableActorReference(actorName));
        if (callable == null) {
            result.setErrorMessage("Failed to find callable actor '" + actorName + "'!");
            return result;
        }
        if (!ActorUtils.isTransformer((Actor)callable)) {
            result.setErrorMessage("Callable actor '" + actorName + "' is not a transformer!");
            return result;
        }
        Compatibility comp = new Compatibility();
        if (!comp.isCompatible(new Class[]{Instances.class}, ((InputConsumer)callable).accepts())) {
            result.setErrorMessage("Callable transformer '" + actorName + "' does not accept " + Instances.class.getName() + "!");
            return result;
        }
        if (!comp.isCompatible(((OutputProducer)callable).generates(), new Class[]{Instances.class})) {
            result.setErrorMessage("Callable transformer '" + actorName + "' does not generate " + Instances.class.getName() + "!");
            return result;
        }
        Instances data = DatasetHelper.toInstances(dataset);
        try {
            AbstractActor abstractActor = callable;
            synchronized (abstractActor) {
                ((InputConsumer)callable).input(new Token((Object)data));
                String msg = callable.execute();
                if (msg != null) {
                    result.setErrorMessage(msg);
                    return result;
                }
                if (!((OutputProducer)callable).hasPendingOutput()) {
                    result.setErrorMessage("Callable transformer '" + actorName + "' did not produce any output!");
                    return result;
                }
                Token output = ((OutputProducer)callable).output();
                data = (Instances)output.getPayload();
                result.setReturnDataset(DatasetHelper.fromInstances(data));
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)("Failed to transform data using callable transformer '" + actorName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public TrainClustererResponseObject trainClusterer(Dataset dataset, String clusterer, String modelName) {
        TrainClustererResponseObject result = new TrainClustererResponseObject();
        this.m_Owner.getLogger().info("training clusterer");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(clusterer);
        this.m_Owner.getLogger().info(modelName);
        try {
            Instances data = DatasetHelper.toInstances(dataset);
            Clusterer cls = (Clusterer)OptionUtils.forAnyCommandLine(Clusterer.class, (String)clusterer);
            cls.buildClusterer(data);
            this.m_Clusterers.put((Object)modelName, (Object)cls);
            result.setModel(cls.toString());
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)("Failed to train clusterer: " + clusterer), (Throwable)ex));
        }
        return result;
    }

    @Override
    public PredictClustererResponseObject predictClusterer(Dataset dataset, String modelName) {
        PredictClustererResponseObject result = new PredictClustererResponseObject();
        this.m_Owner.getLogger().info("predicting using clusterer");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        if (!this.m_Clusterers.contains((Object)modelName)) {
            result.setErrorMessage("Failed to make predictions using clusterer model '" + modelName + "', as it is not (or no longer) cached!");
            return result;
        }
        Instances data = DatasetHelper.toInstances(dataset);
        if (data.classIndex() != -1) {
            result.setErrorMessage("Dataset cannot have class attribute set!");
            return result;
        }
        try {
            int i;
            Clusterer cls = (Clusterer)this.m_Clusterers.get((Object)modelName);
            Dataset pred = new Dataset();
            result.setReturnDataset(pred);
            pred.setName("Predictions on '" + data.relationName() + "' using " + "'" + modelName + "'");
            pred.setVersion(DatasetHelper.getDateFormat().format(new Date()));
            pred.setHeader(new Header());
            pred.getHeader().setAttributes(new Attributes());
            DatasetHelper.addAttribute(pred, "Cluster", Type.NUMERIC);
            int numClusters = cls.numberOfClusters();
            for (i = 0; i < numClusters; ++i) {
                DatasetHelper.addAttribute(pred, "Cluster membership " + (i + 1), Type.NUMERIC);
            }
            pred.setBody(new Body());
            pred.getBody().setInstances(new nz.ac.waikato.adams.webservice.weka.Instances());
            for (i = 0; i < data.numInstances(); ++i) {
                weka.core.Instance inst = data.instance(i);
                Instance in = new Instance();
                in.setInstanceType(InstanceType.NORMAL);
                in.setInstanceWeight(1.0);
                pred.getBody().getInstances().getInstance().add(in);
                double cluster = cls.clusterInstance(inst);
                DatasetHelper.addValue(in, 0, cluster + 1.0);
                double[] distribution = cls.distributionForInstance(inst);
                for (int n = 0; n < distribution.length; ++n) {
                    DatasetHelper.addValue(in, 1 + n, distribution[n]);
                }
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)("Failed to make predictions with model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public DisplayClassifierResponseObject displayClassifier(String model) {
        this.m_Owner.getLogger().info("displaying classifier: " + model);
        DisplayClassifierResponseObject result = new DisplayClassifierResponseObject();
        if (this.m_Classifiers.contains((Object)model)) {
            result.setDisplayString(((Classifier)this.m_Classifiers.get((Object)model)).toString());
        } else {
            result.setErrorMessage("Classifier model '" + model + "' not (or no longer) available!");
        }
        return result;
    }

    @Override
    public DisplayClustererResponseObject displayClusterer(String model) {
        this.m_Owner.getLogger().info("displaying clusterer: " + model);
        DisplayClustererResponseObject result = new DisplayClustererResponseObject();
        if (this.m_Clusterers.contains((Object)model)) {
            result.setDisplayString(((Clusterer)this.m_Clusterers.get((Object)model)).toString());
        } else {
            result.setErrorMessage("Clusterer model '" + model + "' not (or no longer) available!");
        }
        return result;
    }

    @Override
    public List<String> listClassifiers() {
        this.m_Owner.getLogger().info("listing classifiers");
        ArrayList<String> result = new ArrayList<String>(this.m_Classifiers.keySet());
        Collections.sort(result);
        if (this.m_Owner.isLoggingEnabled()) {
            this.m_Owner.getLogger().info("current classifiers" + result);
        }
        return result;
    }

    @Override
    public List<String> listClusterers() {
        this.m_Owner.getLogger().info("listing clusterers");
        ArrayList<String> result = new ArrayList<String>(this.m_Clusterers.keySet());
        Collections.sort(result);
        if (this.m_Owner.isLoggingEnabled()) {
            this.m_Owner.getLogger().info("current clusterers: " + result);
        }
        return result;
    }

    @Override
    public OptimizeReturnObject optimizeClassifierMultiSearch(String classifier, List<String> searchParameters, Dataset dataset, String evaluation) {
        this.m_Owner.getLogger().info("optimizing classifiers using MultiSearch");
        OptimizeReturnObject result = new OptimizeReturnObject();
        WekaCommandLineHandler handler = new WekaCommandLineHandler();
        MultiSearch search = new MultiSearch();
        AbstractParameter[] params = new AbstractParameter[searchParameters.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = (AbstractParameter)handler.fromCommandLine(searchParameters.get(i));
        }
        search.setSearchParameters(params);
        if (evaluation.equals("ACC")) {
            search.setEvaluation(new SelectedTag(6, MultiSearch.TAGS_EVALUATION));
        } else if (evaluation.equals("COMBINED")) {
            search.setEvaluation(new SelectedTag(5, MultiSearch.TAGS_EVALUATION));
        } else if (evaluation.equals("CC")) {
            search.setEvaluation(new SelectedTag(0, MultiSearch.TAGS_EVALUATION));
        } else if (evaluation.equals("KAPPA")) {
            search.setEvaluation(new SelectedTag(7, MultiSearch.TAGS_EVALUATION));
        } else if (evaluation.equals("MAE")) {
            search.setEvaluation(new SelectedTag(3, MultiSearch.TAGS_EVALUATION));
        } else if (evaluation.equals("RAE")) {
            search.setEvaluation(new SelectedTag(4, MultiSearch.TAGS_EVALUATION));
        } else if (evaluation.equals("RMSE")) {
            search.setEvaluation(new SelectedTag(1, MultiSearch.TAGS_EVALUATION));
        } else if (evaluation.equals("RRSE")) {
            search.setEvaluation(new SelectedTag(2, MultiSearch.TAGS_EVALUATION));
        } else {
            result.setErrorMessage("Unhandled evaluation: " + evaluation);
        }
        search.setClassifier((Classifier)handler.fromCommandLine(classifier));
        if (result.getErrorMessage() == null) {
            try {
                search.buildClassifier(DatasetHelper.toInstances(dataset));
                result.setBestClassifierSetup(handler.toCommandLine((Object)search.getBestClassifier()));
            }
            catch (Exception ex) {
                result.setErrorMessage(Utils.handleException((LoggingObject)this.m_Owner, (String)"Failed to optimize classifier!", (Throwable)ex));
            }
        }
        return result;
    }

    protected void displayString(Dataset dataset) {
        if (!this.m_Owner.isLoggingEnabled()) {
            return;
        }
        this.m_Owner.getLogger().info("Number of instances: \t " + dataset.getBody().getInstances().getInstance().size());
        this.m_Owner.getLogger().info(DatasetHelper.datasetToString(dataset));
    }
}

