/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.DatasetHelper;
import adams.flow.core.Token;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.transformer.AbstractTransformer;
import nz.ac.waikato.adams.webservice.weka.OptimizeClassifierMultiSearch;
import weka.classifiers.Classifier;
import weka.classifiers.meta.MultiSearch;
import weka.core.Instances;
import weka.core.setupgenerator.AbstractParameter;

public class WekaWSOptimizeClassifierMultiSearch
extends AbstractTransformer {
    private static final long serialVersionUID = -1600923751846355040L;
    protected Classifier m_Classifier;
    protected CallableActorReference m_ClassifierActor;
    protected AbstractParameter[] m_Parameters;
    protected Evaluation m_Evaluation;

    public String globalInfo() {
        return "Generates an optimization request using " + MultiSearch.class.getName() + ", using the Weka web-service.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new CallableActorReference(WekaClassifierSetup.class.getSimpleName()));
        this.m_OptionManager.add("parameter", "parameters", (Object)new AbstractParameter[0]);
        this.m_OptionManager.add("evaluation", "evaluation", (Object)Evaluation.ACCURACY);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)this.m_Classifier, (String)"classifier: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"evaluation", (Object)((Object)this.m_Evaluation), (String)", evaluation: ");
        return result;
    }

    public void setParameters(AbstractParameter[] value) {
        this.m_Parameters = value;
        this.reset();
    }

    public AbstractParameter[] getParameters() {
        return this.m_Parameters;
    }

    public String parametersTipText() {
        return "The search parameters to use for the optimization.";
    }

    public void setClassifier(CallableActorReference c) {
        this.m_ClassifierActor = c;
        this.reset();
    }

    public CallableActorReference getClassifier() {
        return this.m_ClassifierActor;
    }

    public String classifierTipText() {
        return "Global actore for the base classifier to use optimize.";
    }

    public void setEvaluation(Evaluation value) {
        this.m_Evaluation = value;
        this.reset();
    }

    public Evaluation getEvaluation() {
        return this.m_Evaluation;
    }

    public String evaluationTipText() {
        return "The type of statistic to evaluate the performance of a setup with.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{OptimizeClassifierMultiSearch.class};
    }

    protected Classifier getClassifierInstance() {
        MessageCollection errors = new MessageCollection();
        Classifier result = (Classifier)CallableActorHelper.getSetup(Classifier.class, (CallableActorReference)this.m_ClassifierActor, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    protected String doExecute() {
        OptimizeClassifierMultiSearch optimize = new OptimizeClassifierMultiSearch();
        this.m_Classifier = this.getClassifierInstance();
        optimize.setClassifier(OptionUtils.getCommandLine((Object)this.m_Classifier));
        for (int i = 0; i < this.m_Parameters.length; ++i) {
            optimize.getSearchParameters().add(OptionUtils.getCommandLine((Object)this.m_Parameters[i]));
        }
        optimize.setDataset(DatasetHelper.fromInstances((Instances)this.m_InputToken.getPayload()));
        switch (this.m_Evaluation) {
            case ACCURACY: {
                optimize.setEvaluation("ACC");
                break;
            }
            case COMBINED: {
                optimize.setEvaluation("COMBINED");
                break;
            }
            case CORRELATION_COEFFICIENT: {
                optimize.setEvaluation("CC");
                break;
            }
            case KAPPA: {
                optimize.setEvaluation("KAPPA");
                break;
            }
            case MEAN_ABSOLUTE_ERROR: {
                optimize.setEvaluation("MAE");
                break;
            }
            case RELATIVE_ABSOLUTE_ERROR: {
                optimize.setEvaluation("RAE");
                break;
            }
            case ROOT_MEAN_SQUARED_ERROR: {
                optimize.setEvaluation("RMSE");
                break;
            }
            case ROOT_RELATIVE_SQUARED_ERROR: {
                optimize.setEvaluation("RRSE");
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled evaluation: " + (Object)((Object)this.m_Evaluation));
            }
        }
        this.m_OutputToken = new Token((Object)optimize);
        return null;
    }

    public static enum Evaluation {
        CORRELATION_COEFFICIENT,
        ROOT_MEAN_SQUARED_ERROR,
        ROOT_RELATIVE_SQUARED_ERROR,
        MEAN_ABSOLUTE_ERROR,
        RELATIVE_ABSOLUTE_ERROR,
        COMBINED,
        ACCURACY,
        KAPPA;

    }
}

