/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.flow.core.Actor;
import adams.flow.webservice.AbstractWebServiceClientTransformer;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import nz.ac.waikato.adams.webservice.weka.CrossValidateClassifier;
import nz.ac.waikato.adams.webservice.weka.CrossValidateResponseObject;
import nz.ac.waikato.adams.webservice.weka.Dataset;
import nz.ac.waikato.adams.webservice.weka.WekaService;
import nz.ac.waikato.adams.webservice.weka.WekaServiceService;

public class CrossValidationClassifier
extends AbstractWebServiceClientTransformer<CrossValidateClassifier, Dataset> {
    private static final long serialVersionUID = -3627934949295336741L;
    protected CrossValidateClassifier m_CrossValidate;

    public String globalInfo() {
        return "Triggers a cross-validation on the server.";
    }

    public Class[] accepts() {
        return new Class[]{CrossValidateClassifier.class};
    }

    public void setRequestData(CrossValidateClassifier value) {
        this.m_CrossValidate = value;
    }

    public Class[] generates() {
        return new Class[]{Dataset.class};
    }

    public URL getWsdlLocation() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("wsdl/weka/WekaService.wsdl");
    }

    protected void doQuery() throws Exception {
        WekaServiceService wekaServiceService = new WekaServiceService(this.getWsdlLocation());
        WekaService wekaService = wekaServiceService.getWekaServicePort();
        WebserviceUtils.configureClient((Actor)this.m_Owner, (Object)wekaService, (int)this.m_ConnectionTimeout, (int)this.m_ReceiveTimeout, (String)(this.getUseAlternativeURL() ? this.getAlternativeURL() : null), (AbstractInInterceptorGenerator)this.m_InInterceptor, (AbstractOutInterceptorGenerator)this.m_OutInterceptor);
        WebserviceUtils.enableSchemaValidation((BindingProvider)((BindingProvider)wekaService));
        CrossValidateResponseObject returned = wekaService.crossValidateClassifier(this.m_CrossValidate.getDataset(), this.m_CrossValidate.getSeed(), this.m_CrossValidate.getFolds(), this.m_CrossValidate.getClassifier());
        if (returned.getErrorMessage() != null) {
            throw new IllegalStateException(returned.getErrorMessage());
        }
        this.setResponseData(returned.getReturnDataset());
        this.m_CrossValidate = null;
    }
}

