/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.flow.webservice.AbstractWebServiceProvider;
import adams.flow.webservice.OwnedByWekaServiceWS;
import adams.flow.webservice.SimpleWekaService;
import adams.flow.webservice.WebserviceUtils;
import javax.xml.ws.Endpoint;
import javax.xml.ws.soap.SOAPBinding;
import nz.ac.waikato.adams.webservice.weka.WekaService;
import org.apache.cxf.jaxws.EndpointImpl;

public class WekaServiceWS
extends AbstractWebServiceProvider {
    private static final long serialVersionUID = -6865165378146103361L;
    protected transient EndpointImpl m_Endpoint;
    protected WekaService m_Implementation;
    protected int m_ClassifierCacheSize;
    protected int m_ClustererCacheSize;

    public String globalInfo() {
        return "Provides a weka web service with the following services available:\n- training (classifiers/clusterers)\n- cross-validation (clusterers)\n- testing (classifiers)\n- making predictions (classifiers/clusterers)\n- list classifiers (classifiers/clusterers)\n- transform data\nEnable logging to see inbound/outgoing messages.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("implementation", "implementation", (Object)new SimpleWekaService());
        this.m_OptionManager.add("classifier-cache-size", "classifierCacheSize", (Object)10, (Number)1, null);
        this.m_OptionManager.add("clusterer-cache-size", "clustererCacheSize", (Object)10, (Number)1, null);
    }

    public String getDefaultURL() {
        return "http://localhost:9090/WekaServicePort";
    }

    public void setImplementation(WekaService value) {
        this.m_Implementation = value;
        this.reset();
    }

    public WekaService getImplementation() {
        return this.m_Implementation;
    }

    public String implementationTipText() {
        return "The implementation of the webservice to use.";
    }

    public void setClassifierCacheSize(int value) {
        if (value > 0) {
            this.m_ClassifierCacheSize = value;
            this.reset();
        } else {
            this.getLogger().severe("At least 1 classifier must be kept in memory, provided: " + value);
        }
    }

    public int getClassifierCacheSize() {
        return this.m_ClassifierCacheSize;
    }

    public String classifierCacheSizeTipText() {
        return "The number of classifiers to keep in memory.";
    }

    public void setClustererCacheSize(int value) {
        if (value > 0) {
            this.m_ClustererCacheSize = value;
            this.reset();
        } else {
            this.getLogger().severe("At least 1 clusterer must be kept in memory, provided: " + value);
        }
    }

    public int getClustererCacheSize() {
        return this.m_ClustererCacheSize;
    }

    public String clustererCacheSizeTipText() {
        return "The number of clusterers to keep in memory.";
    }

    protected void doStart() throws Exception {
        WekaService implementer = (WekaService)WebserviceUtils.copyImplementation((Object)this.m_Implementation);
        if (implementer instanceof OwnedByWekaServiceWS) {
            ((OwnedByWekaServiceWS)((Object)implementer)).setOwner(this);
        }
        this.m_Endpoint = (EndpointImpl)Endpoint.publish((String)this.getURL(), (Object)implementer);
        SOAPBinding binding = (SOAPBinding)this.m_Endpoint.getBinding();
        binding.setMTOMEnabled(true);
        this.configureInterceptors(this.m_Endpoint);
    }

    protected void doStop() throws Exception {
        if (this.m_Endpoint != null) {
            this.m_Endpoint.getServer().stop();
            this.m_Endpoint = null;
        }
    }
}

