/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.DatasetHelper;
import adams.flow.core.Token;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.transformer.AbstractTransformer;
import nz.ac.waikato.adams.webservice.weka.Dataset;
import nz.ac.waikato.adams.webservice.weka.TrainClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class WekaWSTrainClassifier
extends AbstractTransformer {
    private static final long serialVersionUID = 4879632007434246201L;
    protected CallableActorReference m_Classifier;
    protected String m_ModelName;

    public String globalInfo() {
        return "Trains a classifier on a dataset and makes the model available, using the Weka web-service.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new CallableActorReference(WekaClassifierSetup.class.getSimpleName()));
        this.m_OptionManager.add("model-name", "modelName", (Object)"");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)this.m_Classifier, (String)"classifier: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelName", (Object)this.m_ModelName, (String)", model: ");
        return result;
    }

    public void setClassifier(CallableActorReference c) {
        this.m_Classifier = c;
        this.reset();
    }

    public CallableActorReference getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "Classifier to use for training";
    }

    public void setModelName(String n) {
        this.m_ModelName = n;
        this.reset();
    }

    public String getModelName() {
        return this.m_ModelName;
    }

    public String modelNameTipText() {
        return "name";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{TrainClassifier.class};
    }

    protected Classifier getClassifierInstance() {
        MessageCollection errors = new MessageCollection();
        Classifier result = (Classifier)CallableActorHelper.getSetup(Classifier.class, (CallableActorReference)this.m_Classifier, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && this.getOptionManager().getVariableForProperty("modelName") == null && this.m_ModelName.trim().length() == 0) {
            result = "No model name provided!";
        }
        return result;
    }

    protected String doExecute() {
        TrainClassifier t = new TrainClassifier();
        Dataset d = DatasetHelper.fromInstances((Instances)this.m_InputToken.getPayload());
        t.setDataset(d);
        t.setClassifier(OptionUtils.getCommandLine((Object)this.getClassifierInstance()));
        t.setName(this.m_ModelName);
        this.m_OutputToken = new Token((Object)t);
        return null;
    }
}

