/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.weka;

import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.core.logging.LoggingSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.core.option.WekaCommandLineHandler;
import adams.data.spreadsheet.LookUpHelper;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.WekaDatasetHelper;
import adams.flow.webservice.weka.OwnedByWekaServiceWS;
import adams.flow.webservice.weka.WekaServiceWS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import nz.ac.waikato.adams.webservice.weka.Attributes;
import nz.ac.waikato.adams.webservice.weka.Body;
import nz.ac.waikato.adams.webservice.weka.CrossValidateResponseObject;
import nz.ac.waikato.adams.webservice.weka.Dataset;
import nz.ac.waikato.adams.webservice.weka.DisplayClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.DisplayClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.DownloadClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.DownloadClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.Header;
import nz.ac.waikato.adams.webservice.weka.Instance;
import nz.ac.waikato.adams.webservice.weka.InstanceType;
import nz.ac.waikato.adams.webservice.weka.OptimizeReturnObject;
import nz.ac.waikato.adams.webservice.weka.PredictClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.PredictClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.TestClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.TrainClassifierResponseObject;
import nz.ac.waikato.adams.webservice.weka.TrainClustererResponseObject;
import nz.ac.waikato.adams.webservice.weka.TransformResponseObject;
import nz.ac.waikato.adams.webservice.weka.Type;
import nz.ac.waikato.adams.webservice.weka.WekaService;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.MultiSearch;
import weka.classifiers.meta.multisearch.DefaultEvaluationMetrics;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.setupgenerator.AbstractParameter;

public class SimpleWekaService
extends AbstractOptionHandler
implements WekaService,
OwnedByWekaServiceWS {
    private static final long serialVersionUID = -6102580694812360595L;
    public static final String PREFIX_CLASSIFIER = "classifier.";
    public static final String PREFIX_CLUSTERER = "clusterer.";
    protected WekaServiceWS m_Owner;
    protected StorageName m_StorageName;

    public SimpleWekaService() {
        this.setOwner(null);
    }

    public String globalInfo() {
        return "Simple implementation of a WEKA webservice. Not multi-threaded.\nStores classifier models in look up table with prefix 'classifier.' and cluster models with prefix 'clusterer.'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    @Override
    public void setOwner(WekaServiceWS value) {
        this.m_Owner = value;
        if (this.m_Owner != null && this.m_Owner.getFlowContext() != null && !this.m_Owner.getFlowContext().getStorageHandler().getStorage().has(this.m_StorageName)) {
            throw new IllegalStateException("Lookup table for models not available: " + this.m_StorageName);
        }
    }

    @Override
    public WekaServiceWS getOwner() {
        return this.m_Owner;
    }

    protected void store(String name, Object model, boolean classifier) {
        HashMap table = LookUpHelper.getTable((Actor)this.m_Owner.getFlowContext(), (StorageName)this.m_StorageName);
        table.put((classifier ? PREFIX_CLASSIFIER : PREFIX_CLUSTERER) + name, model);
    }

    protected Object retrieve(String name, boolean classifier) {
        HashMap table = LookUpHelper.getTable((Actor)this.m_Owner.getFlowContext(), (StorageName)this.m_StorageName);
        return table.get((classifier ? PREFIX_CLASSIFIER : PREFIX_CLUSTERER) + name);
    }

    protected List<String> list(boolean classifier) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap table = LookUpHelper.getTable((Actor)this.m_Owner.getFlowContext(), (StorageName)this.m_StorageName);
        for (String key : table.keySet()) {
            if (classifier && key.startsWith(PREFIX_CLASSIFIER)) {
                result.add(key.substring(PREFIX_CLASSIFIER.length()));
                continue;
            }
            if (classifier || !key.startsWith(PREFIX_CLUSTERER)) continue;
            result.add(key.substring(PREFIX_CLUSTERER.length()));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public TrainClassifierResponseObject trainClassifier(Dataset dataset, String classifier, String name) {
        TrainClassifierResponseObject result = new TrainClassifierResponseObject();
        this.m_Owner.getLogger().info("training classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(classifier);
        this.m_Owner.getLogger().info(name);
        try {
            Instances data = WekaDatasetHelper.toInstances(dataset);
            Classifier cls = (Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)classifier);
            cls.buildClassifier(data);
            this.store(name, cls, true);
            result.setModel(cls.toString());
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to train classifier: " + classifier), (Throwable)ex));
        }
        return result;
    }

    @Override
    public TestClassifierResponseObject testClassifier(Dataset dataset, String modelName) {
        TestClassifierResponseObject result = new TestClassifierResponseObject();
        this.m_Owner.getLogger().info("testing classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        Classifier cls = (Classifier)this.retrieve(modelName, true);
        if (cls == null) {
            result.setErrorMessage("Failed to test model '" + modelName + "', as it is not available!");
            return result;
        }
        try {
            Instances data = WekaDatasetHelper.toInstances(dataset);
            Evaluation eval = new Evaluation(data);
            eval.evaluateModel(cls, data, new Object[0]);
            result.setReturnDataset(WekaDatasetHelper.evaluationToDataset(eval));
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to test model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public CrossValidateResponseObject crossValidateClassifier(Dataset dataset, int seed, int folds, String classifier) {
        CrossValidateResponseObject result = new CrossValidateResponseObject();
        this.m_Owner.getLogger().info("cross-validation");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info("" + seed);
        this.m_Owner.getLogger().info("" + folds);
        this.m_Owner.getLogger().info(classifier);
        try {
            Instances data = WekaDatasetHelper.toInstances(dataset);
            Classifier cls = (Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)classifier);
            Evaluation eval = new Evaluation(data);
            eval.crossValidateModel(cls, data, folds, new Random(seed), new Object[0]);
            result.setReturnDataset(WekaDatasetHelper.evaluationToDataset(eval));
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to cross-validate classifier '" + classifier + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public PredictClassifierResponseObject predictClassifier(Dataset dataset, String modelName) {
        PredictClassifierResponseObject result = new PredictClassifierResponseObject();
        this.m_Owner.getLogger().info("predicting using classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        Classifier cls = (Classifier)this.retrieve(modelName, true);
        if (cls == null) {
            result.setErrorMessage("Failed to make predictions using classifier model '" + modelName + "', as it is not available!");
            return result;
        }
        Instances data = WekaDatasetHelper.toInstances(dataset);
        if (data.classIndex() == -1) {
            result.setErrorMessage("No class attribute set!");
            return result;
        }
        try {
            int i;
            boolean nominal = data.classAttribute().isNominal();
            Attribute wAtt = data.classAttribute();
            Dataset pred = new Dataset();
            result.setReturnDataset(pred);
            pred.setName("Predictions on '" + data.relationName() + "' using '" + modelName + "'");
            pred.setVersion(WekaDatasetHelper.getDateFormat().format(new Date()));
            pred.setHeader(new Header());
            pred.getHeader().setAttributes(new Attributes());
            if (nominal) {
                WekaDatasetHelper.addAttribute(pred, "Classification", Type.STRING);
                for (i = 0; i < wAtt.numValues(); ++i) {
                    WekaDatasetHelper.addAttribute(pred, "Distribution (" + wAtt.value(i) + ")", Type.NUMERIC);
                }
            } else {
                WekaDatasetHelper.addAttribute(pred, "Classification", Type.NUMERIC);
            }
            pred.setBody(new Body());
            pred.getBody().setInstances(new nz.ac.waikato.adams.webservice.weka.Instances());
            for (i = 0; i < data.numInstances(); ++i) {
                double classification;
                weka.core.Instance inst = data.instance(i);
                inst.setClassMissing();
                Instance in = new Instance();
                in.setInstanceType(InstanceType.NORMAL);
                in.setInstanceWeight(1.0);
                pred.getBody().getInstances().getInstance().add(in);
                if (nominal) {
                    classification = cls.classifyInstance(inst);
                    WekaDatasetHelper.addValue(in, 0, wAtt.value((int)classification));
                    double[] distribution = cls.distributionForInstance(inst);
                    for (int n = 0; n < distribution.length; ++n) {
                        WekaDatasetHelper.addValue(in, 1 + n, distribution[n]);
                    }
                    continue;
                }
                classification = cls.classifyInstance(inst);
                WekaDatasetHelper.addValue(in, 0, classification);
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to make predictions with classifier model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public DownloadClassifierResponseObject downloadClassifier(String modelName) {
        DownloadClassifierResponseObject result = new DownloadClassifierResponseObject();
        this.m_Owner.getLogger().info("downloading classifier");
        this.m_Owner.getLogger().info(modelName);
        Classifier cls = (Classifier)this.retrieve(modelName, true);
        if (cls == null) {
            result.setErrorMessage("No Classifier available named: " + modelName);
            return result;
        }
        try {
            result.setModelData(new DataHandler((DataSource)new ByteArrayDataSource(SerializationHelper.toByteArray((Object)cls), "application/octet-stream")));
        }
        catch (Exception e) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this, (String)("Failed to serialize classifier: " + modelName), (Throwable)e));
        }
        return result;
    }

    @Override
    public DownloadClustererResponseObject downloadClusterer(String modelName) {
        DownloadClustererResponseObject result = new DownloadClustererResponseObject();
        this.m_Owner.getLogger().info("downloading clusterer");
        this.m_Owner.getLogger().info(modelName);
        Clusterer cls = (Clusterer)this.retrieve(modelName, false);
        if (cls == null) {
            result.setErrorMessage("No Clusterer available named: " + modelName);
            return result;
        }
        try {
            result.setModelData(new DataHandler((DataSource)new ByteArrayDataSource(SerializationHelper.toByteArray((Object)cls), "application/octet-stream")));
        }
        catch (Exception e) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this, (String)("Failed to serialize clusterer: " + modelName), (Throwable)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformResponseObject transform(Dataset dataset, String actorName) {
        TransformResponseObject result = new TransformResponseObject();
        this.m_Owner.getLogger().info("transform");
        CallableActorHelper helper = new CallableActorHelper();
        Actor callable = helper.findCallableActor(this.m_Owner.getFlowContext().getRoot(), new CallableActorReference(actorName));
        if (callable == null) {
            result.setErrorMessage("Failed to find callable actor '" + actorName + "'!");
            return result;
        }
        if (!ActorUtils.isTransformer((Actor)callable)) {
            result.setErrorMessage("Callable actor '" + actorName + "' is not a transformer!");
            return result;
        }
        Compatibility comp = new Compatibility();
        if (!comp.isCompatible(new Class[]{Instances.class}, ((InputConsumer)callable).accepts())) {
            result.setErrorMessage("Callable transformer '" + actorName + "' does not accept " + Instances.class.getName() + "!");
            return result;
        }
        if (!comp.isCompatible(((OutputProducer)callable).generates(), new Class[]{Instances.class})) {
            result.setErrorMessage("Callable transformer '" + actorName + "' does not generate " + Instances.class.getName() + "!");
            return result;
        }
        Instances data = WekaDatasetHelper.toInstances(dataset);
        try {
            Actor actor = callable;
            synchronized (actor) {
                ((InputConsumer)callable).input(new Token((Object)data));
                String msg = callable.execute();
                if (msg != null) {
                    result.setErrorMessage(msg);
                    return result;
                }
                if (!((OutputProducer)callable).hasPendingOutput()) {
                    result.setErrorMessage("Callable transformer '" + actorName + "' did not produce any output!");
                    return result;
                }
                Token output = ((OutputProducer)callable).output();
                data = (Instances)output.getPayload();
                result.setReturnDataset(WekaDatasetHelper.fromInstances(data));
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to transform data using callable transformer '" + actorName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public TrainClustererResponseObject trainClusterer(Dataset dataset, String clusterer, String modelName) {
        TrainClustererResponseObject result = new TrainClustererResponseObject();
        this.m_Owner.getLogger().info("training clusterer");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(clusterer);
        this.m_Owner.getLogger().info(modelName);
        try {
            Instances data = WekaDatasetHelper.toInstances(dataset);
            Clusterer cls = (Clusterer)OptionUtils.forAnyCommandLine(Clusterer.class, (String)clusterer);
            cls.buildClusterer(data);
            this.store(modelName, cls, false);
            result.setModel(cls.toString());
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to train clusterer: " + clusterer), (Throwable)ex));
        }
        return result;
    }

    @Override
    public PredictClustererResponseObject predictClusterer(Dataset dataset, String modelName) {
        PredictClustererResponseObject result = new PredictClustererResponseObject();
        this.m_Owner.getLogger().info("predicting using clusterer");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        Clusterer cls = (Clusterer)this.retrieve(modelName, false);
        if (cls == null) {
            result.setErrorMessage("Failed to make predictions using clusterer model '" + modelName + "', as it is not available!");
            return result;
        }
        Instances data = WekaDatasetHelper.toInstances(dataset);
        if (data.classIndex() != -1) {
            result.setErrorMessage("Dataset cannot have class attribute set!");
            return result;
        }
        try {
            int i;
            Dataset pred = new Dataset();
            result.setReturnDataset(pred);
            pred.setName("Predictions on '" + data.relationName() + "' using '" + modelName + "'");
            pred.setVersion(WekaDatasetHelper.getDateFormat().format(new Date()));
            pred.setHeader(new Header());
            pred.getHeader().setAttributes(new Attributes());
            WekaDatasetHelper.addAttribute(pred, "Cluster", Type.NUMERIC);
            int numClusters = cls.numberOfClusters();
            for (i = 0; i < numClusters; ++i) {
                WekaDatasetHelper.addAttribute(pred, "Cluster membership " + (i + 1), Type.NUMERIC);
            }
            pred.setBody(new Body());
            pred.getBody().setInstances(new nz.ac.waikato.adams.webservice.weka.Instances());
            for (i = 0; i < data.numInstances(); ++i) {
                weka.core.Instance inst = data.instance(i);
                Instance in = new Instance();
                in.setInstanceType(InstanceType.NORMAL);
                in.setInstanceWeight(1.0);
                pred.getBody().getInstances().getInstance().add(in);
                double cluster = cls.clusterInstance(inst);
                WekaDatasetHelper.addValue(in, 0, cluster + 1.0);
                double[] distribution = cls.distributionForInstance(inst);
                for (int n = 0; n < distribution.length; ++n) {
                    WekaDatasetHelper.addValue(in, 1 + n, distribution[n]);
                }
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to make predictions with model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public DisplayClassifierResponseObject displayClassifier(String model) {
        this.m_Owner.getLogger().info("displaying classifier: " + model);
        DisplayClassifierResponseObject result = new DisplayClassifierResponseObject();
        Classifier cls = (Classifier)this.retrieve(model, true);
        if (cls != null) {
            result.setDisplayString(cls.toString());
        } else {
            result.setErrorMessage("Classifier model '" + model + "' not available!");
        }
        return result;
    }

    @Override
    public DisplayClustererResponseObject displayClusterer(String model) {
        this.m_Owner.getLogger().info("displaying clusterer: " + model);
        DisplayClustererResponseObject result = new DisplayClustererResponseObject();
        Clusterer cls = (Clusterer)this.retrieve(model, false);
        if (cls != null) {
            result.setDisplayString(cls.toString());
        } else {
            result.setErrorMessage("Clusterer model '" + model + "' not available!");
        }
        return result;
    }

    @Override
    public List<String> listClassifiers() {
        this.m_Owner.getLogger().info("listing classifiers");
        List<String> result = this.list(true);
        if (this.m_Owner.isLoggingEnabled()) {
            this.m_Owner.getLogger().info("current classifiers" + result);
        }
        return result;
    }

    @Override
    public List<String> listClusterers() {
        this.m_Owner.getLogger().info("listing clusterers");
        List<String> result = this.list(false);
        if (this.m_Owner.isLoggingEnabled()) {
            this.m_Owner.getLogger().info("current clusterers: " + result);
        }
        return result;
    }

    @Override
    public OptimizeReturnObject optimizeClassifierMultiSearch(String classifier, List<String> searchParameters, Dataset dataset, String evaluation) {
        this.m_Owner.getLogger().info("optimizing classifiers using MultiSearch");
        OptimizeReturnObject result = new OptimizeReturnObject();
        WekaCommandLineHandler handler = new WekaCommandLineHandler();
        MultiSearch search = new MultiSearch();
        AbstractParameter[] params = new AbstractParameter[searchParameters.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = (AbstractParameter)handler.fromCommandLine(searchParameters.get(i));
        }
        search.setSearchParameters(params);
        if (evaluation.equals("ACC")) {
            search.setEvaluation(new SelectedTag(6, new DefaultEvaluationMetrics().getTags()));
        } else if (evaluation.equals("COMBINED")) {
            search.setEvaluation(new SelectedTag(5, new DefaultEvaluationMetrics().getTags()));
        } else if (evaluation.equals("CC")) {
            search.setEvaluation(new SelectedTag(0, new DefaultEvaluationMetrics().getTags()));
        } else if (evaluation.equals("KAPPA")) {
            search.setEvaluation(new SelectedTag(7, new DefaultEvaluationMetrics().getTags()));
        } else if (evaluation.equals("MAE")) {
            search.setEvaluation(new SelectedTag(3, new DefaultEvaluationMetrics().getTags()));
        } else if (evaluation.equals("RAE")) {
            search.setEvaluation(new SelectedTag(4, new DefaultEvaluationMetrics().getTags()));
        } else if (evaluation.equals("RMSE")) {
            search.setEvaluation(new SelectedTag(1, new DefaultEvaluationMetrics().getTags()));
        } else if (evaluation.equals("RRSE")) {
            search.setEvaluation(new SelectedTag(2, new DefaultEvaluationMetrics().getTags()));
        } else {
            result.setErrorMessage("Unhandled evaluation: " + evaluation);
        }
        search.setClassifier((Classifier)handler.fromCommandLine(classifier));
        if (result.getErrorMessage() == null) {
            try {
                search.buildClassifier(WekaDatasetHelper.toInstances(dataset));
                result.setBestClassifierSetup(handler.toCommandLine((Object)search.getBestClassifier()));
            }
            catch (Exception ex) {
                result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)"Failed to optimize classifier!", (Throwable)ex));
            }
        }
        return result;
    }

    protected void displayString(Dataset dataset) {
        if (!this.m_Owner.isLoggingEnabled()) {
            return;
        }
        this.m_Owner.getLogger().info("Number of instances: \t " + dataset.getBody().getInstances().getInstance().size());
        this.m_Owner.getLogger().info(WekaDatasetHelper.datasetToString(dataset));
    }
}

