/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.core.WekaDatasetHelper;
import adams.flow.source.WekaClustererSetup;
import adams.flow.transformer.AbstractTransformer;
import nz.ac.waikato.adams.webservice.weka.Dataset;
import nz.ac.waikato.adams.webservice.weka.TrainClusterer;
import weka.clusterers.Clusterer;
import weka.core.Instances;

public class WekaWSTrainClusterer
extends AbstractTransformer {
    private static final long serialVersionUID = -8770423757728884076L;
    protected CallableActorReference m_Clusterer;
    protected String m_ModelName;

    public String globalInfo() {
        return "Receives a dataset and prepares a traincluster input object, using the Weka web-service.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("clusterer", "clusterer", (Object)new CallableActorReference(WekaClustererSetup.class.getSimpleName()));
        this.m_OptionManager.add("model-name", "modelName", (Object)"");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"clusterer", (Object)this.m_Clusterer, (String)"clusterer: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelName", (Object)this.m_ModelName, (String)", model: ");
        return result;
    }

    public void setClusterer(CallableActorReference c) {
        this.m_Clusterer = c;
        this.reset();
    }

    public CallableActorReference getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "Clusterer to use for training";
    }

    public void setModelName(String n) {
        this.m_ModelName = n;
        this.reset();
    }

    public String getModelName() {
        return this.m_ModelName;
    }

    public String modelNameTipText() {
        return "name";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{TrainClusterer.class};
    }

    protected Clusterer getClustererInstance() {
        MessageCollection errors = new MessageCollection();
        Clusterer result = (Clusterer)CallableActorHelper.getSetup(Clusterer.class, (CallableActorReference)this.m_Clusterer, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && this.getOptionManager().getVariableForProperty("modelName") == null && this.m_ModelName.trim().length() == 0) {
            result = "No model name provided!";
        }
        return result;
    }

    protected String doExecute() {
        TrainClusterer t = new TrainClusterer();
        t.setClusterer(OptionUtils.getCommandLine((Object)this.getClustererInstance()));
        t.setModelName(this.m_ModelName);
        Dataset d = WekaDatasetHelper.fromInstances((Instances)this.m_InputToken.getPayload());
        t.setDataset(d);
        this.m_OutputToken = new Token((Object)t);
        return null;
    }
}

